/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.chat;

import com.forgeessentials.chat.Mail;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;

public class MailSystem {
    private static HashMultimap<UUID, Mail> map = HashMultimap.create();

    public static void AddMail(Mail mail) {
        map.put((Object)mail.getReceiver(), (Object)mail);
        DataManager.getInstance().save(Mail.class, mail.getKey());
        EntityPlayerMP player = UserIdent.getPlayerByUuid(mail.getReceiver());
        if (player != null) {
            MailSystem.receiveMail((EntityPlayer)player);
        }
    }

    public static void LoadAll() {
        Map<String, Mail> loaded = DataManager.getInstance().loadAll(Mail.class);
        for (Mail mail : loaded.values()) {
            map.put((Object)mail.getReceiver(), (Object)mail);
        }
    }

    public static void SaveAll() {
        for (Mail mail : map.values()) {
            DataManager.getInstance().save(Mail.class, mail.getKey());
        }
    }

    public static void receiveMail(EntityPlayer receiver) {
        if (map.containsKey((Object)receiver.getPersistentID())) {
            OutputHandler.sendMessage((ICommandSender)receiver, EnumChatFormatting.GREEN + "--- Your mail ---");
            for (Mail mail : map.get((Object)receiver.getPersistentID())) {
                OutputHandler.sendMessage((ICommandSender)receiver, EnumChatFormatting.GREEN + "{" + mail.getSender() + "} " + EnumChatFormatting.WHITE + mail.getMessage());
                DataManager.getInstance().delete(Mail.class, mail.getKey());
            }
            OutputHandler.sendMessage((ICommandSender)receiver, EnumChatFormatting.GREEN + "--- End of mail ---");
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        MailSystem.receiveMail(e.player);
    }
}

