/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.chat;

import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import java.rmi.server.UID;
import java.util.UUID;

@SaveableObject
public class Mail {
    @SaveableObject.UniqueLoadingKey
    @SaveableObject.SaveableField
    private String key;
    @SaveableObject.SaveableField
    private String sender;
    @SaveableObject.SaveableField
    private String receiver;
    @SaveableObject.SaveableField
    private String message;

    public Mail(String key, UUID sender, UUID receiver, String message2) {
        if (key == null || key.isEmpty()) {
            key = new UID().toString().replaceAll(":", "_");
        }
        this.key = key;
        this.sender = sender.toString();
        this.receiver = receiver.toString();
        this.message = message2;
    }

    public Mail(String key, String sender, String receiver, String message2) {
        if (key == null || key.isEmpty()) {
            key = new UID().toString().replaceAll(":", "_");
        }
        this.key = key;
        this.sender = sender;
        this.receiver = receiver;
        this.message = message2;
    }

    @SaveableObject.Reconstructor
    private static Mail reconstruct(IReconstructData tag) {
        return new Mail((String)tag.getFieldValue("key"), (String)tag.getFieldValue("sender"), (String)tag.getFieldValue("receiver"), (String)tag.getFieldValue("message"));
    }

    public String getKey() {
        return this.key;
    }

    public UUID getSender() {
        return UUID.fromString(this.sender);
    }

    public UUID getReceiver() {
        return UUID.fromString(this.receiver);
    }

    public String getMessage() {
        return this.message;
    }
}

