/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.backup;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.backup.AutoBackup;
import com.forgeessentials.backup.AutoWorldSave;
import com.forgeessentials.backup.Backup;
import com.forgeessentials.backup.BackupConfig;
import com.forgeessentials.backup.CommandBackup;
import com.forgeessentials.backup.WorldSaver;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.permissions.PermissionsManager;

@FEModule(name="Backups", parentMod=ForgeEssentials.class)
public class ModuleBackup {
    @FEModule.ModuleDir
    public static File moduleDir;
    public static File baseFolder;
    private Timer timer = new Timer();
    private WorldSaver worldSaver;

    public static void msg(String msg) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (!BackupConfig.enableMsg) {
            return;
        }
        try {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                OutputHandler.felog.info(msg);
            } else {
                OutputHandler.sendMessage((ICommandSender)server, "[ForgeEssentials] " + msg);
            }
            ServerConfigurationManager manager = server.func_71203_ab();
            for (String username : manager.func_72369_d()) {
                EntityPlayerMP player = manager.func_152612_a(username);
                if (!PermissionsManager.checkPermission((EntityPlayer)player, "fe.backup.msg")) continue;
                OutputHandler.chatNotification((ICommandSender)player, "[ForgeEssentials] " + msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void load(FEModuleEvent.FEModuleInitEvent e) {
        ForgeEssentials.getConfigManager().registerLoader("Backups", new BackupConfig());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.worldSaver = new WorldSaver();
    }

    @SubscribeEvent
    public void serverStarting(FEModuleEvent.FEModuleServerInitEvent e) {
        FunctionHelper.registerServerCommand(new CommandBackup());
        if (BackupConfig.autoInterval != 0) {
            this.timer.schedule((TimerTask)new AutoBackup(), BackupConfig.autoInterval * 60 * 1000, (long)(BackupConfig.autoInterval * 60 * 1000));
        }
        if (BackupConfig.worldSaveInterval != 0) {
            this.timer.schedule((TimerTask)new AutoWorldSave(), BackupConfig.worldSaveInterval * 60 * 1000, (long)(BackupConfig.worldSaveInterval * 60 * 1000));
        }
        ModuleBackup.makeReadme();
        APIRegistry.perms.registerPermission("fe.backup.msg", PermissionsManager.RegisteredPermValue.TRUE);
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && BackupConfig.backupOnWorldUnload) {
            new Backup((WorldServer)e.world, false).run();
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            ((WorldServer)e.world).field_73058_d = !BackupConfig.worldSaving;
        }
    }

    private static void makeReadme() {
        try {
            File file;
            if (!baseFolder.exists()) {
                baseFolder.mkdirs();
            }
            if ((file = new File(baseFolder, "README.txt")).exists()) {
                return;
            }
            try (PrintWriter pw = new PrintWriter(file);){
                pw.println("############");
                pw.println("## WARNING ##");
                pw.println("############");
                pw.println("");
                pw.println("DON'T CHANGE ANYTHING IN THIS FOLDER.");
                pw.println("IF YOU DO, AUTOREMOVE WILL SCREW UP.");
                pw.println("");
                pw.println("If you have problems with this, report an issue and don't put:");
                pw.println("\"Yes, I read the readme\" in the issue or your message on github,");
                pw.println("YOU WILL BE IGNORED.");
                pw.println("- The FE Team");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

