/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.backup;

import com.forgeessentials.backup.BackupConfig;
import com.forgeessentials.backup.ModuleBackup;
import com.forgeessentials.util.OutputHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class Backup
implements Runnable {
    private Thread thread;
    private WorldServer world;
    private boolean isWorld;
    private String name;
    private File basefolder = ModuleBackup.baseFolder;
    private File folder;
    private List<String> fileList;
    private File source;
    private String backupName;
    private boolean worldSave;
    private boolean done = false;

    public Backup(boolean worldSave) {
        Integer[] arr$ = DimensionManager.getIDs();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            new Backup(i, worldSave);
        }
    }

    public Backup(int dim, boolean worldSave) {
        this.isWorld = true;
        this.worldSave = worldSave;
        this.world = DimensionManager.getWorld((int)dim);
        if (BackupConfig.backupIfUnloaded || BackupConfig.whitelist.contains(dim)) {
            if (this.world == null) {
                DimensionManager.initDimension((int)dim);
                this.world = DimensionManager.getWorld((int)dim);
            }
        } else if (this.world == null) {
            return;
        }
        this.name = this.world.func_72912_H().func_76065_j() + " DIM " + dim;
        this.source = this.world.getChunkSaveLocation();
        this.folder = new File(this.basefolder, (this.world.func_72912_H().func_76065_j() + "/DIM " + this.world.field_73011_w.field_76574_g).replaceAll(" ", "_"));
        this.backupName = this.getFilename() + ".zip";
        this.thread = new Thread((Runnable)this, "ForgeEssentials - Backup - " + this.name);
    }

    public Backup(WorldServer world, boolean worldSave) {
        this.isWorld = true;
        this.worldSave = worldSave;
        this.world = world;
        this.name = world.func_72912_H().func_76065_j() + " DIM " + world.field_73011_w.field_76574_g;
        this.source = world.getChunkSaveLocation();
        this.folder = new File(this.basefolder, (world.func_72912_H().func_76065_j() + "/DIM " + world.field_73011_w.field_76574_g).replaceAll(" ", "_"));
        this.backupName = this.getFilename() + ".zip";
        this.thread = new Thread((Runnable)this, "ForgeEssentials - Backup - " + this.name);
    }

    public Backup(File folder) {
        this.isWorld = false;
        this.name = folder.getName();
        this.source = folder;
        this.folder = new File(this.basefolder, this.name.replaceAll(" ", "_"));
        this.backupName = this.getFilename() + ".zip";
        this.thread = new Thread((Runnable)this, "ForgeEssentials - Backup - " + this.name);
    }

    public void startThread() {
        if (this.thread != null && !this.thread.isAlive()) {
            this.thread.start();
        }
    }

    @Override
    public void run() {
        ModuleBackup.msg("Starting backup of " + this.name);
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        boolean canNotSave = true;
        if (this.isWorld && this.worldSave) {
            canNotSave = this.world.field_73058_d;
            this.world.field_73058_d = false;
            try {
                this.world.func_73044_a(true, (IProgressUpdate)null);
                this.doFolder(this.source);
            }
            catch (Exception e) {
                e.printStackTrace();
                ModuleBackup.msg("Error while making backup of " + this.name);
                ModuleBackup.msg(e.toString());
            }
        }
        this.doFolder(this.source);
        if (this.isWorld && this.worldSave) {
            this.world.field_73058_d = canNotSave;
        }
        ModuleBackup.msg("Backup of " + this.name + " done.");
        this.done = true;
        System.gc();
    }

    private String getFilename() {
        Calendar cal = Calendar.getInstance();
        Integer day = cal.get(5);
        Integer month = cal.get(2);
        month = month + 1;
        Integer year = cal.get(1);
        Integer hour = cal.get(11);
        Integer min = cal.get(12);
        return BackupConfig.backupName.replaceAll("%day", day.toString()).replaceAll("%month", month.toString()).replaceAll("%year", year.toString()).replaceAll("%hour", hour.toString()).replaceAll("%min", min.toString()).replaceAll("%name", this.name.replaceAll(" ", "_"));
    }

    private void doFolder(File folder) {
        this.fileList = new ArrayList<String>();
        String dir = folder.getAbsolutePath().replace(folder.getName(), "");
        this.generateFileList(dir, folder);
        this.zipIt(dir);
    }

    private void generateFileList(String dir, File node) {
        if (node.isFile()) {
            this.fileList.add(this.generateZipEntry(dir, node.getAbsolutePath().toString()));
        }
        if (node.isDirectory()) {
            String[] subNote;
            for (String filename : subNote = node.list()) {
                if (filename.startsWith("DIM")) continue;
                this.generateFileList(dir, new File(node, filename));
            }
        }
    }

    private String generateZipEntry(String dir, String file) {
        return file.substring(dir.length(), file.length());
    }

    private void zipIt(String dir) {
        if (this.fileList.isEmpty()) {
            OutputHandler.felog.info("No files to backup in " + dir);
            return;
        }
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.folder, this.backupName));
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (String file : this.fileList) {
                int len;
                ZipEntry ze = new ZipEntry(file);
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(dir + file);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            zos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isDone() {
        return this.done;
    }
}

