/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.backup;

import com.forgeessentials.backup.Backup;
import com.forgeessentials.backup.BackupConfig;
import com.forgeessentials.backup.ModuleBackup;
import com.forgeessentials.backup.WorldSaver;
import com.forgeessentials.util.OutputHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TimerTask;
import net.minecraftforge.common.DimensionManager;

public class AutoBackup
extends TimerTask {
    public static boolean isBackingUp = false;

    @Override
    public void run() {
        Backup backup;
        while (WorldSaver.isSaving()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        isBackingUp = true;
        HashSet<Integer> list = new HashSet<Integer>();
        list.addAll(Arrays.asList(DimensionManager.getIDs()));
        list.removeAll(BackupConfig.blacklist);
        list.addAll(BackupConfig.whitelist);
        Iterator<Object> i$ = list.iterator();
        block7: while (i$.hasNext()) {
            int i = (Integer)i$.next();
            backup = new Backup(i, true);
            backup.startThread();
            while (!backup.isDone()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    continue block7;
                }
            }
        }
        block9: for (String folder : BackupConfig.extraFolders) {
            if (folder.equals("")) continue;
            backup = new Backup(new File(folder));
            backup.startThread();
            while (!backup.isDone()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    continue block9;
                }
            }
        }
        isBackingUp = false;
        if (BackupConfig.enableAutoRemove) {
            if (BackupConfig.minimunFreeSpace != -1) {
                AutoBackup.diskSpaceCheck();
            }
            if (BackupConfig.maxfilesperbackupfolder != -1) {
                AutoBackup.checkMaxFilesPerFolder(ModuleBackup.baseFolder);
            }
            if (BackupConfig.maxBackupLifespan != -1) {
                AutoBackup.checkMaxFBackupLifespan();
            }
        }
        System.gc();
    }

    public static void checkMaxFBackupLifespan() {
        File[] folders;
        for (File folder : folders = AutoBackup.getFolderList(ModuleBackup.baseFolder)) {
            if (folder.isDirectory()) {
                AutoBackup.loopThroughFolder(folder);
            }
            AutoBackup.loopThroughFolder(folder);
        }
    }

    private static void loopThroughFolder(File folder) {
        File[] files = folder.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
            }
        });
        for (File file : files) {
            if (System.currentTimeMillis() <= file.lastModified() + (long)(BackupConfig.maxBackupLifespan * 3600000)) continue;
            try {
                Files.delete(file.toPath());
                OutputHandler.felog.info("Deleted file " + file.getPath());
            }
            catch (IOException e) {
                OutputHandler.felog.severe("Could not delete file");
                e.printStackTrace();
            }
        }
    }

    public static void checkMaxFilesPerFolder(File directory) {
        File[] folders;
        for (File folder : folders = AutoBackup.getFolderList(directory)) {
            AutoBackup.checkMaxFilesPerFolder(folder);
            LinkedList<File> fileList = new LinkedList<File>(Arrays.asList(AutoBackup.sortByLastModified(folder)));
            int trys = 0;
            while (fileList.size() > BackupConfig.maxfilesperbackupfolder && trys < 5) {
                File toDelete = fileList.remove();
                if (toDelete.isDirectory()) continue;
                try {
                    Files.delete(toDelete.toPath());
                    OutputHandler.felog.info("Deleted file " + toDelete.getPath());
                }
                catch (IOException e) {
                    OutputHandler.felog.severe("Try #" + trys + "Removed file: " + toDelete.getAbsolutePath());
                    OutputHandler.felog.severe("Could not delete file");
                    ++trys;
                    e.printStackTrace();
                }
            }
        }
    }

    public static void diskSpaceCheck() {
        if (ModuleBackup.baseFolder.getFreeSpace() / 1024L / 1024L / 1024L < (long)BackupConfig.minimunFreeSpace.intValue()) {
            OutputHandler.felog.warning("Low disk space. Removing old backups.");
            int trys = 0;
            while (ModuleBackup.baseFolder.getFreeSpace() / 1024L / 1024L / 1024L < (long)BackupConfig.minimunFreeSpace.intValue() && trys < 5) {
                File[] folders;
                OutputHandler.debug("try " + trys);
                for (File folder : folders = AutoBackup.getFolderList(ModuleBackup.baseFolder)) {
                    LinkedList<File> fileList = new LinkedList<File>(Arrays.asList(folder));
                    File toDelete = fileList.remove();
                    if (toDelete.isDirectory()) continue;
                    try {
                        Files.delete(toDelete.toPath());
                        OutputHandler.felog.info("Deleted file " + toDelete.getPath());
                    }
                    catch (IOException e) {
                        OutputHandler.felog.severe("Try #" + trys + "Removed file: " + toDelete.getAbsolutePath());
                        OutputHandler.felog.severe("Could not delete file");
                        e.printStackTrace();
                        ++trys;
                    }
                }
            }
        }
    }

    public static File[] getFolderList(File baseFolder) {
        return baseFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    public static File[] sortByLastModified(File folder) {
        File[] files = folder.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
            }
        });
        return files;
    }
}

