/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.auth;

import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.data.v2.DataManager;
import java.util.HashMap;
import java.util.UUID;

@SaveableObject
public class PlayerPassData {
    private static HashMap<UUID, PlayerPassData> datas = new HashMap();
    @SaveableObject.UniqueLoadingKey
    @SaveableObject.SaveableField
    public final String username;
    @SaveableObject.SaveableField
    public String password;

    public PlayerPassData(UUID username, String password) {
        this.username = username.toString();
        this.password = password;
    }

    public static PlayerPassData getData(UUID username) {
        PlayerPassData data = datas.get(username);
        if (data == null) {
            data = DataManager.getInstance().load(PlayerPassData.class, username.toString());
        }
        return data;
    }

    public static void registerData(UUID username, String pass) {
        PlayerPassData data = new PlayerPassData(username, pass);
        data.save();
        if (datas.get(data.username) != null) {
            datas.put(UUID.fromString(data.username), data);
        }
    }

    public static void discardData(UUID username) {
        PlayerPassData data = datas.remove(username);
        if (data != null) {
            data.save();
        }
    }

    public static void deleteData(UUID username) {
        PlayerPassData data = datas.remove(username);
        DataManager.getInstance().delete(PlayerPassData.class, username.toString());
    }

    @SaveableObject.Reconstructor
    private static PlayerPassData reconstruct(IReconstructData data) {
        String username = data.getUniqueKey();
        String pass = (String)data.getFieldValue("password");
        return new PlayerPassData(UUID.fromString(username), pass);
    }

    public void save() {
        DataManager.getInstance().save(this, this.username);
    }
}

