/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.auth;

import com.forgeessentials.auth.ModuleAuth;
import com.forgeessentials.auth.PlayerPassData;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.commands.PermissionDeniedException;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandAuth
extends ForgeEssentialsCommandBase {
    private static String[] playerCommands = new String[]{"help", "login", "register", "changepass", "kick", "setpass", "unregister"};
    private static String[] serverCommands = new String[]{"help", "kick", "setpass", "unregister"};

    public String func_71517_b() {
        return "auth";
    }

    public List<?> func_71514_a() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("AUTH");
        return list;
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 0) {
            throw new WrongUsageException("command.auth.usage", new Object[0]);
        }
        boolean hasAdmin = PermissionsManager.checkPermission((EntityPlayer)sender, this.getPermissionNode() + ".admin");
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("help")) {
                OutputHandler.chatConfirmation((ICommandSender)sender, " - /auth register <password>");
                OutputHandler.chatConfirmation((ICommandSender)sender, " - /auth login <password>");
                OutputHandler.chatConfirmation((ICommandSender)sender, " - /auth changepass <oldpass> <newpass>  - changes your password");
                if (!hasAdmin) {
                    return;
                }
                OutputHandler.chatConfirmation((ICommandSender)sender, " - /auth kick <player>  - forces the player to login again");
                OutputHandler.chatConfirmation((ICommandSender)sender, " - /auth setpass <player> <password>  - sets the players password");
                OutputHandler.chatConfirmation((ICommandSender)sender, " - /auth unregister <player>  - forces the player to register again");
                return;
            }
            throw new WrongUsageException("/auth help", new Object[0]);
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("login")) {
                PlayerPassData data = PlayerPassData.getData(sender.getPersistentID());
                if (data == null) {
                    OutputHandler.chatError((ICommandSender)sender, String.format("Player %s is not registered!", sender.getPersistentID()));
                    return;
                }
                String pass = ModuleAuth.encrypt(args[1]);
                if (data.password.equals(pass)) {
                    ModuleAuth.hasSession.add(sender.getPersistentID());
                    OutputHandler.chatConfirmation((ICommandSender)sender, "Login successful.");
                } else {
                    OutputHandler.chatError((ICommandSender)sender, "Login failed.");
                }
                return;
            }
            if (args[0].equalsIgnoreCase("register")) {
                if (PlayerPassData.getData(sender.getPersistentID()) != null) {
                    OutputHandler.chatError((ICommandSender)sender, String.format("Player %s is already registered!", sender.getPersistentID()));
                    return;
                }
                if (ModuleAuth.isEnabled() && !ModuleAuth.allowOfflineReg) {
                    OutputHandler.chatError((ICommandSender)sender, "Registrations have been disabled.");
                    return;
                }
                String pass = ModuleAuth.encrypt(args[1]);
                PlayerPassData.registerData(sender.getPersistentID(), pass);
                OutputHandler.chatConfirmation((ICommandSender)sender, "Registration successful.");
                return;
            }
            if (!ModuleAuth.hasSession.contains(sender.getPersistentID())) {
                OutputHandler.chatError((ICommandSender)sender, "Login required. Try /auth help.");
                return;
            }
            UUID name = UserIdent.getUuidByUsername(args[1]);
            boolean isLogged = true;
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[1]);
            if (player == null) {
                OutputHandler.chatWarning((ICommandSender)sender, "A player of that name is not on the server. Doing the action anyways.");
                isLogged = false;
            }
            if (args[0].equalsIgnoreCase("kick")) {
                if (!hasAdmin) {
                    throw new PermissionDeniedException();
                }
                if (!isLogged) {
                    throw new PlayerNotFoundException();
                }
                ModuleAuth.hasSession.remove(name);
                OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Player %s was logged out from the authentication service.", name));
                OutputHandler.chatWarning((ICommandSender)player, "You have been logged out from the authentication service. Please login again.");
                return;
            }
            if (args[0].equalsIgnoreCase("setPass")) {
                if (!hasAdmin) {
                    throw new PermissionDeniedException();
                }
                throw new WrongUsageException("/auth setpass <player> <password>", new Object[0]);
            }
            if (args[0].equalsIgnoreCase("unregister")) {
                if (!hasAdmin) {
                    throw new PermissionDeniedException();
                }
                if (PlayerPassData.getData(name) == null) {
                    throw new WrongUsageException(String.format("Player %s is not registered!", name), new Object[0]);
                }
                PlayerPassData.deleteData(name);
                OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Player %s has been removed from the authentication service.", name));
                return;
            }
            throw new WrongUsageException("/auth help", new Object[0]);
        }
        if (args.length == 3) {
            if (!ModuleAuth.hasSession.contains(sender.getPersistentID())) {
                OutputHandler.chatError((ICommandSender)sender, "Login required. Try /auth help.");
                return;
            }
            if (args[0].equalsIgnoreCase("changepass")) {
                UUID name = sender.getPersistentID();
                PlayerPassData data = PlayerPassData.getData(name);
                if (data == null) {
                    throw new WrongUsageException(String.format("Player %s is not registered!", name), new Object[0]);
                }
                String oldpass = ModuleAuth.encrypt(args[1]);
                String newPass = ModuleAuth.encrypt(args[2]);
                if (args[1].equals(args[2])) {
                    OutputHandler.chatConfirmation((ICommandSender)sender, "You can't use this new password - it's the same as what was previously there.");
                    return;
                }
                if (!data.password.equals(oldpass)) {
                    OutputHandler.chatConfirmation((ICommandSender)sender, "Could not change the password - your old password is wrong");
                    return;
                }
                data.password = newPass;
                data.save();
                OutputHandler.chatConfirmation((ICommandSender)sender, "Password change successful.");
                return;
            }
            UUID name = UserIdent.getUuidByUsername(args[1]);
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[1]);
            if (player == null) {
                OutputHandler.chatWarning((ICommandSender)sender, "A player of that name is not on the server. Doing the action anyways.");
            }
            if (args[0].equalsIgnoreCase("setPass")) {
                if (!hasAdmin) {
                    throw new PermissionDeniedException();
                }
                PlayerPassData data = PlayerPassData.getData(name);
                String encrypted = ModuleAuth.encrypt(args[2]);
                if (data == null) {
                    PlayerPassData.registerData(name, encrypted);
                } else {
                    data.password = encrypted;
                    data.save();
                }
                OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Password set for %s", name));
            }
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            throw new WrongUsageException("/auth help", new Object[0]);
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("help")) {
                OutputHandler.chatNotification(sender, " - /auth kick <player>  - forces the player to login again");
                OutputHandler.chatNotification(sender, " - /auth setpass <player> <password>  - sets the players password to the specified");
                OutputHandler.chatNotification(sender, " - /auth unregister <player>  - forces the player to register again");
                return;
            }
            throw new WrongUsageException("/auth help", new Object[0]);
        }
        UUID name = UserIdent.getUuidByUsername(args[1]);
        boolean isLogged = true;
        EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, args[1]);
        if (player == null) {
            OutputHandler.chatWarning(sender, "A player of that name is not on the server. Doing the action anyways.");
            isLogged = false;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("kick")) {
                if (!isLogged) {
                    throw new WrongUsageException("/auth kick <player", new Object[0]);
                }
                ModuleAuth.hasSession.remove(name);
                OutputHandler.chatConfirmation(sender, String.format("Player %s was logged out from the authentication service.", name));
                OutputHandler.chatWarning((ICommandSender)player, "You have been logged out from the authentication service. Please login again.");
                return;
            }
            if (args[0].equalsIgnoreCase("setPass")) {
                throw new WrongUsageException("/auth setpass <player> <password>", new Object[0]);
            }
            if (args[0].equalsIgnoreCase("unregister")) {
                if (PlayerPassData.getData(name) == null) {
                    throw new WrongUsageException("message.auth.error.notregisterred", new Object[]{"name"});
                }
                PlayerPassData.deleteData(name);
                return;
            }
            throw new WrongUsageException("command.auth.usage", new Object[0]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("setPass")) {
            PlayerPassData data = PlayerPassData.getData(name);
            String encrypted = ModuleAuth.encrypt(args[2]);
            if (data == null) {
                PlayerPassData.registerData(name, encrypted);
            } else {
                data.password = encrypted;
                data.save();
            }
            OutputHandler.chatConfirmation(sender, String.format("Password set for %s", name));
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                if (sender instanceof EntityPlayer) {
                    list.addAll(CommandAuth.func_71530_a((String[])args, (String[])playerCommands));
                    break;
                }
                list.addAll(CommandAuth.func_71530_a((String[])args, (String[])serverCommands));
                break;
            }
            case 2: {
                if (!args[0].equalsIgnoreCase("kick") && !args[0].equalsIgnoreCase("setpass") && !args[0].equalsIgnoreCase("unregister")) break;
                list.addAll(CommandAuth.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z()));
            }
        }
        return list;
    }

    @Override
    public String getPermissionNode() {
        return "fe.auth";
    }

    public String func_71518_a(ICommandSender sender) {
        String s = "/auth help";
        s = sender instanceof EntityPlayer ? s + " Manages your authentication profile." : s + " Controls the authentication module.";
        return s;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }
}

