/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.auth;

import com.forgeessentials.auth.CommandAuth;
import com.forgeessentials.auth.ModuleAuth;
import com.forgeessentials.auth.PlayerPassData;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.PlayerMoveEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.permissions.PermissionsManager;

public class AuthEventHandler {
    public static String banned;
    public static String notvip;
    public static String notwhitelisted;
    public static boolean whitelist;
    public static int vipslots;
    public static int offset;
    public int counter;
    public int maxcounter;

    public AuthEventHandler() {
        OutputHandler.felog.info("FEauth initialized. Enabled: " + ModuleAuth.isEnabled());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        UUID username = event.entityPlayer.getPersistentID();
        if (event.before.getX() == event.after.getX() && event.before.getZ() == event.after.getZ()) {
            return;
        }
        if (ModuleAuth.canMoveWithoutLogin) {
            return;
        }
        if (!ModuleAuth.hasSession.contains(username)) {
            event.setCanceled(true);
            OutputHandler.chatError((ICommandSender)event.entityPlayer, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerChat(ServerChatEvent event) {
        UUID username = event.player.getPersistentID();
        if (!ModuleAuth.hasSession.contains(username)) {
            event.setCanceled(true);
            OutputHandler.chatError((ICommandSender)event.player, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerCommand(CommandEvent event) {
        if (!(event.sender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.sender;
        if (!ModuleAuth.hasSession.contains(player.getPersistentID()) && !(event.command instanceof CommandAuth)) {
            event.setCanceled(true);
            OutputHandler.chatError((ICommandSender)player, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        UUID username = event.entityPlayer.getPersistentID();
        if (!ModuleAuth.hasSession.contains(username)) {
            event.setCanceled(true);
            OutputHandler.chatError((ICommandSender)event.entityPlayer, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(EntityInteractEvent event) {
        UUID username = event.entityPlayer.getPersistentID();
        if (!ModuleAuth.hasSession.contains(username)) {
            event.setCanceled(true);
            OutputHandler.chatError((ICommandSender)event.entityPlayer, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(MinecartInteractEvent event) {
        UUID username = event.player.getPersistentID();
        if (!ModuleAuth.hasSession.contains(username)) {
            event.setCanceled(true);
            OutputHandler.chatError((ICommandSender)event.player, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerTossItem(ItemTossEvent event) {
        UUID username = event.player.getPersistentID();
        boolean cancel = false;
        if (!ModuleAuth.hasSession.contains(username)) {
            cancel = true;
            OutputHandler.chatError((ICommandSender)event.player, "Login required. Try /auth help.");
        }
        if (cancel) {
            ItemStack stack = event.entityItem.func_92059_d();
            event.player.field_71071_by.func_70441_a(stack);
            event.setCanceled(cancel);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerPickupItem(EntityItemPickupEvent event) {
        UUID username = event.entityPlayer.getPersistentID();
        if (!ModuleAuth.hasSession.contains(username)) {
            event.setCanceled(true);
            OutputHandler.chatError((ICommandSender)event.entityPlayer, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerHurt(LivingHurtEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        if (!ModuleAuth.hasSession.contains(player.getPersistentID())) {
            event.setCanceled(true);
            OutputHandler.chatError((ICommandSender)player, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerAttack(AttackEntityEvent event) {
        UUID username = event.entityPlayer.getPersistentID();
        if (!ModuleAuth.hasSession.contains(username)) {
            event.setCanceled(true);
            OutputHandler.chatError((ICommandSender)event.entityPlayer, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerOpenContainer(PlayerOpenContainerEvent event) {
        UUID username = event.entityPlayer.getPersistentID();
        if (!ModuleAuth.hasSession.contains(username)) {
            event.setResult(Event.Result.DENY);
            OutputHandler.chatError((ICommandSender)event.entityPlayer, "Login required. Try /auth help.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!ModuleAuth.isEnabled()) {
            return;
        }
        PlayerPassData data = PlayerPassData.getData(e.player.getPersistentID());
        if (data == null) {
            OutputHandler.chatError((ICommandSender)e.player, "Registration required. Try /auth help.");
        } else {
            OutputHandler.chatError((ICommandSender)e.player, "Login required. Try /auth help.");
        }
        this.maxcounter = FMLCommonHandler.instance().getMinecraftServerInstance().func_71275_y() - vipslots - offset;
        if (whitelist && !PermissionsManager.checkPermission(e.player, "fe.auth.isWhiteListed")) {
            ((EntityPlayerMP)e.player).field_71135_a.func_147360_c(notwhitelisted);
        }
        if (PermissionsManager.checkPermission(e.player, "fe.auth.isVIP")) {
            return;
        }
        if (this.counter == this.maxcounter) {
            ((EntityPlayerMP)e.player).field_71135_a.func_147360_c(notvip);
        } else {
            ++this.counter;
        }
    }

    @SubscribeEvent
    public void onLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        ModuleAuth.hasSession.remove(e.player.getPersistentID());
        PlayerPassData.discardData(e.player.getPersistentID());
    }
}

