/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.api.remote;

import com.forgeessentials.api.remote.RemoteRequest;
import com.google.gson.JsonElement;

public class RemoteResponse<T> {
    public String id;
    public int rid;
    public boolean success;
    public String message;
    public T data;

    public RemoteResponse(String id, int rid, boolean success, String message2, T data) {
        this.id = id;
        this.rid = rid;
        this.success = success;
        this.message = message2;
        this.data = data;
    }

    public RemoteResponse(String id, T data) {
        this.id = id;
        this.rid = 0;
        this.success = true;
        this.message = null;
        this.data = data;
    }

    public RemoteResponse(RemoteRequest<?> request, T data) {
        this.id = request.id;
        this.rid = request.rid;
        this.success = true;
        this.message = null;
        this.data = data;
    }

    public static RemoteResponse<Object> error(String id, int rid, String message2) {
        return new RemoteResponse<Object>(id, rid, false, message2, null);
    }

    public static RemoteResponse<Object> error(RemoteRequest<?> request, String message2) {
        return RemoteResponse.error(request.id, request.rid, message2);
    }

    public static RemoteResponse<Object> ok(String id, int rid, String message2) {
        return new RemoteResponse<Object>(id, rid, true, message2, null);
    }

    public static RemoteResponse<Object> ok(RemoteRequest<?> request, String message2) {
        return RemoteResponse.ok(request.id, request.rid, message2);
    }

    public static RemoteResponse<Object> ok(String id, int rid) {
        return RemoteResponse.ok(id, rid, "ok");
    }

    public static RemoteResponse<Object> ok(RemoteRequest<?> request) {
        return RemoteResponse.ok(request.id, request.rid);
    }

    public static <T> RemoteResponse<T> transform(RemoteResponse<?> response, T newData) {
        return new RemoteResponse<T>(response.id, response.rid, response.success, response.message, newData);
    }

    public static class JsonRemoteResponse
    extends RemoteResponse<JsonElement> {
        public JsonRemoteResponse(String id, int rid, boolean success, String message2, JsonElement data) {
            super(id, rid, success, message2, data);
        }

        public JsonRemoteResponse(String id, JsonElement data) {
            super(id, data);
        }
    }
}

