/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.api.remote;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.remote.RemoteHandler;
import com.forgeessentials.api.remote.RemoteResponse;
import com.forgeessentials.api.remote.RemoteSession;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractRemoteHandler
implements RemoteHandler {
    private final String id;
    private final String permission;
    protected Set<RemoteSession> pushSessions = new HashSet<RemoteSession>();

    public AbstractRemoteHandler(String id, String permission) {
        this.id = id;
        this.permission = permission;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    public void register() {
        APIRegistry.remoteManager.registerHandler(this);
    }

    public static void checkPermission(RemoteSession session, String permission) {
        if (!APIRegistry.perms.checkUserPermission(session.getUserIdent(), permission)) {
            throw new RemoteHandler.PermissionException();
        }
    }

    public static void error(String message2) {
        throw new RemoteHandler.RemoteException(message2);
    }

    protected synchronized void addPushSession(RemoteSession session) {
        this.pushSessions.add(session);
    }

    protected synchronized boolean hasPushSession(RemoteSession session) {
        return this.pushSessions.contains(session);
    }

    protected synchronized void removePushSession(RemoteSession session) {
        this.pushSessions.remove(session);
    }

    protected synchronized void push(RemoteResponse<?> response) {
        Iterator<RemoteSession> it = this.pushSessions.iterator();
        while (it.hasNext()) {
            RemoteSession session = it.next();
            if (session.isClosed()) {
                it.remove();
                continue;
            }
            session.trySendMessage(response);
        }
    }
}

