/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.api.permissions;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.GroupEntry;
import com.forgeessentials.api.permissions.PermissionEvent;
import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.commons.selections.WorldArea;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.StringUtils;

public abstract class Zone {
    public static final String GROUP_DEFAULT = "_ALL_";
    public static final String GROUP_GUESTS = "_GUESTS_";
    public static final String GROUP_OPERATORS = "_OPS_";
    public static final String PERMISSION_ASTERIX = "*";
    public static final String PERMISSION_FALSE = "false";
    public static final String PERMISSION_TRUE = "true";
    public static final String ALL_PERMS = ".*";
    public static final Comparator<Object> permissionComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof String) || !(o2 instanceof String)) {
                return 0;
            }
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (s1.startsWith("fe.internal.player")) {
                if (s2.startsWith("fe.internal.player")) {
                    return s1.compareTo(s2);
                }
                return -1;
            }
            if (s2.startsWith("fe.internal.player")) {
                return 1;
            }
            if (s1.startsWith("fe.internal.group")) {
                if (s2.startsWith("fe.internal.group")) {
                    return s1.compareTo(s2);
                }
                return -1;
            }
            if (s2.startsWith("fe.internal.group")) {
                return 1;
            }
            if (s1.startsWith("fe.internal")) {
                if (s2.startsWith("fe.internal")) {
                    return s1.compareTo(s2);
                }
                return -1;
            }
            if (s2.startsWith("fe.internal")) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    };
    private int id;
    private Map<UserIdent, PermissionList> playerPermissions = new HashMap<UserIdent, PermissionList>();
    private Map<String, PermissionList> groupPermissions = new HashMap<String, PermissionList>();

    public Zone(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isPlayerInZone(EntityPlayer player) {
        return this.isInZone(new WorldPoint((Entity)player));
    }

    public abstract boolean isInZone(WorldPoint var1);

    public abstract boolean isInZone(WorldArea var1);

    public abstract boolean isPartOfZone(WorldArea var1);

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public abstract Zone getParent();

    public abstract ServerZone getServerZone();

    public void setDirty() {
        if (this.getServerZone() != null && this.getServerZone().getRootZone() != null) {
            this.getServerZone().getRootZone().getPermissionHelper().setDirty(false);
        }
    }

    public boolean isHidden() {
        return false;
    }

    public Map<UserIdent, PermissionList> getPlayerPermissions() {
        return this.playerPermissions;
    }

    public PermissionList getPlayerPermissions(UserIdent ident) {
        return this.playerPermissions.get(ident);
    }

    public PermissionList getOrCreatePlayerPermissions(UserIdent ident) {
        PermissionList map = this.playerPermissions.get(ident);
        if (map == null) {
            map = new PermissionList();
            this.playerPermissions.put(ident, map);
        }
        return this.playerPermissions.get(ident);
    }

    public String getPlayerPermission(UserIdent ident, String permissionNode) {
        PermissionList map = this.getPlayerPermissions(ident);
        if (map != null) {
            return (String)map.get(permissionNode);
        }
        return null;
    }

    public String getPlayerPermission(EntityPlayer player, String permissionNode) {
        return this.getPlayerPermission(new UserIdent(player), permissionNode);
    }

    public Boolean checkPlayerPermission(UserIdent ident, String permissionNode) {
        PermissionList map = this.getPlayerPermissions(ident);
        if (map != null) {
            String permValue = (String)map.get(permissionNode);
            return !PERMISSION_FALSE.equalsIgnoreCase(permValue);
        }
        return null;
    }

    public boolean setPlayerPermissionProperty(UserIdent ident, String permissionNode, String value) {
        if (ident != null && !APIRegistry.getFEEventBus().post((Event)new PermissionEvent.User.ModifyPermission(this.getServerZone(), ident, this, permissionNode, value))) {
            this.getServerZone().registerPlayer(ident);
            PermissionList map = this.getOrCreatePlayerPermissions(ident);
            map.put(permissionNode, value);
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean setPlayerPermission(UserIdent ident, String permissionNode, boolean value) {
        return this.setPlayerPermissionProperty(ident, permissionNode, value ? PERMISSION_TRUE : PERMISSION_FALSE);
    }

    public boolean clearPlayerPermission(UserIdent ident, String permissionNode) {
        PermissionList map;
        if (ident != null && (map = this.getPlayerPermissions(ident)) != null && !APIRegistry.getFEEventBus().post((Event)new PermissionEvent.User.ModifyPermission(this.getServerZone(), ident, this, permissionNode, null))) {
            map.remove(permissionNode);
            return true;
        }
        return false;
    }

    public void updatePlayerIdents() {
        Iterator<Map.Entry<UserIdent, PermissionList>> iterator = this.playerPermissions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UserIdent, PermissionList> entry = iterator.next();
            if (!entry.getKey().wasValidUUID()) {
                if (entry.getKey().hasUUID()) {
                    iterator.remove();
                    this.playerPermissions.put(entry.getKey(), entry.getValue());
                }
            } else {
                entry.getKey().updateUsername();
            }
            this.getServerZone().registerPlayer(entry.getKey());
        }
    }

    private Set<String> getPlayerGroups(UserIdent ident) {
        HashSet<String> result = new HashSet<String>();
        String groupsStr = this.getPlayerPermission(ident, "fe.internal.player.groups");
        if (groupsStr != null && !groupsStr.isEmpty()) {
            for (String g : groupsStr.replaceAll(" ", "").split(",")) {
                if (g.isEmpty()) continue;
                result.add(g);
            }
        }
        return result;
    }

    public boolean addPlayerToGroup(UserIdent ident, String group) {
        if (APIRegistry.getFEEventBus().post((Event)new PermissionEvent.User.ModifyGroups(this.getServerZone(), ident, PermissionEvent.User.ModifyGroups.Action.ADD, group))) {
            return false;
        }
        Set<String> groups = this.getPlayerGroups(ident);
        groups.add(group);
        APIRegistry.perms.setPlayerPermissionProperty(ident, "fe.internal.player.groups", StringUtils.join(groups, (String)","));
        return true;
    }

    public boolean removePlayerFromGroup(UserIdent ident, String group) {
        if (APIRegistry.getFEEventBus().post((Event)new PermissionEvent.User.ModifyGroups(this.getServerZone(), ident, PermissionEvent.User.ModifyGroups.Action.REMOVE, group))) {
            return false;
        }
        Set<String> groups = this.getPlayerGroups(ident);
        groups.remove(group);
        APIRegistry.perms.setPlayerPermissionProperty(ident, "fe.internal.player.groups", StringUtils.join(groups, (String)","));
        return true;
    }

    public SortedSet<GroupEntry> getStoredPlayerGroups(UserIdent ident) {
        TreeSet<GroupEntry> result = new TreeSet<GroupEntry>();
        String groupsStr = this.getPlayerPermission(ident, "fe.internal.player.groups");
        if (groupsStr != null && !groupsStr.isEmpty()) {
            for (String group : groupsStr.replace(" ", "").split(",")) {
                result.add(new GroupEntry(this.getServerZone(), group));
            }
        }
        return result;
    }

    public Map<String, PermissionList> getGroupPermissions() {
        return this.groupPermissions;
    }

    public PermissionList getGroupPermissions(String group) {
        return this.groupPermissions.get(group);
    }

    public PermissionList getOrCreateGroupPermissions(String group) {
        PermissionList map = this.groupPermissions.get(group);
        if (map == null) {
            map = new PermissionList();
            this.groupPermissions.put(group, map);
        }
        return this.groupPermissions.get(group);
    }

    public String getGroupPermission(String group, String permissionNode) {
        PermissionList map = this.getGroupPermissions(group);
        if (map != null) {
            return (String)map.get(permissionNode);
        }
        return null;
    }

    public Boolean checkGroupPermission(String group, String permissionNode) {
        PermissionList map = this.getGroupPermissions(group);
        if (map != null) {
            String permValue = (String)map.get(permissionNode);
            return !PERMISSION_FALSE.equalsIgnoreCase(permValue);
        }
        return null;
    }

    public boolean setGroupPermissionProperty(String group, String permissionNode, String value) {
        if (group != null && !APIRegistry.getFEEventBus().post((Event)new PermissionEvent.Group.ModifyPermission(this.getServerZone(), group, this, permissionNode, value))) {
            PermissionList map = this.getOrCreateGroupPermissions(group);
            map.put(permissionNode, value);
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean setGroupPermission(String group, String permissionNode, boolean value) {
        return this.setGroupPermissionProperty(group, permissionNode, value ? PERMISSION_TRUE : PERMISSION_FALSE);
    }

    public boolean clearGroupPermission(String group, String permissionNode) {
        PermissionList map;
        if (group != null && (map = this.getGroupPermissions(group)) != null && !APIRegistry.getFEEventBus().post((Event)new PermissionEvent.Group.ModifyPermission(this.getServerZone(), group, this, permissionNode, null))) {
            map.remove(permissionNode);
            return true;
        }
        return false;
    }

    public void swapPermissions(Zone zone) {
        Map<String, PermissionList> swapGroupPerms = zone.groupPermissions;
        zone.groupPermissions = this.groupPermissions;
        this.groupPermissions = swapGroupPerms;
        Map<UserIdent, PermissionList> swapPlayerPermissions = zone.playerPermissions;
        zone.playerPermissions = this.playerPermissions;
        this.playerPermissions = swapPlayerPermissions;
    }

    public static class PermissionList
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;

        public List<String> toList() {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry perm : this.entrySet()) {
                if (perm.getValue() == null) continue;
                if (((String)perm.getValue()).equals(Zone.PERMISSION_TRUE)) {
                    list.add((String)perm.getKey());
                    continue;
                }
                if (((String)perm.getValue()).equals(Zone.PERMISSION_FALSE)) {
                    list.add("-" + (String)perm.getKey());
                    continue;
                }
                list.add((String)perm.getKey() + "=" + (String)perm.getValue());
            }
            Collections.sort(list);
            return list;
        }

        public static PermissionList fromList(List<String> fromList) {
            PermissionList list = new PermissionList();
            for (String permission : fromList) {
                String[] permParts = permission.split("=");
                if (permParts.length == 2) {
                    list.put(permParts[0], permParts[1]);
                    continue;
                }
                if (permParts.length != 1) continue;
                if (permission.startsWith("-")) {
                    list.put(permission.substring(1, permission.length()), Zone.PERMISSION_FALSE);
                    continue;
                }
                list.put(permission, Zone.PERMISSION_TRUE);
            }
            return list;
        }

        public PermissionList() {
        }

        public PermissionList(Map<? extends String, ? extends String> clone) {
            super(clone);
        }
    }
}

