/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.api.permissions;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.api.permissions.PermissionEvent;
import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.WorldArea;
import com.forgeessentials.commons.selections.WorldPoint;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class WorldZone
extends Zone {
    private ServerZone serverZone;
    private int dimensionID;
    private List<AreaZone> areaZones = new ArrayList<AreaZone>();

    public WorldZone(int id) {
        super(id);
    }

    public WorldZone(ServerZone serverZone, int dimensionID, int id) {
        this(id);
        this.dimensionID = dimensionID;
        this.serverZone = serverZone;
        this.serverZone.addWorldZone(this);
    }

    public WorldZone(ServerZone serverZone, int dimensionID) {
        this(serverZone, dimensionID, serverZone.nextZoneID());
    }

    @Override
    public boolean isPlayerInZone(EntityPlayer player) {
        return player.field_71093_bK == this.dimensionID;
    }

    @Override
    public boolean isInZone(WorldPoint point) {
        return point.getDimension() == this.dimensionID;
    }

    @Override
    public boolean isInZone(WorldArea area) {
        return area.getDimension() == this.dimensionID;
    }

    @Override
    public boolean isPartOfZone(WorldArea area) {
        return area.getDimension() == this.dimensionID;
    }

    @Override
    public String getName() {
        return "WORLD_" + this.dimensionID;
    }

    @Override
    public Zone getParent() {
        return this.serverZone;
    }

    @Override
    public ServerZone getServerZone() {
        return this.serverZone;
    }

    public int getDimensionID() {
        return this.dimensionID;
    }

    public AreaZone getAreaZone(String areaName) {
        for (AreaZone areaZone : this.areaZones) {
            if (!areaZone.getShortName().equals(areaName)) continue;
            return areaZone;
        }
        return null;
    }

    public boolean removeAreaZone(AreaZone zone) {
        if (APIRegistry.getFEEventBus().post((Event)new PermissionEvent.Zone.Delete(this.getServerZone(), zone))) {
            return false;
        }
        return this.serverZone.removeZone(zone) | this.areaZones.remove(zone);
    }

    public Collection<AreaZone> getAreaZones() {
        return this.areaZones;
    }

    public void sortAreaZones() {
        Collections.sort(this.areaZones);
    }

    void addAreaZone(AreaZone areaZone) {
        this.areaZones.add(areaZone);
        this.getServerZone().addZone(areaZone);
        this.sortAreaZones();
        this.setDirty();
    }
}

