/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.api.permissions;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.api.permissions.GroupEntry;
import com.forgeessentials.api.permissions.PermissionEvent;
import com.forgeessentials.api.permissions.RootZone;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.WorldArea;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class ServerZone
extends Zone {
    private RootZone rootZone;
    private Map<Integer, Zone> zones = new HashMap<Integer, Zone>();
    private Map<Integer, WorldZone> worldZones = new HashMap<Integer, WorldZone>();
    private int maxZoneID;
    private Map<UserIdent, Set<String>> playerGroups = new HashMap<UserIdent, Set<String>>();
    private Set<UserIdent> knownPlayers = new HashSet<UserIdent>();

    public ServerZone() {
        super(1);
        APIRegistry.getFEEventBus().post((Event)new PermissionEvent.Initialize(this));
        this.addZone(this);
    }

    public ServerZone(RootZone rootZone) {
        this();
        this.maxZoneID = 1;
        this.rootZone = rootZone;
        this.rootZone.setServerZone(this);
        this.addZone(this.rootZone);
    }

    @Override
    public boolean isInZone(WorldPoint point) {
        return true;
    }

    @Override
    public boolean isInZone(WorldArea point) {
        return true;
    }

    @Override
    public boolean isPartOfZone(WorldArea point) {
        return true;
    }

    @Override
    public String getName() {
        return "_SERVER_";
    }

    @Override
    public Zone getParent() {
        return this.rootZone;
    }

    @Override
    public ServerZone getServerZone() {
        return this;
    }

    void setRootZone(RootZone rootZone) {
        this.rootZone = rootZone;
        this.addZone(this.rootZone);
    }

    public RootZone getRootZone() {
        return this.rootZone;
    }

    public int getMaxZoneID() {
        return this.maxZoneID;
    }

    public int nextZoneID() {
        return ++this.maxZoneID;
    }

    public void setMaxZoneId(int maxId) {
        this.maxZoneID = maxId;
    }

    public Map<Integer, WorldZone> getWorldZones() {
        return this.worldZones;
    }

    public void addWorldZone(WorldZone zone) {
        this.worldZones.put(zone.getDimensionID(), zone);
        this.addZone(zone);
        this.setDirty();
    }

    public WorldZone getWorldZone(int dimensionId) {
        WorldZone zone = this.getWorldZones().get(dimensionId);
        if (zone == null) {
            zone = new WorldZone(this.getServerZone(), dimensionId);
        }
        return zone;
    }

    public WorldZone getWorldZone(World world) {
        return this.getWorldZone(world.field_73011_w.field_76574_g);
    }

    public Set<String> getGroups() {
        return this.getGroupPermissions().keySet();
    }

    public boolean groupExists(String name) {
        return this.getGroupPermissions().containsKey(name);
    }

    public boolean createGroup(String name) {
        if (APIRegistry.getFEEventBus().post((Event)new PermissionEvent.Group.Create(this, name))) {
            return false;
        }
        this.setGroupPermission(name, "fe.internal.group", true);
        this.setGroupPermissionProperty(name, "fe.internal.group.priority", Integer.toString(20));
        this.setDirty();
        return true;
    }

    public Set<String> getIncludedGroups(String group) {
        HashSet<String> result = new HashSet<String>();
        String groupsStr = this.getGroupPermission(group, "fe.internal.group.includes");
        if (groupsStr != null && !groupsStr.isEmpty()) {
            for (String g : groupsStr.replaceAll(" ", "").split(",")) {
                if (g.isEmpty()) continue;
                result.add(g);
            }
        }
        return result;
    }

    public void groupIncludeAdd(String group, String otherGroup) {
        Set<String> groups = this.getIncludedGroups(group);
        groups.add(otherGroup);
        APIRegistry.perms.setGroupPermissionProperty(group, "fe.internal.group.includes", StringUtils.join(groups, (String)","));
    }

    public void groupIncludeRemove(String group, String otherGroup) {
        Set<String> groups = this.getIncludedGroups(group);
        groups.remove(otherGroup);
        APIRegistry.perms.setGroupPermissionProperty(group, "fe.internal.group.includes", StringUtils.join(groups, (String)","));
    }

    public Set<String> getParentedGroups(String group) {
        HashSet<String> result = new HashSet<String>();
        String groupsStr = this.getGroupPermission(group, "fe.internal.group.parents");
        if (groupsStr != null && !groupsStr.isEmpty()) {
            for (String g : groupsStr.replaceAll(" ", "").split(",")) {
                if (g.isEmpty()) continue;
                result.add(g);
            }
        }
        return result;
    }

    public void groupParentAdd(String group, String otherGroup) {
        Set<String> groups = this.getIncludedGroups(group);
        groups.add(otherGroup);
        APIRegistry.perms.setGroupPermissionProperty(group, "fe.internal.group.parents", StringUtils.join(groups, (String)","));
    }

    public void groupParentRemove(String group, String otherGroup) {
        Set<String> groups = this.getIncludedGroups(group);
        groups.remove(otherGroup);
        APIRegistry.perms.setGroupPermissionProperty(group, "fe.internal.group.parents", StringUtils.join(groups, (String)","));
    }

    @Override
    public boolean addPlayerToGroup(UserIdent ident, String group) {
        this.registerPlayer(ident);
        if (APIRegistry.getFEEventBus().post((Event)new PermissionEvent.User.ModifyGroups(this, ident, PermissionEvent.User.ModifyGroups.Action.ADD, group))) {
            return false;
        }
        Set<String> groupSet = this.playerGroups.get(ident);
        if (groupSet == null) {
            groupSet = new TreeSet<String>();
            this.playerGroups.put(ident, groupSet);
        }
        groupSet.add(group);
        this.setDirty();
        return true;
    }

    @Override
    public boolean removePlayerFromGroup(UserIdent ident, String group) {
        this.registerPlayer(ident);
        if (APIRegistry.getFEEventBus().post((Event)new PermissionEvent.User.ModifyGroups(this, ident, PermissionEvent.User.ModifyGroups.Action.REMOVE, group))) {
            return false;
        }
        Set<String> groupSet = this.playerGroups.get(ident);
        if (groupSet != null) {
            groupSet.remove(group);
        }
        this.setDirty();
        return true;
    }

    public Map<UserIdent, Set<String>> getPlayerGroups() {
        return this.playerGroups;
    }

    @Override
    public SortedSet<GroupEntry> getStoredPlayerGroups(UserIdent ident) {
        this.registerPlayer(ident);
        Set<String> pgs = this.playerGroups.get(ident);
        TreeSet<GroupEntry> result = new TreeSet<GroupEntry>();
        if (pgs != null) {
            for (String group : pgs) {
                result.add(new GroupEntry(this, group));
            }
        }
        return result;
    }

    public SortedSet<GroupEntry> getAdditionalPlayerGroups(UserIdent ident) {
        SortedSet<GroupEntry> result = this.getStoredPlayerGroups(ident);
        if (ident != null) {
            if (ident.hasGameProfile() && !ident.isFakePlayer() && MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(ident.getGameProfile())) {
                result.add(new GroupEntry(this, "_OPS_"));
            }
            if (result.isEmpty()) {
                result.add(new GroupEntry(this, "_GUESTS_"));
            }
        }
        result.add(new GroupEntry("_ALL_", 0, 0));
        return result;
    }

    public SortedSet<GroupEntry> includeGroups(SortedSet<GroupEntry> groups) {
        boolean addedGroup;
        HashSet<String> checkedGroups = new HashSet<String>();
        do {
            addedGroup = false;
            for (GroupEntry existingGroup : new ArrayList<GroupEntry>(groups)) {
                if (!checkedGroups.add(existingGroup.getGroup())) continue;
                String p = this.getGroupPermission(existingGroup.getGroup(), "fe.internal.group.includes");
                if (p != null) {
                    for (String group : p.replaceAll(" ", "").split(",")) {
                        if (group.isEmpty()) continue;
                        addedGroup |= groups.add(new GroupEntry(this, group));
                    }
                }
                if ((p = this.getGroupPermission(existingGroup.getGroup(), "fe.internal.group.parents")) == null) continue;
                for (String group : p.replaceAll(" ", "").split(",")) {
                    if (group.isEmpty()) continue;
                    addedGroup |= groups.add(new GroupEntry(this, group, existingGroup.getPriority()));
                }
            }
        } while (addedGroup);
        return groups;
    }

    public SortedSet<GroupEntry> getPlayerGroups(UserIdent ident) {
        SortedSet<GroupEntry> result = this.getAdditionalPlayerGroups(ident);
        if (ident != null) {
            for (Zone z : this.getZonesAt(ident)) {
                if (z instanceof ServerZone) continue;
                result.addAll(z.getStoredPlayerGroups(ident));
            }
        }
        return this.includeGroups(result);
    }

    public String getPrimaryPlayerGroup(UserIdent ident) {
        Iterator it = this.getPlayerGroups(ident).iterator();
        if (it.hasNext()) {
            return ((GroupEntry)it.next()).getGroup();
        }
        return null;
    }

    public void addZone(Zone zone) {
        this.zones.put(zone.getId(), zone);
    }

    public boolean removeZone(Zone zone) {
        return this.zones.remove(zone.getId()) != null;
    }

    public void rebuildZonesMap() {
        this.zones.clear();
        this.addZone(this.getRootZone());
        this.addZone(this);
        for (WorldZone worldZone : this.worldZones.values()) {
            this.addZone(worldZone);
            for (AreaZone areaZone : worldZone.getAreaZones()) {
                this.addZone(areaZone);
            }
        }
    }

    public Map<Integer, Zone> getZoneMap() {
        return this.zones;
    }

    public Collection<Zone> getZones() {
        return this.zones.values();
    }

    public List<Zone> getZonesAt(WorldPoint worldPoint) {
        WorldZone w = this.getWorldZone(worldPoint.getDimension());
        ArrayList<Zone> result = new ArrayList<Zone>();
        for (AreaZone zone : w.getAreaZones()) {
            if (!zone.isInZone(worldPoint)) continue;
            result.add(zone);
        }
        result.add(w);
        result.add(this);
        return result;
    }

    public List<Zone> getZonesAt(UserIdent ident) {
        if (ident == null) {
            return new ArrayList<Zone>();
        }
        if (ident.hasPlayer()) {
            return this.getZonesAt(new WorldPoint((Entity)ident.getPlayer()));
        }
        ArrayList<Zone> result = new ArrayList<Zone>();
        result.add(this);
        return result;
    }

    public Zone getZoneAt(WorldPoint worldPoint) {
        List<Zone> zones = this.getZonesAt(worldPoint);
        return zones.isEmpty() ? null : zones.get(0);
    }

    public List<AreaZone> getAreaZonesAt(WorldPoint worldPoint) {
        WorldZone w = this.getWorldZone(worldPoint.getDimension());
        ArrayList<AreaZone> result = new ArrayList<AreaZone>();
        for (AreaZone zone : w.getAreaZones()) {
            if (!zone.isInZone(worldPoint)) continue;
            result.add(zone);
        }
        return result;
    }

    public AreaZone getAreaZoneAt(WorldPoint worldPoint) {
        List<AreaZone> zones = this.getAreaZonesAt(worldPoint);
        return zones.isEmpty() ? null : zones.get(0);
    }

    public void registerPlayer(UserIdent ident) {
        if (ident != null) {
            this.knownPlayers.add(ident);
        }
    }

    public Set<UserIdent> getKnownPlayers() {
        return this.knownPlayers;
    }

    public String getPermission(Collection<Zone> zones, UserIdent ident, Collection<String> groups, String permissionNode, boolean isProperty) {
        String result;
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add(permissionNode);
        if (!isProperty) {
            String[] nodeParts = permissionNode.split("\\.");
            for (int i = nodeParts.length; i > 0; --i) {
                String node = "";
                for (int j = 0; j < i; ++j) {
                    node = node + nodeParts[j] + ".";
                }
                nodes.add(node + "*");
            }
            nodes.add("*");
        }
        if (ident != null) {
            for (Zone zone : zones) {
                for (String node : nodes) {
                    result = zone.getPlayerPermission(ident, node);
                    if (result == null) continue;
                    if (this.rootZone.permissionDebugger != null) {
                        this.rootZone.permissionDebugger.debugPermission(zone, ident, null, permissionNode, node, result);
                    }
                    return result;
                }
            }
        }
        if (groups != null) {
            for (String group : groups) {
                for (Zone zone : zones) {
                    for (String node : nodes) {
                        String result2 = zone.getGroupPermission(group, node);
                        if (result2 == null) continue;
                        if (this.rootZone.permissionDebugger != null) {
                            this.rootZone.permissionDebugger.debugPermission(zone, null, group, permissionNode, node, result2);
                        }
                        return result2;
                    }
                }
            }
        }
        for (String node : nodes) {
            for (Zone zone : zones) {
                result = zone.getGroupPermission("_ALL_", node);
                if (result == null) continue;
                if (this.rootZone.permissionDebugger != null) {
                    this.rootZone.permissionDebugger.debugPermission(zone, null, "_ALL_", permissionNode, node, result);
                }
                return result;
            }
        }
        if (this.rootZone.permissionDebugger != null) {
            this.rootZone.permissionDebugger.debugPermission(null, null, "_ALL_", permissionNode, permissionNode, "true");
        }
        return null;
    }

    public static interface PermissionDebugger {
        public void debugPermission(Zone var1, UserIdent var2, String var3, String var4, String var5, String var6);
    }
}

