/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.api.permissions;

import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.util.FunctionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupEntry
implements Comparable<GroupEntry> {
    private final String group;
    private final int priority;
    private final int originalPriority;

    public GroupEntry(String group, int priority, int originalPriority) {
        this.group = group;
        this.priority = priority;
        this.originalPriority = originalPriority;
    }

    public GroupEntry(String group, int priority) {
        this(group, priority, priority);
    }

    public GroupEntry(ServerZone zone, String group) {
        this(group, FunctionHelper.parseIntDefault(zone.getGroupPermission(group, "fe.internal.group.priority"), 20));
    }

    public GroupEntry(ServerZone zone, String group, int priority) {
        this(group, priority, FunctionHelper.parseIntDefault(zone.getGroupPermission(group, "fe.internal.group.priority"), 20));
    }

    public String getGroup() {
        return this.group;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        return this.group;
    }

    @Override
    public int compareTo(GroupEntry o) {
        int c = -Integer.compare(this.priority, o.priority);
        if (c != 0) {
            return c;
        }
        c = -Integer.compare(this.originalPriority, o.originalPriority);
        if (c != 0) {
            return c;
        }
        return this.group.compareTo(o.group);
    }

    public static List<String> toList(Collection<GroupEntry> entries) {
        ArrayList<String> result = new ArrayList<String>(entries.size());
        for (GroupEntry entry : entries) {
            result.add(entry.group);
        }
        return result;
    }
}

