/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.api.permissions;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.PermissionEvent;
import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.AreaBase;
import com.forgeessentials.commons.selections.AreaShape;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WorldArea;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.util.events.EventCancelledException;

public class AreaZone
extends Zone
implements Comparable<AreaZone> {
    private WorldZone worldZone;
    private String name;
    private AreaBase area;
    private AreaShape shape = AreaShape.BOX;
    private int priority;

    private AreaZone(int id) {
        super(id);
    }

    public AreaZone(WorldZone worldZone, String name, AreaBase area, int id) {
        this(id);
        this.worldZone = worldZone;
        this.name = name;
        this.area = area;
        this.worldZone.addAreaZone(this);
    }

    public AreaZone(WorldZone worldZone, String name, AreaBase area) throws EventCancelledException {
        this(worldZone.getServerZone().getMaxZoneID() + 1);
        this.worldZone = worldZone;
        this.name = name;
        this.area = area;
        EventCancelledException.checkedPost(new PermissionEvent.Zone.Create(worldZone.getServerZone(), this), APIRegistry.getFEEventBus());
        worldZone.getServerZone().nextZoneID();
        this.worldZone.addAreaZone(this);
    }

    @Override
    public boolean isInZone(WorldPoint point) {
        if (!this.worldZone.isInZone(point)) {
            return false;
        }
        return this.shape.contains(this.area, point);
    }

    @Override
    public boolean isInZone(WorldArea otherArea) {
        if (!this.worldZone.isInZone(otherArea)) {
            return false;
        }
        return this.shape.contains(this.area, otherArea);
    }

    @Override
    public boolean isPartOfZone(WorldArea otherArea) {
        if (!this.worldZone.isPartOfZone(otherArea)) {
            return false;
        }
        return this.area.intersectsWith(otherArea);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.worldZone.getName() + "_" + this.name;
    }

    @Override
    public Zone getParent() {
        return this.worldZone;
    }

    @Override
    public ServerZone getServerZone() {
        return this.worldZone.getServerZone();
    }

    public String getShortName() {
        return this.name;
    }

    public WorldZone getWorldZone() {
        return this.worldZone;
    }

    public AreaBase getArea() {
        return this.area;
    }

    public void setArea(AreaBase area) {
        this.area = area;
        this.setDirty();
        this.getWorldZone().sortAreaZones();
    }

    public AreaShape getShape() {
        return this.shape;
    }

    public void setShape(AreaShape shape) {
        this.shape = shape == null ? AreaShape.BOX : shape;
        this.setDirty();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.setDirty();
    }

    @Override
    public int compareTo(AreaZone otherArea) {
        int cmp = otherArea.priority - this.priority;
        if (cmp != 0) {
            return cmp;
        }
        Point areaSize = otherArea.getArea().getSize();
        Point thisSize = this.getArea().getSize();
        cmp = thisSize.getX() * thisSize.getY() - areaSize.getX() * areaSize.getY();
        if (cmp != 0) {
            return cmp;
        }
        return cmp;
    }

    @Override
    public boolean isHidden() {
        String hiddenValue = this.getGroupPermission("_ALL_", "fe.internal.zone.hidden");
        return hiddenValue != null && !"false".equals(hiddenValue);
    }

    public void setHidden(boolean hidden) {
        if (hidden) {
            this.setGroupPermission("_ALL_", "fe.internal.zone.hidden", hidden);
        } else {
            this.clearGroupPermission("_ALL_", "fe.internal.zone.hidden");
        }
    }
}

