/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.api;

import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public interface NamedWorldHandler {
    public static final String WORLD_NAME_END = "end";
    public static final String WORLD_NAME_NETHER = "nether";
    public static final String WORLD_NAME_SURFACE = "surface";

    public WorldServer getWorld(String var1);

    public String getWorldName(int var1);

    public static class DefaultNamedWorldHandler
    implements NamedWorldHandler {
        @Override
        public WorldServer getWorld(String name) {
            switch (name) {
                case "surface": {
                    return DimensionManager.getWorld((int)0);
                }
                case "nether": {
                    return DimensionManager.getWorld((int)-1);
                }
                case "end": {
                    return DimensionManager.getWorld((int)1);
                }
            }
            try {
                return DimensionManager.getWorld((int)Integer.parseInt(name));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public String getWorldName(int dimId) {
            switch (dimId) {
                case 0: {
                    return NamedWorldHandler.WORLD_NAME_SURFACE;
                }
                case -1: {
                    return NamedWorldHandler.WORLD_NAME_NETHER;
                }
                case 1: {
                    return NamedWorldHandler.WORLD_NAME_END;
                }
            }
            return Integer.toString(dimId);
        }
    }
}

