/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.afterlife;

import com.forgeessentials.afterlife.Deathchest;
import com.forgeessentials.afterlife.RespawnDebuffHandler;
import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.permissions.PermissionsManager;

@FEModule(name="Afterlife", parentMod=ForgeEssentials.class)
public class ModuleAfterlife
extends IConfigLoader.ConfigLoaderBase {
    @FEModule.Instance
    public static ModuleAfterlife instance;
    public static final String BASEPERM = "fe.afterlife";
    public Deathchest deathchest;
    public RespawnDebuffHandler respawnDebuff;

    @SubscribeEvent
    public void load(FEModuleEvent.FEModuleInitEvent e) {
        this.deathchest = new Deathchest();
        this.respawnDebuff = new RespawnDebuffHandler();
    }

    @SubscribeEvent
    public void serverStarting(FEModuleEvent.FEModuleServerInitEvent e) {
        this.deathchest.load();
        APIRegistry.perms.registerPermission(BASEPERM, PermissionsManager.RegisteredPermValue.OP);
        APIRegistry.perms.registerPermission("fe.afterlife.bypassPotions", PermissionsManager.RegisteredPermValue.OP);
        APIRegistry.perms.registerPermission("fe.afterlife.bypassStats", PermissionsManager.RegisteredPermValue.OP);
        APIRegistry.perms.registerPermission("fe.afterlife.deathchest.protectionBypass", null);
        APIRegistry.perms.registerPermission("fe.afterlife.deathchest.make", PermissionsManager.RegisteredPermValue.TRUE, "Allows graves to spawn, if a player dies");
        APIRegistry.perms.registerPermissionProperty("fe.afterlife.deathchest.xpmultiplier", "0.25", "Ratio of XP that you want to allow someone to keep in a grave. 1 keeps all XP.");
    }

    @SubscribeEvent
    public void serverStopping(FEModuleEvent.FEModuleServerStopEvent e) {
        this.deathchest.save();
    }

    @Override
    public void load(Configuration config, boolean isReload) {
        String[] array;
        OutputHandler.felog.finer("Loading Afterlife-module configuration");
        String category = "Afterlife.DeathChest";
        config.addCustomCategoryComment(category, "Permission needed:\nfe.afterlife.deathchest.make");
        Deathchest.enable = config.get(category, "Enable", true, "Enable the deathchest.").getBoolean(true);
        Deathchest.enableXP = config.get(category, "EnableXP", true, "Gives xp when the skull is destoyed or emplyed").getBoolean(true);
        Deathchest.enableFencePost = config.get(category, "enableFencePost", true, "Put the skull on a spike.").getBoolean(true);
        Deathchest.protectionTime = config.get(category, "protectionTime", 300, "Time in seconds a grave is protected. After this time anyone can take all stuff.").getInt();
        category = "Afterlife.respawnStats";
        config.addCustomCategoryComment(category, "Bypass permissions:\nfe.afterlife.bypassStats");
        RespawnDebuffHandler.hp = config.get(category, "hp", 20, "On respawn, respawn with X half hearts.").getInt();
        RespawnDebuffHandler.food = config.get(category, "foodlvl", 20, "On respawn, respawn with X half whatevertheyare.").getInt();
        category = "Afterlife.RespawnDebuffHandler";
        config.addCustomCategoryComment(category, "Bypass permissions:\nfe.afterlife.bypassPotions\nFor more info on potions effects:\nhttp://www.minecraftwiki.net/wiki/Potion_effects");
        RespawnDebuffHandler.potionEffects = new ArrayList();
        for (String string : array = config.get(category, "potionEffects", new String[]{"4:150:1"}, "Format like this: 'ID:duration:amplifier'").getStringList()) {
            String[] split = string.split(":");
            RespawnDebuffHandler.potionEffects.add(new PotionEffect(Integer.parseInt(split[0]), Integer.parseInt(split[1]) * 20, Integer.parseInt(split[2])));
        }
    }
}

