/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.afterlife;

import com.forgeessentials.afterlife.Deathchest;
import com.forgeessentials.afterlife.ModuleAfterlife;
import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.commons.selections.WorldPoint;
import java.util.ArrayList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.permissions.PermissionsManager;

@SaveableObject
public class Grave {
    @SaveableObject.UniqueLoadingKey
    @SaveableObject.SaveableField
    public String key;
    @SaveableObject.SaveableField
    public WorldPoint point;
    @SaveableObject.SaveableField
    public String owner;
    @SaveableObject.SaveableField
    public ItemStack[] inv;
    @SaveableObject.SaveableField
    public int xp;
    @SaveableObject.SaveableField
    public int protTime;
    @SaveableObject.SaveableField
    public boolean protEnable = true;
    private boolean opened;
    private long startTime;

    public Grave(WorldPoint point, EntityPlayer player, ArrayList<EntityItem> drops, Deathchest deathchest) {
        this.key = point.toString();
        this.point = point;
        this.owner = player.getPersistentID().toString();
        if (Deathchest.enableXP) {
            this.xp = player.field_71068_ca;
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
        }
        this.inv = new ItemStack[drops.size()];
        for (int i = 0; i < drops.size(); ++i) {
            this.inv[i] = drops.get(i).func_92059_d().func_77946_l();
        }
        this.protTime = Deathchest.protectionTime;
        deathchest.gravemap.put(point.toString(), this);
        this.startTime = System.currentTimeMillis();
    }

    private Grave(String key, Object point, Object owner, Object inv, Object xp, Object protTime, Object protEnable) {
        this.key = key;
        this.point = (WorldPoint)point;
        this.owner = (String)owner;
        this.inv = inv != null ? (ItemStack[])inv : new ItemStack[]{};
        this.xp = (Integer)xp;
        this.protTime = (Integer)protTime;
        this.protEnable = (Boolean)protEnable;
        this.startTime = System.currentTimeMillis();
    }

    @SaveableObject.Reconstructor
    private static Grave reconstruct(IReconstructData tag) {
        return new Grave(tag.getUniqueKey(), tag.getFieldValue("point"), tag.getFieldValue("owner"), tag.getFieldValue("inv"), tag.getFieldValue("xp"), tag.getFieldValue("protTime"), tag.getFieldValue("protEnable"));
    }

    public void checkGrave() {
        if (this.inv.length == 0) {
            ModuleAfterlife.instance.deathchest.removeGrave(this, true);
        }
    }

    public int getSize() {
        if (this.inv == null) {
            return 0;
        }
        return this.inv.length % 9 == 0 ? this.inv.length : (this.inv.length / 9 + 1) * 9;
    }

    public void tick() {
        if ((System.currentTimeMillis() - this.startTime) / 1000L > (long)this.protTime) {
            this.protEnable = false;
        }
    }

    public boolean canOpen(EntityPlayer player) {
        if (!this.protEnable) {
            return true;
        }
        if (player.func_110124_au().toString().equals(this.owner)) {
            return true;
        }
        if (PermissionsManager.checkPermission(player, "fe.afterlife.deathchest.protectionBypass")) {
            return true;
        }
        return !this.opened;
    }

    public void setOpen(boolean open) {
        this.opened = open;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public void setSaveProtTime() {
        this.protTime = (int)((long)this.protTime - (System.currentTimeMillis() - this.startTime) / 1000L);
    }
}

