/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.afterlife;

import com.forgeessentials.afterlife.FEskullTe;
import com.forgeessentials.afterlife.Grave;
import com.forgeessentials.afterlife.InventoryGrave;
import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.ServerEventHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2DPacketOpenWindow;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.permissions.PermissionsManager;

public class Deathchest
extends ServerEventHandler {
    public static final String PERMISSION_MAKE = "fe.afterlife.deathchest.make";
    public static final String PERMISSION_BYPASS = "fe.afterlife.deathchest.protectionBypass";
    public static final String PERMPROP_XP_MODIFIER = "fe.afterlife.deathchest.xpmultiplier";
    public static boolean enable;
    public static boolean enableXP;
    public static boolean enableFencePost;
    public static int protectionTime;
    public Map<String, Grave> gravemap = new HashMap<String, Grave>();

    public Deathchest() {
        TileEntity.func_145826_a(FEskullTe.class, (String)"FESkull");
    }

    public void load() {
        this.gravemap = DataManager.getInstance().loadAll(Grave.class);
    }

    public void save() {
        for (Grave grave : this.gravemap.values()) {
            grave.setSaveProtTime();
            DataManager.getInstance().save(grave, grave.key);
        }
    }

    @SubscribeEvent
    public void handleDeath(PlayerDropsEvent e) {
        if (!enable) {
            return;
        }
        if (!PermissionsManager.checkPermission(e.entityPlayer, PERMISSION_MAKE)) {
            return;
        }
        WorldPoint point = new WorldPoint((Entity)e.entityPlayer);
        if (point.getY() < 0) {
            OutputHandler.chatWarning((ICommandSender)e.entityPlayer, "No deathchest for you as you fell out of the world!");
            return;
        }
        World world = e.entityPlayer.field_70170_p;
        point.setY(FunctionHelper.placeInWorld(world, point.getX(), point.getY(), point.getZ(), enableFencePost ? 2 : 1));
        e.setCanceled(true);
        if (enableFencePost) {
            world.func_147449_b(point.getX(), point.getY(), point.getZ(), Blocks.field_150422_aJ);
            point.setY(point.getY() + 1);
        }
        this.gravemap.put(point.toString(), new Grave(point, e.entityPlayer, e.drops, this));
        FEskullTe.createPlayerSkull(e.entityPlayer, world, point.getX(), point.getY(), point.getZ());
    }

    @SubscribeEvent
    public void handleClick(PlayerInteractEvent e) {
        WorldPoint point;
        if (e.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (e.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR && this.gravemap.containsKey((point = new WorldPoint(e.entity.field_70170_p, e.x, e.y, e.z)).toString())) {
            Grave grave = this.gravemap.get(point.toString());
            Block block = e.entity.field_70170_p.func_147439_a(e.x, e.y, e.z);
            if (block == Blocks.field_150465_bP || block == Blocks.field_150486_ae || block == Blocks.field_150422_aJ) {
                if (!grave.canOpen(e.entityPlayer)) {
                    OutputHandler.chatWarning((ICommandSender)e.entityPlayer, "This grave is still under divine protection.");
                    e.setCanceled(true);
                } else {
                    EntityPlayerMP player = (EntityPlayerMP)e.entityPlayer;
                    if (grave.xp > 0) {
                        String modifier = APIRegistry.perms.getPermissionProperty((EntityPlayer)player, PERMPROP_XP_MODIFIER);
                        double intmod = Double.parseDouble(modifier);
                        int toAdd = (int)((double)grave.xp * intmod);
                        player.func_82242_a(toAdd);
                        grave.xp = 0;
                    }
                    if (player.field_71070_bA != player.field_71069_bz) {
                        player.func_71053_j();
                    }
                    player.func_71117_bO();
                    grave.setOpen(true);
                    InventoryGrave invGrave = new InventoryGrave(grave);
                    player.field_71135_a.func_147359_a((Packet)new S2DPacketOpenWindow(player.field_71139_cq, 0, invGrave.func_145825_b(), invGrave.func_70302_i_(), true));
                    player.field_71070_bA = new ContainerChest((IInventory)player.field_71071_by, (IInventory)invGrave);
                    player.field_71070_bA.field_75152_c = player.field_71139_cq;
                    player.field_71070_bA.func_75132_a((ICrafting)player);
                    e.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void mineGrave(BlockEvent.BreakEvent e) {
        WorldPoint point = new WorldPoint(e.world, e.x, e.y, e.z);
        WorldPoint point2 = new WorldPoint(e.world, e.x, e.y + 1, e.z);
        if (e.world.field_72995_K) {
            return;
        }
        if (enableFencePost) {
            if (this.gravemap.containsKey(point2.toString())) {
                e.setCanceled(true);
                if (e.world.func_147439_a(e.x, e.y, e.z) == Blocks.field_150422_aJ) {
                    OutputHandler.chatError((ICommandSender)e.getPlayer(), "You may not defile the grave of a player.");
                } else {
                    Grave grave = this.gravemap.get(point2.toString());
                    this.removeGrave(grave, true);
                }
            } else if (this.gravemap.containsKey(point.toString())) {
                e.setCanceled(true);
                Grave grave = this.gravemap.get(point.toString());
                this.removeGrave(grave, true);
            }
        } else if (this.gravemap.containsKey(point.toString())) {
            e.setCanceled(true);
            Grave grave = this.gravemap.get(point.toString());
            this.removeGrave(grave, true);
        }
    }

    public void removeGrave(Grave grave, boolean mined) {
        if (grave == null) {
            return;
        }
        DataManager.getInstance().delete(Grave.class, grave.point.toString());
        this.gravemap.remove(grave.point.toString());
        if (mined) {
            for (ItemStack is : grave.inv) {
                try {
                    EntityItem entity = new EntityItem((World)DimensionManager.getWorld((int)grave.point.getDimension()), (double)grave.point.getX(), (double)grave.point.getY(), (double)grave.point.getZ(), is);
                    DimensionManager.getWorld((int)grave.point.getDimension()).func_72838_d((Entity)entity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        WorldServer world = DimensionManager.getWorld((int)grave.point.getDimension());
        world.func_147449_b(grave.point.getX(), grave.point.getY(), grave.point.getZ(), Blocks.field_150350_a);
        if (enableFencePost && world.func_147439_a(grave.point.getX(), grave.point.getY() - 1, grave.point.getZ()) == Blocks.field_150422_aJ) {
            world.func_147449_b(grave.point.getX(), grave.point.getY() - 1, grave.point.getZ(), Blocks.field_150350_a);
        }
    }

    @SubscribeEvent
    public void tickGraves(TickEvent.ServerTickEvent e) {
        for (Grave grave : this.gravemap.values()) {
            grave.tick();
        }
    }
}

