/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.RitualShapeHelper;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellUtils;
import am2.utility.InventoryUtilities;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class PlaceBlock
implements ISpellComponent {
    private static final String KEY_BLOCKID = "PlaceBlockID";
    private static final String KEY_META = "PlaceMeta";

    @Override
    public Object[] getRecipeItems() {
        return new Object[]{Items.field_151049_t, Items.field_151050_s, Items.field_151051_r, Blocks.field_150486_ae};
    }

    @Override
    public int getID() {
        return 75;
    }

    private MultiblockStructureDefinition.BlockDec getPlaceBlock(ItemStack stack) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b(KEY_BLOCKID)) {
            MultiblockStructureDefinition multiblockStructureDefinition = RitualShapeHelper.instance.hourglass;
            multiblockStructureDefinition.getClass();
            return multiblockStructureDefinition.new MultiblockStructureDefinition.BlockDec(Block.func_149729_e((int)stack.field_77990_d.func_74762_e(KEY_BLOCKID)), stack.field_77990_d.func_74762_e(KEY_META));
        }
        return null;
    }

    private void setPlaceBlock(ItemStack stack, Block block, int meta) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a(KEY_BLOCKID, Block.func_149682_b((Block)block));
        stack.field_77990_d.func_74768_a(KEY_META, meta);
        if (!stack.field_77990_d.func_74764_b("Lore")) {
            stack.field_77990_d.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        ItemStack blockStack = new ItemStack(block, 1, meta);
        NBTTagList tagList = stack.field_77990_d.func_150295_c("Lore", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            String str = tagList.func_150307_f(i);
            if (!str.startsWith(String.format(StatCollector.func_74838_a((String)"am2.tooltip.placeBlockSpell"), ""))) continue;
            tagList.func_74744_a(i);
        }
        tagList.func_74742_a((NBTBase)new NBTTagString(String.format(StatCollector.func_74838_a((String)"am2.tooltip.placeBlockSpell"), blockStack.func_82833_r())));
        stack.field_77990_d.func_74782_a("Lore", (NBTBase)tagList);
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)caster;
        ItemStack spellStack = player.func_71045_bC();
        if (spellStack == null || spellStack.func_77973_b() != ItemsCommonProxy.spell || !SpellUtils.instance.componentIsPresent(spellStack, PlaceBlock.class, SpellUtils.instance.numStages(spellStack) - 1)) {
            return false;
        }
        MultiblockStructureDefinition.BlockDec bd = this.getPlaceBlock(spellStack);
        if (bd != null && !caster.func_70093_af()) {
            if (world.func_147437_c(blockx, blocky, blockz) || !world.func_147439_a(blockx, blocky, blockz).func_149688_o().func_76220_a()) {
                blockFace = -1;
            }
            if (blockFace != -1) {
                switch (blockFace) {
                    case 0: {
                        --blocky;
                        break;
                    }
                    case 1: {
                        ++blocky;
                        break;
                    }
                    case 2: {
                        --blockz;
                        break;
                    }
                    case 3: {
                        ++blockz;
                        break;
                    }
                    case 4: {
                        --blockx;
                        break;
                    }
                    case 5: {
                        ++blockx;
                    }
                }
            }
            if (world.func_147437_c(blockx, blocky, blockz) || !world.func_147439_a(blockx, blocky, blockz).func_149688_o().func_76220_a()) {
                ItemStack searchStack = new ItemStack(bd.getBlock(), 1, bd.getMeta());
                if (!world.field_72995_K && (player.field_71075_bZ.field_75098_d || InventoryUtilities.inventoryHasItem((IInventory)player.field_71071_by, searchStack, 1))) {
                    world.func_147465_d(blockx, blocky, blockz, bd.getBlock(), bd.getMeta(), 3);
                    if (!player.field_71075_bZ.field_75098_d) {
                        InventoryUtilities.deductFromInventory((IInventory)player.field_71071_by, searchStack, 1);
                    }
                }
                return true;
            }
        } else if (caster.func_70093_af()) {
            if (!world.field_72995_K && !world.func_147437_c(blockx, blocky, blockz)) {
                this.setPlaceBlock(spellStack, world.func_147439_a(blockx, blocky, blockz), world.func_72805_g(blockx, blocky, blockz));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 5.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 1.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.EARTH, Affinity.ENDER);
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }
}

