/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.api.math.AMVector3;
import am2.particles.AMParticle;
import am2.particles.ParticleController;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;

public class ParticleFleePoint
extends ParticleController {
    private AMVector3 target;
    private double fleeSpeed;
    private double targetDistance;

    public ParticleFleePoint(AMParticle particleEffect, AMVector3 fleePoint, double fleeSpeed, double targetDistance, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.target = fleePoint;
        this.fleeSpeed = fleeSpeed;
        this.targetDistance = targetDistance;
    }

    @Override
    public void doUpdate() {
        double angle;
        double posY = this.particle.field_70163_u;
        double distanceToTarget = new AMVector3((Entity)this.particle).distanceTo(this.target);
        double deltaZ = this.particle.field_70161_v - (double)this.target.z;
        double deltaX = this.particle.field_70165_t - (double)this.target.x;
        double radians = angle = Math.atan2(deltaZ, deltaX);
        double posX = this.particle.field_70165_t + this.fleeSpeed * Math.cos(radians);
        double posZ = this.particle.field_70161_v + this.fleeSpeed * Math.sin(radians);
        double deltaY = (double)this.target.y - posY;
        double horizontalDistance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
        double pitchRadians = pitchRotation;
        posY = this.particle.field_70163_u + this.fleeSpeed * Math.sin(pitchRadians);
        if (distanceToTarget > this.targetDistance) {
            this.finish();
        } else {
            this.particle.func_70107_b(posX, posY, posZ);
        }
    }

    @Override
    public ParticleController clone() {
        return new ParticleFleePoint(this.particle, this.target, this.fleeSpeed, this.targetDistance, this.priority, this.exclusive);
    }
}

