/*
 * Decompiled with CFR 0.152.
 */
package am2.lore;

import am2.AMCore;
import am2.utility.InventoryUtilities;
import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class Story {
    private final String resourceName;
    private short parts;
    private String title;
    private String author;
    private int[] colors;
    private final ArrayList<ArrayList<NBTTagString>> partPages;

    public int getStoryPassColor(int pass) {
        if (this.colors.length <= pass) {
            return this.colors[this.colors.length - 1];
        }
        return this.colors[pass];
    }

    public short getNumParts() {
        return this.parts;
    }

    public ArrayList<NBTTagString> getStoryPart(int index) {
        if (index < 0 || index >= this.parts) {
            return new ArrayList<NBTTagString>();
        }
        return this.partPages.get(index);
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public Story(String resourceName) throws IOException {
        this.resourceName = resourceName;
        this.partPages = new ArrayList();
        this.parseFile();
        if (this.title == null || this.author == null) {
            throw new IOException("Invalid file - needs #TITLE and #AUTHOR directives at the beginning!");
        }
    }

    private void parseFile() {
        String fileText = this.readResource();
        String[] split = fileText.split("<<__>>");
        this.parts = (short)split.length;
        for (String s : split) {
            if (s.equals("") || s.equals("\n")) continue;
            if (s.startsWith("\n")) {
                s = s.replaceFirst("\n", "");
            }
            s = s.replace("\r\n", "\n");
            this.partPages.add(Story.splitStoryPartIntoPages(s));
        }
    }

    private InputStream getResourceAsStream(String resourceName) {
        return AMCore.class.getResourceAsStream(resourceName);
    }

    private String readResource() {
        InputStream stream = this.getResourceAsStream(this.resourceName);
        if (stream == null) {
            FMLLog.info((String)("Ars Magica >> Missing Resource '" + this.resourceName + "'"), (Object[])new Object[0]);
            return "";
        }
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#TITLE")) {
                    this.title = line.replace("#TITLE", "").trim();
                    continue;
                }
                if (line.startsWith("#AUTHOR")) {
                    this.author = line.replace("#AUTHOR", "").trim();
                    continue;
                }
                if (line.startsWith("#COLORS")) {
                    String colorString = line.replace("#COLORS", "").trim();
                    String[] colorStrings = colorString.split(" ");
                    this.colors = new int[4];
                    for (int i = 0; i < 4; ++i) {
                        if (i < colorStrings.length) {
                            try {
                                this.colors[i] = Integer.parseInt(colorStrings[i], 16);
                            }
                            catch (Throwable t) {
                                this.colors[i] = 0xFFFFFF;
                            }
                            continue;
                        }
                        this.colors[i] = 0xFFFFFF;
                    }
                    continue;
                }
                sb.append(line + "\n");
            }
            br.close();
            stream.close();
        }
        catch (Throwable t) {
            FMLLog.severe((String)"Error reading JRN File Data!", (Object[])new Object[0]);
            return "";
        }
        if (this.colors == null) {
            this.colors = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
        }
        return sb.toString();
    }

    public void WritePartToNBT(NBTTagCompound compound, int part) {
        ArrayList<NBTTagString> storyData = this.getStoryPart(part);
        if (storyData.equals("")) {
            return;
        }
        compound.func_74768_a("story_part", part);
        NBTTagString title = new NBTTagString(this.title);
        compound.func_74782_a("title", (NBTBase)title);
        NBTTagString author = new NBTTagString(this.author);
        compound.func_74782_a("author", (NBTBase)author);
        NBTTagList pages = new NBTTagList();
        for (NBTTagString page : storyData) {
            pages.func_74742_a((NBTBase)page);
        }
        compound.func_74782_a("pages", (NBTBase)pages);
    }

    public static void WritePartToNBT(NBTTagCompound compound, ArrayList<NBTTagString> storyData) {
        NBTTagList pages = new NBTTagList();
        for (NBTTagString page : storyData) {
            pages.func_74742_a((NBTBase)page);
        }
        compound.func_74782_a("pages", (NBTBase)pages);
    }

    public static ItemStack finalizeStory(ItemStack stack, String title, String author) {
        if (stack.field_77990_d == null) {
            return stack;
        }
        stack.field_77990_d.func_74782_a("title", (NBTBase)new NBTTagString(title));
        stack.field_77990_d.func_74782_a("author", (NBTBase)new NBTTagString(author));
        stack = InventoryUtilities.replaceItem(stack, Items.field_151164_bB);
        return stack;
    }

    public void WriteMultiplePartsToNBT(NBTTagCompound compound, List<Short> parts) {
        NBTTagString title = new NBTTagString(this.title);
        compound.func_74782_a("title", (NBTBase)title);
        NBTTagString author = new NBTTagString(this.author);
        compound.func_74782_a("author", (NBTBase)author);
        Collections.sort(parts);
        NBTTagList pages = new NBTTagList();
        for (Short i : parts) {
            ArrayList<NBTTagString> storyData = this.getStoryPart(i.shortValue());
            if (storyData.equals("")) continue;
            for (NBTTagString page : storyData) {
                pages.func_74742_a((NBTBase)page);
            }
        }
        compound.func_74782_a("pages", (NBTBase)pages);
    }

    public static ArrayList<NBTTagString> splitStoryPartIntoPages(String storyPart) {
        ArrayList<NBTTagString> parts = new ArrayList<NBTTagString>();
        String[] words = storyPart.split(" ");
        String currentPage = "";
        for (String word : words) {
            if (word.contains("<newpage>")) {
                int idx = word.indexOf("<newpage>");
                String preNewPage = word.substring(0, idx);
                String postNewPage = word.substring(idx + "<newpage>".length());
                while (preNewPage.endsWith("\n")) {
                    preNewPage = preNewPage.substring(0, preNewPage.lastIndexOf(10));
                }
                if (Story.getStringOverallLength(currentPage + preNewPage) > 256) {
                    parts.add(new NBTTagString(currentPage));
                    currentPage = preNewPage.trim();
                } else {
                    currentPage = currentPage + " " + preNewPage.trim();
                }
                parts.add(new NBTTagString(currentPage));
                while (postNewPage.startsWith("\n")) {
                    postNewPage = postNewPage.replaceFirst("\n", "");
                }
                currentPage = postNewPage.trim();
                continue;
            }
            if (Story.getStringOverallLength(currentPage + word) > 256) {
                parts.add(new NBTTagString(currentPage));
                currentPage = word;
                if (Story.getStringOverallLength(currentPage) <= 256) continue;
                currentPage = currentPage.substring(0, Story.getStringSplitIndex(currentPage, 255));
                parts.add(new NBTTagString(currentPage));
                currentPage = "";
                continue;
            }
            currentPage = currentPage.equals("") ? word.trim() : currentPage + " " + word;
        }
        parts.add(new NBTTagString(currentPage));
        return parts;
    }

    private static int getStringOverallLength(String s) {
        int length = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                length += length % 19;
                continue;
            }
            ++length;
        }
        return length;
    }

    private static int getStringSplitIndex(String s, int splitpoint) {
        int length = 0;
        int index = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            length = c == '\n' ? (length += length % 19) : ++length;
            if (length > splitpoint) {
                return index;
            }
            ++index;
        }
        return index - 1;
    }
}

