/*
 * Decompiled with CFR 0.152.
 */
package am2.guis;

import am2.AMCore;
import am2.api.math.AMVector2;
import am2.api.spell.ItemSpellBase;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.ContingencyTypes;
import am2.armor.ArmorHelper;
import am2.guis.AMGuiHelper;
import am2.guis.AMGuiIcons;
import am2.items.IBoundItem;
import am2.items.ItemSpellBook;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.AffinityData;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SkillManager;
import am2.spell.SpellUtils;
import am2.texture.ResourceManager;
import am2.texture.SpellIconManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class AMIngameGUI {
    private final Minecraft mc;
    private final RenderItem itemRenderer;
    private float zLevel;
    private static final short MANA_BAR_FLASH_SLOT = 4;
    private final PotionEffectDurationComparator durationComparator = new PotionEffectDurationComparator();
    private static final ResourceLocation inv_top = new ResourceLocation("arsmagica2", ResourceManager.GetGuiTexturePath("Inventory_Top.png"));
    private static final ResourceLocation mc_gui = new ResourceLocation("textures/gui/icons.png");
    private static final ResourceLocation spellbook_ui = new ResourceLocation("arsmagica2", ResourceManager.GetGuiTexturePath("spellbook_ui.png"));
    private static final ResourceLocation inventory = new ResourceLocation("textures/gui/container/inventory.png");
    private static final ResourceLocation items = new ResourceLocation("textures/atlas/items.png");

    public AMIngameGUI() {
        this.mc = Minecraft.func_71410_x();
        this.itemRenderer = new RenderItem();
    }

    public void renderGameOverlay() {
        ItemStack item;
        ItemStack ci = Minecraft.func_71410_x().field_71439_g.func_71045_bC();
        boolean drawAMHud = !AMCore.config.showHudMinimally() || ci != null && (ci.func_77973_b() == ItemsCommonProxy.spellBook || ci.func_77973_b() == ItemsCommonProxy.spell || ci.func_77973_b() == ItemsCommonProxy.arcaneSpellbook || ci.func_77973_b() instanceof IBoundItem);
        ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        GL11.glPushAttrib((int)278528);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (drawAMHud) {
            this.RenderBuffs(i, j);
        }
        this.mc.field_71446_o.func_110577_a(items);
        if (drawAMHud) {
            this.RenderContingency(i, j);
        }
        if (drawAMHud) {
            this.RenderArsMagicaGUIItems(i, j, this.mc.field_71466_p);
        }
        if (drawAMHud) {
            this.RenderAffinity(i, j);
        }
        this.RenderArmorStatus(i, j, this.mc, this.mc.field_71466_p);
        if (drawAMHud) {
            this.RenderMagicXP(i, j);
        }
        if ((item = this.mc.field_71439_g.func_71045_bC()) != null && item.func_77973_b() instanceof ItemSpellBook) {
            this.RenderSpellBookUI(i, j, this.mc.field_71466_p, this.mc.field_71439_g.func_71045_bC());
        }
        GL11.glPopAttrib();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void RenderArsMagicaGUIItems(int i, int j, FontRenderer fontRenderer) {
        if (ExtendedProperties.For((EntityLivingBase)this.mc.field_71439_g).getMagicLevel() > 0 || this.mc.field_71439_g.field_71075_bZ.field_75098_d) {
            this.RenderManaBar(i, j, fontRenderer);
        }
    }

    private void RenderSpellBookUI(int i, int j, FontRenderer fontrenderer, ItemStack bookStack) {
        this.mc.field_71446_o.func_110577_a(spellbook_ui);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AMVector2 spellbookVec = this.getShiftedVector(AMCore.config.getSpellBookPosition(), i, j);
        int spellUI_x = spellbookVec.iX;
        int spellUI_y = spellbookVec.iY;
        int spellUI_width = 148;
        int spellUI_height = 22;
        float activeSpellSize = 15.0f;
        int bookActiveSlot = ((ItemSpellBook)bookStack.func_77973_b()).GetActiveSlot(bookStack);
        float x = (float)spellUI_x + (float)bookActiveSlot * 12.9f;
        float y = spellUI_y;
        this.zLevel = -5.0f;
        this.drawTexturedModalRect_Classic(spellUI_x, spellUI_y, 0.0f, 0.0f, 106.0f, 15.0f, spellUI_width, spellUI_height);
        ItemStack[] activeScrolls = ((ItemSpellBook)bookStack.func_77973_b()).getActiveScrollInventory(bookStack);
        this.mc.field_71446_o.func_110577_a(items);
        this.zLevel = 0.0f;
        for (int n = 0; n < 8; ++n) {
            float IIconX = (float)spellUI_x + 1.5f + (float)n * 12.9f;
            ItemStack stackItem = activeScrolls[n];
            if (stackItem == null) continue;
            int d = 12;
            this.DrawIconAtXY(((ItemSpellBase)stackItem.func_77973_b()).func_77618_c(stackItem.func_77960_j(), 0), "items", IIconX, (float)spellUI_y + 1.5f, d, d, false);
            this.DrawIconAtXY(((ItemSpellBase)stackItem.func_77973_b()).func_77618_c(stackItem.func_77960_j(), 1), "items", IIconX, (float)spellUI_y + 1.5f, d, d, false);
        }
        this.mc.field_71446_o.func_110577_a(spellbook_ui);
        this.zLevel = 1000.0f;
        this.drawTexturedModalRect_Classic(x, y, 148.0f, 0.0f, activeSpellSize, activeSpellSize, 20.0f, 20.0f);
        this.zLevel = 0.0f;
        this.mc.field_71446_o.func_110577_a(mc_gui);
    }

    private void RenderManaBar(int i, int j, FontRenderer fontRenderer) {
        int barWidth = i / 8;
        AMVector2 fatigue_hud = this.getShiftedVector(AMCore.config.getBurnoutHudPosition(), i, j);
        AMVector2 mana_hud = this.getShiftedVector(AMCore.config.getManaHudPosition(), i, j);
        float green = 0.5f;
        float blue = 1.0f;
        float red = 0.126f;
        ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)this.mc.field_71439_g);
        float mana = props.getCurrentMana();
        float bonusMana = props.getBonusCurrentMana();
        float maxMana = props.getMaxMana();
        float fatigueBarWidth = barWidth;
        float fatigue = props.getCurrentFatigue();
        float maxFatigue = props.getMaxFatigue();
        if (mana + bonusMana > maxMana) {
            mana = maxMana;
        }
        float progressScaled = mana / (maxMana + 0.01f);
        if (AMCore.config.showHudBars()) {
            float flashTimer = AMGuiHelper.instance.getFlashTimer(4);
            if (flashTimer > 0.0f) {
                float pct;
                green = 0.0f;
                float redShift = 1.0f - red;
                float halfFlash = AMGuiHelper.instance.flashDuration / 2;
                if (flashTimer > halfFlash) {
                    pct = (flashTimer - halfFlash) / halfFlash;
                    red += redShift - redShift * pct;
                } else {
                    pct = flashTimer / halfFlash;
                    red += redShift * pct;
                }
                GL11.glColor3f((float)red, (float)green, (float)blue);
            } else if (bonusMana > 0.0f) {
                GL11.glColor3f((float)0.2f, (float)0.9f, (float)0.6f);
            }
            ItemStack curItem = Minecraft.func_71410_x().field_71439_g.func_71045_bC();
            if (curItem != null && (curItem.func_77973_b() == ItemsCommonProxy.spell || curItem.func_77973_b() == ItemsCommonProxy.spellBook || curItem.func_77973_b() == ItemsCommonProxy.arcaneSpellbook)) {
                ItemStack spellStack;
                ItemStack itemStack = spellStack = curItem.func_77973_b() == ItemsCommonProxy.spell ? curItem : ((ItemSpellBook)curItem.func_77973_b()).GetActiveItemStack(curItem);
                if (spellStack != null) {
                    int[] parts = SpellUtils.instance.getShapeGroupParts(spellStack);
                    int sx = mana_hud.iX - 2 * parts.length / 2;
                    int sy = mana_hud.iY - 2 * parts.length / 2;
                    for (int p : parts) {
                        IIcon icon = SpellIconManager.instance.getIcon(SkillManager.instance.getSkillName(SkillManager.instance.getSkill(p)));
                        if (icon == null) continue;
                        this.DrawIconAtXY(icon, "items", sx, sy, false);
                        sx += 3;
                        sy += 3;
                    }
                }
            }
            this.DrawPartialIconAtXY(AMGuiIcons.manaLevel, progressScaled, 1.0f, mana_hud.iX + 16, (float)mana_hud.iY + 1.0f, (int)((float)barWidth * 0.97f), 40.0f, false);
            this.DrawIconAtXY(AMGuiIcons.manaBar, "items", mana_hud.iX + 15, mana_hud.iY + 3, barWidth, 50, false);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            progressScaled = fatigue / (maxFatigue + 0.01f);
            this.DrawIconAtXY(AMGuiIcons.fatigueIcon, "items", fatigue_hud.iX + barWidth, fatigue_hud.iY, false);
            this.DrawPartialIconAtXY(AMGuiIcons.fatigueLevel, progressScaled, 1.0f, fatigue_hud.iX, (float)fatigue_hud.iY + 3.0f, fatigueBarWidth, 40.0f, false);
            this.DrawIconAtXY(AMGuiIcons.fatigueBar, "items", fatigue_hud.iX, fatigue_hud.iY + 4, barWidth, 48, false);
            green = 0.5f;
            blue = 1.0f;
            red = 0.126f;
            int manaBarColor = Math.round(red * 255.0f);
            manaBarColor = (manaBarColor << 8) + Math.round(green * 255.0f);
            manaBarColor = (manaBarColor << 8) + Math.round(blue * 255.0f);
            String magicLevel = "" + ExtendedProperties.For((EntityLivingBase)this.mc.field_71439_g).getMagicLevel();
            AMVector2 magicLevelPos = this.getShiftedVector(AMCore.config.getLevelPosition(), i, j);
            magicLevelPos.iX -= Minecraft.func_71410_x().field_71466_p.func_78256_a(magicLevel) / 2;
            fontRenderer.func_78261_a(magicLevel, magicLevelPos.iX, magicLevelPos.iY, manaBarColor);
            if (flashTimer > 0.0f) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (AMCore.config.getShowNumerics()) {
            String manaStr = StatCollector.func_74838_a((String)"am2.gui.mana") + ": " + (int)(mana + bonusMana) + "/" + (int)maxMana;
            String burnoutStr = StatCollector.func_74838_a((String)"am2.gui.burnout") + ": " + (int)props.getCurrentFatigue() + "/" + (int)props.getMaxFatigue();
            AMVector2 manaNumericPos = this.getShiftedVector(AMCore.config.getManaNumericPosition(), i, j);
            AMVector2 burnoutNumericPos = this.getShiftedVector(AMCore.config.getBurnoutNumericPosition(), i, j);
            fontRenderer.func_78276_b(manaStr, manaNumericPos.iX, manaNumericPos.iY, bonusMana > 0.0f ? 15393564 : 2130175);
            fontRenderer.func_78276_b(burnoutStr, burnoutNumericPos.iX + 25 - fontRenderer.func_78256_a(burnoutStr), burnoutNumericPos.iY, 0xFF2020);
        }
    }

    private ItemStack getSpellFromStack(ItemStack stack) {
        if (stack.func_77973_b() == ItemsCommonProxy.spell) {
            return stack;
        }
        if (stack.func_77973_b() == ItemsCommonProxy.spellBook || stack.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
            return ((ItemSpellBook)stack.func_77973_b()).GetActiveItemStack(stack);
        }
        return null;
    }

    private void RenderArmorStatus(int i, int j, Minecraft mc, FontRenderer fontRenderer) {
        if (!AMCore.config.showArmorUI()) {
            return;
        }
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        for (int slot = 0; slot < 4; ++slot) {
            float pct;
            if (!ArmorHelper.PlayerHasArmorInSlot((EntityPlayer)mc.field_71439_g, 3 - slot)) continue;
            AMVector2 position = this.getArmorSlotPosition(slot, scaledResolution.func_78326_a(), scaledResolution.func_78328_b());
            int blackoutTimer = AMGuiHelper.instance.getBlackoutTimer(3 - slot);
            int blackoutMaxTimer = AMGuiHelper.instance.getBlackoutTimerMax(3 - slot);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack armor = mc.field_71439_g.field_71071_by.field_70460_b[3 - slot];
            float lineweight = 4.0f;
            if (armor.func_77951_h() && armor.func_77958_k() > 0) {
                pct = 1.0f - (float)armor.func_77960_j() / (float)armor.func_77958_k();
                AMGuiHelper.line2d(position.iX, position.iY + 10, position.iX + 10, position.iY + 10, this.zLevel + 100.0f, lineweight, 0);
                int color = (int)(255.0f * (1.0f - pct)) << 16 | (int)(255.0f * pct) << 8;
                AMGuiHelper.line2d(position.iX, position.iY + 10, (float)position.iX + 10.0f * pct, position.iY + 10, this.zLevel + 101.0f, lineweight, color);
            }
            if (blackoutMaxTimer > 0) {
                pct = (float)(blackoutMaxTimer - blackoutTimer) / (float)blackoutMaxTimer;
                AMGuiHelper.line2d(position.iX, position.iY + 11, position.iX + 10, position.iY + 11, this.zLevel + 100.0f, lineweight, 0);
                AMGuiHelper.line2d(position.iX, position.iY + 11, (float)position.iX + 10.0f * pct, position.iY + 11, this.zLevel + 101.0f, lineweight, 0xFF0000);
            } else {
                AMGuiHelper.line2d(position.iX, position.iY + 11, position.iX + 10, position.iY + 11, this.zLevel + 101.0f, lineweight, 255);
            }
            IIcon icon = mc.field_71439_g.field_71071_by.field_70460_b[3 - slot].func_77954_c();
            if (icon != null) {
                AMGuiHelper.DrawIconAtXY(icon, position.iX, position.iY, this.zLevel, 10, 10, true);
                continue;
            }
            AMGuiHelper.DrawItemAtXY(mc.field_71439_g.field_71071_by.field_70460_b[3 - slot], position.iX, position.iY, this.zLevel, 0.63f);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private AMVector2 getArmorSlotPosition(int slot, int screenWidth, int screenHeight) {
        switch (slot) {
            case 0: {
                return this.getShiftedVector(AMCore.config.getArmorPositionHead(), screenWidth, screenHeight);
            }
            case 1: {
                return this.getShiftedVector(AMCore.config.getArmorPositionChest(), screenWidth, screenHeight);
            }
            case 2: {
                return this.getShiftedVector(AMCore.config.getArmorPositionLegs(), screenWidth, screenHeight);
            }
            case 3: {
                return this.getShiftedVector(AMCore.config.getArmorPositionBoots(), screenWidth, screenHeight);
            }
        }
        return new AMVector2(0.0, 0.0);
    }

    public void RenderAffinity(int i, int j) {
        AMVector2 affinityPos = this.getShiftedVector(AMCore.config.getAffinityPosition(), i, j);
        int x = affinityPos.iX;
        int y = affinityPos.iY;
        AffinityData ad = AffinityData.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        for (Affinity affinity : ad.getHighestAffinities()) {
            if (affinity == null || affinity == Affinity.NONE) continue;
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            AMGuiHelper.DrawIconAtXY(affinity.representItem.func_77617_a(affinity.representMeta), x, y, j, 12, 12, true);
            if (AMCore.config.getShowNumerics()) {
                String display = String.format("%.2f%%", Float.valueOf(AffinityData.For((EntityLivingBase)this.mc.field_71439_g).getAffinityDepth(affinity) * 100.0f));
                if (x < i / 2) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(display, x + 14, y + 2, affinity.color);
                } else {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(display, x - 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(display), y + 2, affinity.color);
                }
            }
            y += 15;
        }
    }

    public void RenderContingency(int i, int j) {
        AMVector2 contingencyPos = this.getShiftedVector(AMCore.config.getContingencyPosition(), i, j);
        IIcon icon = null;
        ContingencyTypes type = ExtendedProperties.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).getContingencyType();
        switch (type) {
            case DAMAGE_TAKEN: {
                icon = SpellIconManager.instance.getIcon("Contingency_Damage");
                break;
            }
            case FALL: {
                icon = SpellIconManager.instance.getIcon("Contingency_Fall");
                break;
            }
            case HEALTH_LOW: {
                icon = SpellIconManager.instance.getIcon("Contingency_Health");
                break;
            }
            case ON_FIRE: {
                icon = SpellIconManager.instance.getIcon("Contingency_Fire");
                break;
            }
            case DEATH: {
                icon = SpellIconManager.instance.getIcon("Contingency_Death");
                break;
            }
            default: {
                return;
            }
        }
        this.DrawIconAtXY(icon, "items", contingencyPos.iX, contingencyPos.iY, 16, 16, true);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void RenderBuffs(int i, int j) {
        if (!AMCore.config.getShowBuffs()) {
            return;
        }
        int barWidth = i / 8;
        AMVector2 posBuffStart = this.getShiftedVector(AMCore.config.getPositiveBuffsPosition(), i, j);
        AMVector2 negBuffStart = this.getShiftedVector(AMCore.config.getNegativeBuffsPosition(), i, j);
        int positive_buff_x = posBuffStart.iX;
        int positive_buff_y = posBuffStart.iY;
        int negative_buff_x = negBuffStart.iX;
        int negative_buff_y = negBuffStart.iY;
        for (PotionEffect pe : this.getPotionEffectsByTimeRemaining()) {
            int l;
            Potion potion;
            this.mc.field_71446_o.func_110577_a(inventory);
            int potionID = pe.func_76456_a();
            if (potionID < 0 || potionID >= Potion.field_76425_a.length || (potion = Potion.field_76425_a[potionID]) == null) continue;
            if (potion.func_76398_f()) {
                if (!potion.func_76400_d()) continue;
                l = potion.func_76392_e();
                if (pe.func_76459_b() < 100) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)AMGuiHelper.instance.fastFlashAlpha);
                } else if (pe.func_76459_b() < 200) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)AMGuiHelper.instance.slowFlashAlpha);
                }
                this.drawTexturedModalRect_Classic(negative_buff_x, negative_buff_y, 0 + l % 8 * 18, 198 + l / 8 * 18, 10.0f, 10.0f, 18.0f, 18.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if ((negative_buff_x -= 12) > negBuffStart.iX - 48) continue;
                negative_buff_x = negBuffStart.iX;
                negative_buff_y += 12;
                continue;
            }
            this.mc.field_71446_o.func_110577_a(inventory);
            if (!potion.func_76400_d()) continue;
            l = potion.func_76392_e();
            if (pe.func_76459_b() < 100) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)AMGuiHelper.instance.fastFlashAlpha);
            } else if (pe.func_76459_b() < 200) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)AMGuiHelper.instance.slowFlashAlpha);
            }
            this.drawTexturedModalRect_Classic(positive_buff_x, positive_buff_y, 0 + l % 8 * 18, 198 + l / 8 * 18, 10.0f, 10.0f, 18.0f, 18.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if ((positive_buff_x += 12) < posBuffStart.iX + 48) continue;
            positive_buff_x = posBuffStart.iX;
            positive_buff_y += 12;
        }
    }

    public void RenderMagicXP(int i, int j) {
        ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        if (props.getMagicLevel() > 0) {
            AMVector2 position = this.getShiftedVector(AMCore.config.getXPBarPosition(), i, j);
            AMVector2 dimensions = new AMVector2(182.0, 5.0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(mc_gui);
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)(AMCore.config.showXPAlways() ? 1.0f : AMGuiHelper.instance.getMagicXPBarAlpha()));
            this.drawTexturedModalRect_Classic(position.iX, position.iY, 0.0f, 64.0f, dimensions.iX, dimensions.iY, dimensions.iX, dimensions.iY);
            if (props.getMagicXP() > 0.0f) {
                float pctXP = props.getMagicXP() / props.getXPToNextLevel();
                if (pctXP > 1.0f) {
                    pctXP = 1.0f;
                }
                int width = (int)((float)(dimensions.iX + 1) * pctXP);
                this.drawTexturedModalRect_Classic(position.iX, position.iY, 0.0f, 69.0f, width, dimensions.iY, width, dimensions.iY);
            }
            if (AMCore.config.getShowNumerics() && (AMCore.config.showXPAlways() || AMGuiHelper.instance.getMagicXPBarAlpha() > 0.0f)) {
                String xpStr = StatCollector.func_74838_a((String)"am2.gui.xp") + ": " + (int)(props.getMagicXP() * 100.0f) + "/" + (int)(props.getXPToNextLevel() * 100.0f);
                AMVector2 numericPos = this.getShiftedVector(AMCore.config.getXPNumericPosition(), i, j);
                Minecraft.func_71410_x().field_71466_p.func_78276_b(xpStr, numericPos.iX, numericPos.iY, 0x999999);
            }
        }
    }

    private ArrayList<PotionEffect> getPotionEffectsByTimeRemaining() {
        Iterator i = this.mc.field_71439_g.func_70651_bq().iterator();
        ArrayList<PotionEffect> potions = new ArrayList<PotionEffect>();
        while (i.hasNext()) {
            potions.add((PotionEffect)i.next());
        }
        Collections.sort(potions, this.durationComparator);
        return potions;
    }

    public void drawTexturedModalRect_Classic(int par1, int par2, int par3, int par4, int par5, int par6) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(par1 + 0), (double)(par2 + par6), (double)this.zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)this.zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a((double)(par1 + par5), (double)(par2 + 0), (double)this.zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)this.zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_78381_a();
    }

    public void drawTexturedModalRect_Classic(float dst_x, float dst_y, float src_x, float src_y, float dst_width, float dst_height, float src_width, float src_height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(dst_x + 0.0f), (double)(dst_y + dst_height), (double)this.zLevel, (double)((src_x + 0.0f) * var7), (double)((src_y + src_height) * var8));
        var9.func_78374_a((double)(dst_x + dst_width), (double)(dst_y + dst_height), (double)this.zLevel, (double)((src_x + src_width) * var7), (double)((src_y + src_height) * var8));
        var9.func_78374_a((double)(dst_x + dst_width), (double)(dst_y + 0.0f), (double)this.zLevel, (double)((src_x + src_width) * var7), (double)((src_y + 0.0f) * var8));
        var9.func_78374_a((double)(dst_x + 0.0f), (double)(dst_y + 0.0f), (double)this.zLevel, (double)((src_x + 0.0f) * var7), (double)((src_y + 0.0f) * var8));
        var9.func_78381_a();
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float var9 = 0.0f;
        float var10 = 1.0f;
        float var11 = 0.0f;
        float var12 = 1.0f;
        Tessellator var8 = Tessellator.field_78398_a;
        var8.func_78382_b();
        var8.func_78375_b(0.0f, 1.0f, 0.0f);
        var8.func_78374_a((double)(par1 + 0), (double)(par2 + par6), (double)this.zLevel, (double)var9, (double)var12);
        var8.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)this.zLevel, (double)var10, (double)var12);
        var8.func_78374_a((double)(par1 + par5), (double)(par2 + 0), (double)this.zLevel, (double)var10, (double)var11);
        var8.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)this.zLevel, (double)var9, (double)var11);
        var8.func_78381_a();
    }

    private void renderPortalOverlay(float par1, int par2, int par3) {
    }

    private void DrawIconAtXY(IIcon icon, String base, float x, float y, boolean semitransparent) {
        this.DrawIconAtXY(icon, base, x, y, 16, 16, semitransparent);
    }

    private void DrawIconAtXY(IIcon IIcon2, String base, float x, float y, int w, int h, boolean semitransparent) {
        if (IIcon2 == null) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + (float)h), (double)this.zLevel, (double)IIcon2.func_94209_e(), (double)IIcon2.func_94210_h());
        tessellator.func_78374_a((double)(x + (float)w), (double)(y + (float)h), (double)this.zLevel, (double)IIcon2.func_94212_f(), (double)IIcon2.func_94210_h());
        tessellator.func_78374_a((double)(x + (float)w), (double)y, (double)this.zLevel, (double)IIcon2.func_94212_f(), (double)IIcon2.func_94206_g());
        tessellator.func_78374_a((double)x, (double)y, (double)this.zLevel, (double)IIcon2.func_94209_e(), (double)IIcon2.func_94206_g());
        tessellator.func_78381_a();
    }

    private void DrawPartialIconAtXY(IIcon IIcon2, float pct_x, float pct_y, float x, float y, float w, float h, boolean semitransparent) {
        if (IIcon2 == null) {
            return;
        }
        this.mc.field_71446_o.func_110577_a(items);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + h * pct_y), (double)this.zLevel, (double)IIcon2.func_94209_e(), (double)IIcon2.func_94210_h());
        tessellator.func_78374_a((double)(x + w * pct_x), (double)(y + h * pct_y), (double)this.zLevel, (double)IIcon2.func_94212_f(), (double)IIcon2.func_94210_h());
        tessellator.func_78374_a((double)(x + w * pct_x), (double)y, (double)this.zLevel, (double)IIcon2.func_94212_f(), (double)IIcon2.func_94206_g());
        tessellator.func_78374_a((double)x, (double)y, (double)this.zLevel, (double)IIcon2.func_94209_e(), (double)IIcon2.func_94206_g());
        tessellator.func_78381_a();
    }

    private AMVector2 getShiftedVector(AMVector2 configVec, int screenWidth, int screenHeight) {
        int x = (int)Math.round(configVec.x * (double)screenWidth);
        int y = (int)Math.round(configVec.y * (double)screenHeight);
        return new AMVector2(x, y);
    }

    class PotionEffectDurationComparator
    implements Comparator<PotionEffect> {
        @Override
        public int compare(PotionEffect o1, PotionEffect o2) {
            if (o1.func_76459_b() < o2.func_76459_b()) {
                return -1;
            }
            if (o1.func_76459_b() > o2.func_76459_b()) {
                return 1;
            }
            return 0;
        }
    }
}

