/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.api.math.AMVector3;
import am2.api.power.PowerTypes;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.blocks.tileentities.TileEntityCraftingAltar;
import am2.entities.EntityShadowHelper;
import am2.items.ItemsCommonProxy;
import am2.power.PowerNodeRegistry;
import am2.utility.InventoryUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityOtherworldAura
extends TileEntityAMPower {
    private PowerTypes[] valid = new PowerTypes[]{PowerTypes.DARK, PowerTypes.NEUTRAL};
    private ArrayList<AMVector3> nearbyInventories;
    private boolean active;
    private TileEntityCraftingAltar watchTarget;
    private int delayCounter;
    private boolean cantFindItem = false;
    private String placedByUsername = "";
    private EntityShadowHelper helper;

    public TileEntityOtherworldAura() {
        super(200);
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 100;
    }

    @Override
    public PowerTypes[] getValidPowerTypes() {
        return this.valid;
    }

    public void setActive(boolean active, TileEntityCraftingAltar watchMe) {
        if (active && this.active) {
            return;
        }
        this.active = active;
        if (active) {
            this.refreshNearbyInventories();
            this.watchTarget = watchMe;
        } else {
            this.nearbyInventories = null;
            this.watchTarget = null;
            if (this.helper != null) {
                this.helper.unSummon();
                this.helper = null;
            }
        }
    }

    private void refreshNearbyInventories() {
        this.nearbyInventories = new ArrayList();
        int radius = 6;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    TileEntity te;
                    if (i == 0 && j == 0 && k == 0 || (te = this.field_145850_b.func_147438_o(this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e + k)) == null || !(te instanceof IInventory)) continue;
                    this.nearbyInventories.add(new AMVector3(te));
                }
            }
        }
    }

    private AMVector3 findInNearbyInventories(ItemStack search) {
        Iterator<AMVector3> it = this.nearbyInventories.iterator();
        while (it.hasNext()) {
            AMVector3 vec = it.next();
            TileEntity te = this.field_145850_b.func_147438_o((int)vec.x, (int)vec.y, (int)vec.z);
            if (te == null || !(te instanceof IInventory)) {
                it.remove();
                continue;
            }
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < 6; ++i) {
                if (!InventoryUtilities.inventoryHasItem(inventory, search, 1, i)) continue;
                return vec;
            }
        }
        return null;
    }

    private void spawnHelper() {
        if (this.helper != null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.helper = new EntityShadowHelper(this.field_145850_b);
        this.helper.func_70107_b(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (this.watchTarget != null) {
            this.helper.setAltarTarget(this.watchTarget);
        }
        this.field_145850_b.func_72838_d((Entity)this.helper);
        if (this.watchTarget != null) {
            this.helper.setDropoffLocation(new AMVector3(this.watchTarget.field_145851_c, this.watchTarget.field_145848_d - 2, this.watchTarget.field_145849_e));
            if (this.placedByUsername != null && !this.placedByUsername.isEmpty()) {
                this.helper.setMimicUser(this.placedByUsername);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void func_145845_h() {
        block11: {
            block12: {
                block13: {
                    super.func_145845_h();
                    if (this.nearbyInventories == null) {
                        return;
                    }
                    if (this.watchTarget == null || !this.watchTarget.isCrafting()) {
                        this.setActive(false, null);
                        return;
                    }
                    if (this.helper != null && this.helper.field_70128_L) {
                        return;
                    }
                    if (this.field_145850_b.field_72995_K) break block11;
                    if (!PowerNodeRegistry.For(this.field_145850_b).checkPower(this, 1.25f)) break block12;
                    if (this.delayCounter-- > 0) break block13;
                    if (this.helper == null) {
                        this.spawnHelper();
                    }
                    if ((next = this.watchTarget.getNextPlannedItem()) == null) {
                        this.setActive(false, null);
                        return;
                    }
                    if (next.func_77973_b() != ItemsCommonProxy.essence) ** GOTO lbl-1000
                    if (next.func_77960_j() > 12) {
                        if (!this.helper.hasSearchLocation()) {
                            this.helper.setSearchLocationAndItem(new AMVector3(1.0, 1.0, 1.0), next);
                        }
                        this.delayCounter = 100;
                    } else lbl-1000:
                    // 2 sources

                    {
                        if ((location = this.findInNearbyInventories(next)) == null) {
                            this.delayCounter = 20;
                            this.cantFindItem = true;
                            return;
                        }
                        this.cantFindItem = false;
                        if (!this.helper.hasSearchLocation()) {
                            this.helper.setSearchLocationAndItem(location, next);
                        }
                        this.delayCounter = 20;
                    }
                }
                PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), 1.25f);
                break block11;
            }
            if (this.helper != null) {
                this.helper.unSummon();
            }
        }
    }

    public void setPlacedByUsername(String userName) {
        this.placedByUsername = userName;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74778_a("placedBy", this.placedByUsername);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.placedByUsername = nbttagcompound.func_74779_i("placedBy");
    }
}

