/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.blocks.BlocksCommonProxy;
import am2.bosses.BossSpawnHelper;
import am2.damage.DamageSources;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInlay
extends BlockRailBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private final int material;
    public static final int TYPE_REDSTONE = 0;
    public static final int TYPE_IRON = 1;
    public static final int TYPE_GOLD = 2;
    private static final String minecartGoldInlayKey = "AM2GoldInlayTimer";

    public BlockInlay(int type) {
        super(false);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.material = type;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.01f, 1.0f);
        this.func_149713_g(0);
        this.func_149675_a(true);
    }

    public void func_149651_a(IIconRegister IIconRegister2) {
        String[] textures = new String[]{"Inlay_Straight_Redstone", "Inlay_Straight_Iron", "Inlay_Straight_Gold", "Inlay_Corner_Redstone", "Inlay_Corner_Iron", "Inlay_Corner_Gold"};
        this.icons = new IIcon[textures.length];
        int count = 0;
        for (String s : textures) {
            this.icons[count++] = ResourceManager.RegisterTexture(s, IIconRegister2);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side > 1) {
            return null;
        }
        boolean corner = meta >= 6;
        int index = this.material;
        if (corner) {
            index += 3;
        }
        return this.icons[index];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        return this.func_149691_a(par5, par1iBlockAccess.func_72805_g(par2, par3, par4));
    }

    private void setValid(World world, int x, int y, int z, boolean valid) {
        int meta = world.func_72805_g(x, y, z);
        meta = valid ? (meta |= 8) : (meta &= 0xFFFFFFF7);
        world.func_72921_c(x, y, z, meta, 2);
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        AMParticle particle;
        int meta = world.func_72805_g(x, y, z);
        if (world.field_72995_K && world.func_147439_a(x, y - 1, z).isAir((IBlockAccess)world, x, y, z) && AMCore.config.FullGFX() && rand.nextInt(10) < 4 && (particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, AMCore.config.FullGFX() ? "radiant" : "sparkle2", (float)x + rand.nextFloat(), y, (float)z + rand.nextFloat()))) != null) {
            particle.setMaxAge(20);
            particle.setParticleScale(AMCore.config.FullGFX() ? 0.015f : 0.15f);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.01f, -0.025f, 1, false));
            if (this == BlocksCommonProxy.redstoneInlay) {
                particle.setRGBColorF(1.0f, 0.4f, 0.4f);
            } else if (this == BlocksCommonProxy.ironInlay) {
                particle.setRGBColorF(1.0f, 1.0f, 1.0f);
            } else if (this == BlocksCommonProxy.goldInlay) {
                particle.setRGBColorF(1.0f, 1.0f, 0.2f);
            }
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
    }

    public boolean canMakeSlopes(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, int y, int x, int z) {
        if (this.material == 0) {
            return 0.7f;
        }
        return 0.4f;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placingEntity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, placingEntity, stack);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((double)par3 + this.field_149756_F), (double)((double)par4 + this.field_149757_G));
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        if (par7Entity instanceof EntityMinecart) {
            return;
        }
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockID, int meta) {
        this.checkNeighbors(world, x, y, z);
    }

    private void checkNeighbors(World world, int x, int y, int z) {
        int myMeta = world.func_72805_g(x, y, z);
        if ((myMeta & 8) != 0) {
            world.func_72921_c(x, y, z, myMeta & 0xFFFFFFF7, 2);
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (world.func_147439_a(x + i, y, z + j) != this || (world.func_72805_g(x + i, y, z + j) & 8) == 0) continue;
                    this.checkNeighbors(world, x + i, y, z + j);
                }
            }
        }
    }

    public int func_149738_a(World par1World) {
        return 60 + par1World.field_73012_v.nextInt(80);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            int meta = world.func_72805_g(x, y, z);
            if (meta == 6) {
                this.checkPattern(world, x, y, z);
            }
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    private void checkPattern(World world, int x, int y, int z) {
        boolean allGood = true;
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                if (i == 1 && j == 1) continue;
                allGood &= world.func_147439_a(x + i, y, z + j) == this;
            }
        }
        if (allGood && !world.field_72995_K && !this.checkForIceEffigy(world, x, y, z)) {
            this.checkForLightningEffigy(world, x, y, z);
        }
    }

    private boolean checkForIceEffigy(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y, z + 1) == BlocksCommonProxy.AMOres && world.func_72805_g(x + 1, y, z + 1) == 7 && world.func_147439_a(x + 1, y + 1, z + 1) == BlocksCommonProxy.AMOres && world.func_72805_g(x + 1, y + 1, z + 1) == 7 && world.func_147439_a(x + 1, y + 2, z + 1) == Blocks.field_150432_aD) {
            int iceMeta = world.func_72805_g(x + 1, y + 2, z + 1);
            if (iceMeta > 0) {
                AMCore.proxy.particleManager.RibbonFromPointToPoint(world, (double)x + 1.5, y + 2, (double)z + 1.5, x + 2, y + 3, z + 2);
            }
            if (iceMeta >= 3) {
                BossSpawnHelper.instance.onIceEffigyBuilt(world, x + 1, y, z + 1);
            } else {
                List snowmen = world.func_72872_a(EntitySnowman.class, AxisAlignedBB.func_72330_a((double)(x - 9), (double)(y - 2), (double)(z - 9), (double)(x + 10), (double)(y + 4), (double)(z + 10)));
                if (snowmen.size() > 0) {
                    ((EntitySnowman)snowmen.get(0)).func_70097_a((DamageSource)DamageSources.unsummon, 5000.0f);
                    world.func_72921_c(x + 1, y + 2, z + 1, ++iceMeta, 2);
                    AMCore.proxy.particleManager.BeamFromEntityToPoint(world, (Entity)snowmen.get(0), (double)x + 1.5, (double)y + 2.5, (double)z + 1.5);
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkForLightningEffigy(World world, int x, int y, int z) {
        if (!world.func_72896_J()) {
            return false;
        }
        if (world.func_147439_a(x + 1, y, z + 1) == BlocksCommonProxy.manaBattery && world.func_147439_a(x + 1, y + 1, z + 1) == Blocks.field_150411_aY && world.func_147439_a(x + 1, y + 2, z + 1) == Blocks.field_150411_aY) {
            int fenceMeta = world.func_72805_g(x + 1, y + 2, z + 1);
            if (fenceMeta > 0) {
                AMCore.proxy.particleManager.RibbonFromPointToPoint(world, (double)x + 1.5, y + 2, (double)z + 1.5, x + 2, y + 3, z + 2);
            }
            world.func_72921_c(x + 1, y + 2, z + 1, ++fenceMeta, 2);
            if (!world.field_72995_K) {
                int i;
                for (i = 0; i < 5; ++i) {
                    AMCore.proxy.particleManager.BoltFromPointToPoint(world, (double)x + 1.5, y + 30, (double)z + 1.5, (double)x + 1.5, y + 2, (double)z + 1.5);
                }
                for (i = 0; i < fenceMeta; ++i) {
                    world.func_72908_a((double)x, (double)y, (double)z, "ambient.weather.thunder", 1.0f, world.field_73012_v.nextFloat() + 0.5f);
                }
            }
            if (fenceMeta >= 3) {
                BossSpawnHelper.instance.onLightningEffigyBuilt(world, x + 1, y, z + 1);
            }
            return true;
        }
        return false;
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        Block block = par1World.func_147439_a(par2, par3 - 1, par4);
        return block != null && block.func_149662_c();
    }

    public int func_149645_b() {
        return BlocksCommonProxy.commonBlockRenderID;
    }

    public void onMinecartPass(World world, EntityMinecart cart, int x, int y, int z) {
        if (cart == null) {
            return;
        }
        long millisSinceLastTeleport = cart.getEntityData().func_74763_f(minecartGoldInlayKey);
        int meta = world.func_72805_g(x, y, z);
        if (this.material == 0) {
            float limit = 2.0f;
            if (meta == 1) {
                if (cart.field_70159_w > 0.0 && cart.field_70159_w < (double)limit) {
                    cart.field_70159_w *= (double)1.1f;
                } else if (cart.field_70159_w < 0.0 && cart.field_70159_w > (double)(-limit)) {
                    cart.field_70159_w *= (double)1.1f;
                }
            } else if (meta == 0) {
                if (cart.field_70179_y > 0.0 && cart.field_70179_y < (double)limit) {
                    cart.field_70179_y *= (double)1.1f;
                } else if (cart.field_70179_y < 0.0 && cart.field_70179_y > (double)(-limit)) {
                    cart.field_70179_y *= (double)1.1f;
                }
            }
        } else if (this.material == 1) {
            if (meta == 1) {
                cart.field_70159_w = -cart.field_70159_w * 0.5;
                if (cart.field_70159_w < 0.0) {
                    cart.func_70107_b((double)x - 0.02, cart.field_70163_u, cart.field_70161_v);
                } else if (cart.field_70159_w > 0.0) {
                    cart.func_70107_b((double)x + 1.02, cart.field_70163_u, cart.field_70161_v);
                }
            } else if (meta == 0) {
                cart.field_70179_y = -cart.field_70179_y * 0.5;
                if (cart.field_70179_y < 0.0) {
                    cart.func_70107_b(cart.field_70165_t, cart.field_70163_u, (double)z - 0.02);
                } else if (cart.field_70179_y > 0.0) {
                    cart.func_70107_b(cart.field_70165_t, cart.field_70163_u, (double)z + 1.02);
                }
            }
        } else if (this.material == 2) {
            boolean cooldownPassed;
            int i;
            AMVector3 teleportLocation = null;
            if (meta == 1) {
                if (cart.field_70159_w > 0.0) {
                    for (i = 1; i <= 8; ++i) {
                        if (world.func_147439_a(x + i, y, z) != BlocksCommonProxy.goldInlay) continue;
                        teleportLocation = new AMVector3(x + i, y, z);
                        break;
                    }
                } else if (cart.field_70159_w < 0.0) {
                    for (i = 1; i <= 8; ++i) {
                        if (world.func_147439_a(x - i, y, z) != BlocksCommonProxy.goldInlay) continue;
                        teleportLocation = new AMVector3(x - i, y, z);
                        break;
                    }
                }
            } else if (meta == 0) {
                if (cart.field_70179_y > 0.0) {
                    for (i = 1; i <= 8; ++i) {
                        if (world.func_147439_a(x, y, z + i) != BlocksCommonProxy.goldInlay) continue;
                        teleportLocation = new AMVector3(x, y, z + i);
                        break;
                    }
                } else if (cart.field_70179_y < 0.0) {
                    for (i = 1; i <= 8; ++i) {
                        if (world.func_147439_a(x, y, z - i) != BlocksCommonProxy.goldInlay) continue;
                        teleportLocation = new AMVector3(x, y, z - i);
                        break;
                    }
                }
            }
            int teleportMeta = teleportLocation != null ? world.func_72805_g((int)teleportLocation.x, (int)teleportLocation.x, (int)teleportLocation.z) : -1;
            long time = System.currentTimeMillis();
            boolean bl = cooldownPassed = time - millisSinceLastTeleport > 5000L;
            if (teleportLocation != null && (teleportMeta == 1 || teleportMeta == 0) && cooldownPassed) {
                world.func_72908_a((double)teleportLocation.x, (double)teleportLocation.y, (double)teleportLocation.z, "mob.endermen.portal", 1.0f, 1.0f);
                world.func_72908_a(cart.field_70165_t, cart.field_70163_u, cart.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
                cart.func_70107_b((double)teleportLocation.x, (double)teleportLocation.y, (double)teleportLocation.z);
                cart.getEntityData().func_74772_a(minecartGoldInlayKey, time);
            }
        }
    }
}

