/*
 * Decompiled with CFR 0.152.
 */
package am2.api.power;

import am2.api.ArsMagicaApi;
import cpw.mods.fml.common.FMLLog;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public final class PowerTypes {
    public static final PowerTypes NONE = new PowerTypes(0, "None", "\u00a7f");
    public static final PowerTypes LIGHT = new PowerTypes(1, "Light", "\u00a7b");
    public static final PowerTypes NEUTRAL = new PowerTypes(2, "Neutral", "\u00a71");
    public static final PowerTypes DARK = new PowerTypes(4, "Dark", "\u00a74");
    private static final ArrayList<PowerTypes> allPowerTypes = new ArrayList<PowerTypes>(){
        {
            this.add(LIGHT);
            this.add(NEUTRAL);
            this.add(DARK);
        }
    };
    private int _id;
    private String _name;
    private String _chatColor;

    private PowerTypes(int ID, String name, String chatColor) {
        if ((ID & -ID) != ID) {
            throw new InvalidParameterException(String.format("ID must be a bitflag that is a power of 2!  (You used %d)", ID));
        }
        this._id = ID;
        this._name = name;
        this._chatColor = chatColor;
    }

    public static void RegisterPowerType(int id, String name, String chatColor) {
        if (PowerTypes.getByID(id) == NONE) {
            FMLLog.info((String)"Ars Magica 2 >> Attempted to register power type %s with ID of %d, but that ID is already taken!  The type was NOT registered!", (Object[])new Object[]{name, id});
        } else {
            allPowerTypes.add(new PowerTypes(id, name, chatColor));
            FMLLog.info((String)"Ars Magica 2 >> Registered new power type %s with ID %d", (Object[])new Object[]{name, id});
        }
    }

    public int ID() {
        return this._id;
    }

    public String name() {
        return this._name;
    }

    public String chatColor() {
        if (ArsMagicaApi.instance.getColourblindMode()) {
            return "";
        }
        return this._chatColor;
    }

    public static PowerTypes[] all() {
        return allPowerTypes.toArray(new PowerTypes[allPowerTypes.size()]);
    }

    public static PowerTypes getByID(int id) {
        for (PowerTypes type : PowerTypes.all()) {
            if (type.ID() != id) continue;
            return type;
        }
        return NONE;
    }
}

