/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects;

import WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.IMeleeSpellEntityEffect;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class ExtrapolatedMeleeEntityEffect
implements IMeleeSpellEntityEffect {
    protected float range;
    protected float radius;
    protected int powerUpgrades;
    protected int potencyUpgrades;
    protected int costUpgrades;
    protected int maxHit;

    public ExtrapolatedMeleeEntityEffect(int power, int potency, int cost) {
        this.powerUpgrades = power;
        this.potencyUpgrades = potency;
        this.costUpgrades = cost;
        this.range = 0.0f;
        this.radius = 0.0f;
        this.maxHit = 1;
    }

    @Override
    public void onEntityImpact(World world, EntityPlayer entityPlayer) {
        Vec3 lookVec = entityPlayer.func_70676_i(this.range);
        double x = entityPlayer.field_70165_t + lookVec.field_72450_a;
        double y = entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e() + lookVec.field_72448_b;
        double z = entityPlayer.field_70161_v + lookVec.field_72449_c;
        List entities = world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(x - 0.5), (double)(y - 0.5), (double)(z - 0.5), (double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5)).func_72314_b((double)this.radius, (double)this.radius, (double)this.radius));
        int hit = 0;
        if (entities != null) {
            for (Entity entity : entities) {
                if (hit >= this.maxHit || entity.equals((Object)entityPlayer) || !this.entityEffect(world, entity, entityPlayer)) continue;
                ++hit;
            }
        }
    }

    protected abstract boolean entityEffect(World var1, Entity var2, EntityPlayer var3);

    public void setRange(float range) {
        this.range = range;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setMaxNumberHit(int maxHit) {
        this.maxHit = maxHit;
    }
}

