/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect;

import WayofTime.alchemicalWizardry.common.spell.complex.SpellModifier;
import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigm;
import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigmMelee;
import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigmProjectile;
import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigmSelf;
import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigmTool;
import WayofTime.alchemicalWizardry.common.spell.complex.enhancement.SpellEnhancement;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SpellEffect {
    protected int modifierState = 0;
    protected int powerEnhancement = 0;
    protected int costEnhancement = 0;
    protected int potencyEnhancement = 0;

    public void enhanceEffect(SpellEnhancement enh) {
        if (enh != null) {
            switch (enh.getState()) {
                case 0: {
                    ++this.powerEnhancement;
                    break;
                }
                case 1: {
                    ++this.costEnhancement;
                    break;
                }
                case 2: {
                    ++this.potencyEnhancement;
                }
            }
        }
    }

    public void modifyEffect(SpellModifier mod) {
        if (mod != null) {
            this.modifierState = mod.getModifier();
        }
    }

    public void modifyParadigm(SpellParadigm parad) {
        if (parad instanceof SpellParadigmProjectile) {
            this.modifyProjectileParadigm((SpellParadigmProjectile)parad);
        }
        if (parad instanceof SpellParadigmSelf) {
            this.modifySelfParadigm((SpellParadigmSelf)parad);
        }
        if (parad instanceof SpellParadigmMelee) {
            this.modifyMeleeParadigm((SpellParadigmMelee)parad);
        }
        if (parad instanceof SpellParadigmTool) {
            this.modifyToolParadigm((SpellParadigmTool)parad);
        }
    }

    public void modifyProjectileParadigm(SpellParadigmProjectile parad) {
        switch (this.modifierState) {
            case 0: {
                this.defaultModificationProjectile(parad);
                break;
            }
            case 1: {
                this.offensiveModificationProjectile(parad);
                break;
            }
            case 2: {
                this.defensiveModificationProjectile(parad);
                break;
            }
            case 3: {
                this.environmentalModificationProjectile(parad);
            }
        }
    }

    public abstract void defaultModificationProjectile(SpellParadigmProjectile var1);

    public abstract void offensiveModificationProjectile(SpellParadigmProjectile var1);

    public abstract void defensiveModificationProjectile(SpellParadigmProjectile var1);

    public abstract void environmentalModificationProjectile(SpellParadigmProjectile var1);

    public void modifySelfParadigm(SpellParadigmSelf parad) {
        switch (this.modifierState) {
            case 0: {
                this.defaultModificationSelf(parad);
                break;
            }
            case 1: {
                this.offensiveModificationSelf(parad);
                break;
            }
            case 2: {
                this.defensiveModificationSelf(parad);
                break;
            }
            case 3: {
                this.environmentalModificationSelf(parad);
            }
        }
    }

    public abstract void defaultModificationSelf(SpellParadigmSelf var1);

    public abstract void offensiveModificationSelf(SpellParadigmSelf var1);

    public abstract void defensiveModificationSelf(SpellParadigmSelf var1);

    public abstract void environmentalModificationSelf(SpellParadigmSelf var1);

    public void modifyMeleeParadigm(SpellParadigmMelee parad) {
        switch (this.modifierState) {
            case 0: {
                this.defaultModificationMelee(parad);
                break;
            }
            case 1: {
                this.offensiveModificationMelee(parad);
                break;
            }
            case 2: {
                this.defensiveModificationMelee(parad);
                break;
            }
            case 3: {
                this.environmentalModificationMelee(parad);
            }
        }
    }

    public abstract void defaultModificationMelee(SpellParadigmMelee var1);

    public abstract void offensiveModificationMelee(SpellParadigmMelee var1);

    public abstract void defensiveModificationMelee(SpellParadigmMelee var1);

    public abstract void environmentalModificationMelee(SpellParadigmMelee var1);

    public void modifyToolParadigm(SpellParadigmTool parad) {
        switch (this.modifierState) {
            case 0: {
                this.defaultModificationTool(parad);
                break;
            }
            case 1: {
                this.offensiveModificationTool(parad);
                break;
            }
            case 2: {
                this.defensiveModificationTool(parad);
                break;
            }
            case 3: {
                this.environmentalModificationTool(parad);
            }
        }
    }

    public abstract void defaultModificationTool(SpellParadigmTool var1);

    public abstract void offensiveModificationTool(SpellParadigmTool var1);

    public abstract void defensiveModificationTool(SpellParadigmTool var1);

    public abstract void environmentalModificationTool(SpellParadigmTool var1);

    public int getCostForProjectile() {
        switch (this.modifierState) {
            case 0: {
                return this.getCostForDefaultProjectile();
            }
            case 1: {
                return this.getCostForOffenseProjectile();
            }
            case 2: {
                return this.getCostForDefenseProjectile();
            }
            case 3: {
                return this.getCostForEnvironmentProjectile();
            }
        }
        return 0;
    }

    protected abstract int getCostForDefaultProjectile();

    protected abstract int getCostForOffenseProjectile();

    protected abstract int getCostForDefenseProjectile();

    protected abstract int getCostForEnvironmentProjectile();

    public int getCostForSelf() {
        switch (this.modifierState) {
            case 0: {
                return this.getCostForDefaultSelf();
            }
            case 1: {
                return this.getCostForOffenseSelf();
            }
            case 2: {
                return this.getCostForDefenseSelf();
            }
            case 3: {
                return this.getCostForEnvironmentSelf();
            }
        }
        return 0;
    }

    protected abstract int getCostForDefaultSelf();

    protected abstract int getCostForOffenseSelf();

    protected abstract int getCostForDefenseSelf();

    protected abstract int getCostForEnvironmentSelf();

    public int getCostForMelee() {
        switch (this.modifierState) {
            case 0: {
                return this.getCostForDefaultMelee();
            }
            case 1: {
                return this.getCostForOffenseMelee();
            }
            case 2: {
                return this.getCostForDefenseMelee();
            }
            case 3: {
                return this.getCostForEnvironmentMelee();
            }
        }
        return 0;
    }

    protected abstract int getCostForDefaultMelee();

    protected abstract int getCostForOffenseMelee();

    protected abstract int getCostForDefenseMelee();

    protected abstract int getCostForEnvironmentMelee();

    public int getCostForTool() {
        switch (this.modifierState) {
            case 0: {
                return this.getCostForDefaultTool();
            }
            case 1: {
                return this.getCostForOffenseTool();
            }
            case 2: {
                return this.getCostForDefenseTool();
            }
            case 3: {
                return this.getCostForEnvironmentTool();
            }
        }
        return 0;
    }

    protected abstract int getCostForDefaultTool();

    protected abstract int getCostForOffenseTool();

    protected abstract int getCostForDefenseTool();

    protected abstract int getCostForEnvironmentTool();

    public int getPowerEnhancements() {
        return this.powerEnhancement;
    }

    public int getCostEnhancements() {
        return this.costEnhancement;
    }

    public int getPotencyEnhancements() {
        return this.potencyEnhancement;
    }

    public NBTTagCompound getTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Class", this.getClass().getName());
        tag.func_74768_a("modifier", this.modifierState);
        tag.func_74768_a("power", this.powerEnhancement);
        tag.func_74768_a("cost", this.costEnhancement);
        tag.func_74768_a("potency", this.potencyEnhancement);
        return tag;
    }

    public static SpellEffect getEffectFromTag(NBTTagCompound tag) {
        block6: {
            try {
                Class<?> clazz = Class.forName(tag.func_74779_i("Class"));
                if (clazz == null) break block6;
                try {
                    Object obj = clazz.newInstance();
                    if (obj instanceof SpellEffect) {
                        SpellEffect eff = (SpellEffect)obj;
                        eff.modifierState = tag.func_74762_e("modifier");
                        eff.powerEnhancement = tag.func_74762_e("power");
                        eff.costEnhancement = tag.func_74762_e("cost");
                        eff.potencyEnhancement = tag.func_74762_e("potency");
                        return eff;
                    }
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

