/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;

public class RitualEffectFullStomach
extends RitualEffect {
    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (world.func_72820_D() % 20L != 0L) {
            return;
        }
        double horizRange = 16.0;
        double vertRange = 16.0;
        List<EntityPlayer> playerList = SpellHelper.getPlayersInRange(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, horizRange, vertRange);
        if (playerList == null) {
            return;
        }
        if (currentEssence < this.getCostPerRefresh() * playerList.size()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            TileEntity tile = world.func_147438_o(x, y + 1, z);
            IInventory inventory = null;
            if (tile instanceof IInventory) {
                inventory = (IInventory)tile;
            } else {
                tile = world.func_147438_o(x, y - 1, z);
                if (tile instanceof IInventory) {
                    inventory = (IInventory)tile;
                }
            }
            int count = 0;
            if (inventory != null) {
                block0: for (EntityPlayer player : playerList) {
                    FoodStats foodStats = player.func_71024_bL();
                    float satLevel = foodStats.func_75115_e();
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack stack = inventory.func_70301_a(i);
                        if (stack == null || !(stack.func_77973_b() instanceof ItemFood)) continue;
                        ItemFood foodItem = (ItemFood)stack.func_77973_b();
                        int regularHeal = foodItem.func_150905_g(stack);
                        float saturatedHeal = foodItem.func_150906_h(stack) * (float)regularHeal * 2.0f;
                        if (!(saturatedHeal + satLevel <= 20.0f)) continue;
                        NBTTagCompound nbt = new NBTTagCompound();
                        foodStats.func_75117_b(nbt);
                        nbt.func_74776_a("foodSaturationLevel", saturatedHeal + satLevel);
                        foodStats.func_75112_a(nbt);
                        inventory.func_70298_a(i, 1);
                        ++count;
                        continue block0;
                    }
                }
            }
            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh() * count);
        }
    }

    @Override
    public int getCostPerRefresh() {
        return 100;
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> fullRitual = new ArrayList<RitualComponent>();
        fullRitual.add(new RitualComponent(0, 0, 3, 2));
        fullRitual.add(new RitualComponent(0, 0, -3, 2));
        fullRitual.add(new RitualComponent(3, 0, 0, 2));
        fullRitual.add(new RitualComponent(-3, 0, 0, 2));
        fullRitual.add(new RitualComponent(1, 0, 1, 4));
        fullRitual.add(new RitualComponent(1, 0, -1, 4));
        fullRitual.add(new RitualComponent(-1, 0, -1, 4));
        fullRitual.add(new RitualComponent(-1, 0, 1, 4));
        fullRitual.add(new RitualComponent(2, 0, 1, 4));
        fullRitual.add(new RitualComponent(2, 0, -1, 4));
        fullRitual.add(new RitualComponent(-2, 0, -1, 4));
        fullRitual.add(new RitualComponent(-2, 0, 1, 4));
        fullRitual.add(new RitualComponent(1, 0, 2, 4));
        fullRitual.add(new RitualComponent(1, 0, -2, 4));
        fullRitual.add(new RitualComponent(-1, 0, -2, 4));
        fullRitual.add(new RitualComponent(-1, 0, 2, 4));
        fullRitual.add(new RitualComponent(4, 0, 4, 1));
        fullRitual.add(new RitualComponent(4, 0, -4, 1));
        fullRitual.add(new RitualComponent(-4, 0, -4, 1));
        fullRitual.add(new RitualComponent(-4, 0, 4, 1));
        fullRitual.add(new RitualComponent(4, 0, 3, 3));
        fullRitual.add(new RitualComponent(3, 0, 4, 3));
        fullRitual.add(new RitualComponent(-4, 0, 3, 3));
        fullRitual.add(new RitualComponent(3, 0, -4, 3));
        fullRitual.add(new RitualComponent(-4, 0, -3, 3));
        fullRitual.add(new RitualComponent(-3, 0, -4, 3));
        fullRitual.add(new RitualComponent(4, 0, -3, 3));
        fullRitual.add(new RitualComponent(-3, 0, 4, 3));
        return fullRitual;
    }
}

