/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.rituals.IRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemRitualDiviner
extends EnergyItems {
    private int maxMetaData;

    public ItemRitualDiviner() {
        this.field_77777_bU = 1;
        this.setEnergyUsed(100);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.maxMetaData = 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:RitualDiviner");
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        boolean sneaking;
        par3List.add("Used to explore new types of rituals");
        if (this.getMaxRuneDisplacement(par1ItemStack) == 1) {
            par3List.add("Can place Dusk runes");
        } else {
            par3List.add("Can not place Dusk runes");
        }
        par3List.add("Ritual tuned to face: " + this.getNameForDirection(this.getDirection(par1ItemStack)));
        boolean bl = sneaking = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
        if (sneaking) {
            if (par1ItemStack.func_77978_p() != null) {
                String ritualID = this.getCurrentRitual(par1ItemStack);
                par3List.add("Current owner: " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
                par3List.add("RitualID: " + ritualID);
                List<RitualComponent> ritualList = Rituals.getRitualList(this.getCurrentRitual(par1ItemStack));
                if (ritualList == null) {
                    return;
                }
                int blankStones = 0;
                int airStones = 0;
                int waterStones = 0;
                int fireStones = 0;
                int earthStones = 0;
                int duskStones = 0;
                for (RitualComponent rc : ritualList) {
                    switch (rc.getStoneType()) {
                        case 0: {
                            ++blankStones;
                            break;
                        }
                        case 4: {
                            ++airStones;
                            break;
                        }
                        case 1: {
                            ++waterStones;
                            break;
                        }
                        case 2: {
                            ++fireStones;
                            break;
                        }
                        case 3: {
                            ++earthStones;
                            break;
                        }
                        case 5: {
                            ++duskStones;
                        }
                    }
                }
                par3List.add("Blank stones: " + blankStones);
                par3List.add(EnumChatFormatting.AQUA + "Air stones: " + airStones);
                par3List.add(EnumChatFormatting.BLUE + "Water stones: " + waterStones);
                par3List.add(EnumChatFormatting.RED + "Fire stones: " + fireStones);
                par3List.add(EnumChatFormatting.DARK_GREEN + "Earth stones: " + earthStones);
                par3List.add(EnumChatFormatting.BOLD + "Dusk stones: " + duskStones);
            }
        } else {
            par3List.add(EnumChatFormatting.AQUA + "-Press shift for extended information-");
        }
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77978_p() != null) {
            String ritualID = this.getCurrentRitual(par1ItemStack);
            if (ritualID.equals("")) {
                return super.func_77653_i(par1ItemStack);
            }
            return "Ritual: " + Rituals.getNameOfRitual(ritualID);
        }
        return super.func_77653_i(par1ItemStack);
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        int direction = this.getDirection(par1ItemStack);
        EnergyItems.checkAndSetItemOwner(par1ItemStack, par2EntityPlayer);
        ItemStack[] playerInventory = par2EntityPlayer.field_71071_by.field_70462_a;
        TileEntity tileEntity = par3World.func_147438_o(par4, par5, par6);
        if (tileEntity instanceof TEMasterStone) {
            TEMasterStone masterStone = (TEMasterStone)tileEntity;
            List<RitualComponent> ritualList = Rituals.getRitualList(this.getCurrentRitual(par1ItemStack));
            if (ritualList == null) {
                return false;
            }
            int playerInvRitualStoneLocation = -1;
            for (int i = 0; i < playerInventory.length; ++i) {
                if (playerInventory[i] == null || !new ItemStack(ModBlocks.ritualStone).func_77969_a(playerInventory[i])) continue;
                playerInvRitualStoneLocation = i;
                break;
            }
            for (RitualComponent rc : ritualList) {
                if (par3World.func_147437_c(par4 + rc.getX(direction), par5 + rc.getY(), par6 + rc.getZ(direction))) {
                    if (playerInvRitualStoneLocation < 0) continue;
                    if (rc.getStoneType() > this.maxMetaData + this.getMaxRuneDisplacement(par1ItemStack)) {
                        par3World.func_72926_e(200, par4, par5 + 1, par6, 0);
                        return true;
                    }
                    if (!par2EntityPlayer.field_71075_bZ.field_75098_d) {
                        par2EntityPlayer.field_71071_by.func_70298_a(playerInvRitualStoneLocation, 1);
                    }
                    if (EnergyItems.syphonBatteries(par1ItemStack, par2EntityPlayer, this.getEnergyUsed())) {
                        par3World.func_147465_d(par4 + rc.getX(direction), par5 + rc.getY(), par6 + rc.getZ(direction), ModBlocks.ritualStone, rc.getStoneType(), 3);
                        if (par3World.field_72995_K) {
                            par3World.func_72926_e(2005, par4, par5 + 1, par6, 0);
                            return true;
                        }
                    }
                    return true;
                }
                Block block = par3World.func_147439_a(par4 + rc.getX(direction), par5 + rc.getY(), par6 + rc.getZ(direction));
                if (block == ModBlocks.ritualStone) {
                    int metadata = par3World.func_72805_g(par4 + rc.getX(direction), par5 + rc.getY(), par6 + rc.getZ(direction));
                    if (metadata == rc.getStoneType() || !EnergyItems.syphonBatteries(par1ItemStack, par2EntityPlayer, this.getEnergyUsed())) continue;
                    if (rc.getStoneType() > this.maxMetaData + this.getMaxRuneDisplacement(par1ItemStack)) {
                        par3World.func_72926_e(200, par4, par5 + 1, par6, 0);
                        return true;
                    }
                    par3World.func_72921_c(par4 + rc.getX(direction), par5 + rc.getY(), par6 + rc.getZ(direction), rc.getStoneType(), 3);
                    return true;
                }
                par3World.func_72926_e(0, par4, par5 + 1, par6, 0);
                return true;
            }
        } else if (!(par3World.func_147439_a(par4, par5, par6) instanceof IRitualStone)) {
            if (par3World.field_72995_K) {
                return false;
            }
            this.cycleDirection(par1ItemStack);
            par2EntityPlayer.func_146105_b((IChatComponent)new ChatComponentText("Ritual tuned to face: " + this.getNameForDirection(this.getDirection(par1ItemStack))));
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer);
        if (par3EntityPlayer.func_70093_af()) {
            int maxRitualID = Rituals.getNumberOfRituals();
            String currentRitualID = this.getCurrentRitual(par1ItemStack);
            this.setCurrentRitual(par1ItemStack, Rituals.getNextRitualKey(currentRitualID));
            if (par2World.field_72995_K) {
                ChatComponentText chatmessagecomponent = new ChatComponentText("Current Ritual: " + Rituals.getNameOfRitual(this.getCurrentRitual(par1ItemStack)));
                par3EntityPlayer.func_146105_b((IChatComponent)chatmessagecomponent);
            }
        }
        return par1ItemStack;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        EntityPlayer player;
        if (entityLiving instanceof EntityPlayer && (player = (EntityPlayer)entityLiving).func_70093_af() && !player.field_82175_bq) {
            int maxRitualID = Rituals.getNumberOfRituals();
            String currentRitualID = this.getCurrentRitual(stack);
            this.setCurrentRitual(stack, Rituals.getPreviousRitualKey(currentRitualID));
            if (entityLiving.field_70170_p.field_72995_K) {
                ChatComponentText chatmessagecomponent = new ChatComponentText("Current Ritual: " + Rituals.getNameOfRitual(this.getCurrentRitual(stack)));
                player.func_146105_b((IChatComponent)chatmessagecomponent);
            }
        }
        return false;
    }

    public String getCurrentRitual(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        return par1ItemStack.func_77978_p().func_74779_i("ritualID");
    }

    public void setCurrentRitual(ItemStack par1ItemStack, String ritualID) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.func_77978_p().func_74778_a("ritualID", ritualID);
    }

    public int getMaxRuneDisplacement(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        return par1ItemStack.func_77978_p().func_74762_e("maxRuneDisplacement");
    }

    public void setMaxRuneDisplacement(ItemStack par1ItemStack, int displacement) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.func_77978_p().func_74768_a("maxRuneDisplacement", displacement);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, List list) {
        list.add(new ItemStack(ModItems.itemRitualDiviner));
        ItemStack duskRitualDivinerStack = new ItemStack(ModItems.itemRitualDiviner);
        ((ItemRitualDiviner)duskRitualDivinerStack.func_77973_b()).setMaxRuneDisplacement(duskRitualDivinerStack, 1);
        list.add(duskRitualDivinerStack);
    }

    public int getDirection(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p().func_74762_e("direction");
    }

    public void setDirection(ItemStack itemStack, int direction) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("direction", direction);
    }

    public int cycleDirection(ItemStack itemStack) {
        int direction = this.getDirection(itemStack);
        direction = direction < 4 ? Math.max(1, direction + 1) : 1;
        this.setDirection(itemStack, direction);
        return direction;
    }

    public String getNameForDirection(int direction) {
        String dir = "";
        switch (direction) {
            case 0: 
            case 1: {
                dir = "NORTH";
                break;
            }
            case 2: {
                dir = "EAST";
                break;
            }
            case 3: {
                dir = "SOUTH";
                break;
            }
            case 4: {
                dir = "WEST";
            }
        }
        return dir;
    }
}

