/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.harvest;

import WayofTime.alchemicalWizardry.api.harvest.IHarvestHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BloodMagicHarvestHandler
implements IHarvestHandler {
    public boolean canHandleBlock(Block block) {
        return block == Blocks.field_150464_aj || block == Blocks.field_150459_bM || block == Blocks.field_150469_bN || block == Blocks.field_150388_bm;
    }

    public int getHarvestMeta(Block block) {
        if (block == Blocks.field_150464_aj) {
            return 7;
        }
        if (block == Blocks.field_150459_bM) {
            return 7;
        }
        if (block == Blocks.field_150469_bN) {
            return 7;
        }
        if (block == Blocks.field_150388_bm) {
            return 3;
        }
        return 7;
    }

    @Override
    public boolean harvestAndPlant(World world, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        if (!this.canHandleBlock(block) || meta != this.getHarvestMeta(block)) {
            return false;
        }
        IPlantable seed = this.getSeedItem(block);
        if (seed == null) {
            return false;
        }
        int fortune = 0;
        ArrayList list = block.getDrops(world, xCoord, yCoord, zCoord, meta, fortune);
        boolean foundAndRemovedSeed = false;
        for (ItemStack stack : list) {
            int itemSize;
            Item item;
            if (stack == null || (item = stack.func_77973_b()) != seed) continue;
            if ((itemSize = stack.field_77994_a--) > 1) {
                foundAndRemovedSeed = true;
                break;
            }
            if (itemSize != 1) continue;
            list.remove(stack);
            foundAndRemovedSeed = true;
            break;
        }
        if (foundAndRemovedSeed) {
            int plantMeta = seed.getPlantMetadata((IBlockAccess)world, xCoord, yCoord, zCoord);
            Block plantBlock = seed.getPlant((IBlockAccess)world, xCoord, yCoord, zCoord);
            world.func_147480_a(xCoord, yCoord, zCoord, false);
            world.func_147465_d(xCoord, yCoord, zCoord, plantBlock, plantMeta, 3);
            for (ItemStack stack : list) {
                EntityItem itemEnt = new EntityItem(world, (double)xCoord, (double)yCoord, (double)zCoord, stack);
                world.func_72838_d((Entity)itemEnt);
            }
        }
        return false;
    }

    public IPlantable getSeedItem(Block block) {
        if (block == Blocks.field_150464_aj) {
            return (IPlantable)Items.field_151014_N;
        }
        if (block == Blocks.field_150459_bM) {
            return (IPlantable)Items.field_151172_bF;
        }
        if (block == Blocks.field_150469_bN) {
            return (IPlantable)Items.field_151174_bG;
        }
        if (block == Blocks.field_150388_bm) {
            return (IPlantable)Items.field_151075_bm;
        }
        return null;
    }
}

