/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.demonVillage.tileEntity;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.Int3;
import WayofTime.alchemicalWizardry.common.block.BlockTeleposer;
import WayofTime.alchemicalWizardry.common.demonVillage.BuildingSchematic;
import WayofTime.alchemicalWizardry.common.demonVillage.DemonBuilding;
import WayofTime.alchemicalWizardry.common.demonVillage.DemonCrosspath;
import WayofTime.alchemicalWizardry.common.demonVillage.DemonVillagePath;
import WayofTime.alchemicalWizardry.common.demonVillage.GridSpace;
import WayofTime.alchemicalWizardry.common.demonVillage.GridSpaceHolder;
import WayofTime.alchemicalWizardry.common.demonVillage.demonHoard.DemonPacketRegistry;
import WayofTime.alchemicalWizardry.common.demonVillage.demonHoard.DemonType;
import WayofTime.alchemicalWizardry.common.demonVillage.demonHoard.demon.IHoardDemon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TEDemonPortal
extends TileEntity {
    public DemonType type = DemonType.FIRE;
    public static boolean printDebug = false;
    public static int limit = 100;
    public static int demonLimit = 100;
    public static int buildingGridDelay = 25;
    public static int roadGridDelay = 10;
    public static int demonHoardDelay = 40;
    public static float demonRoadChance = 0.3f;
    public static float demonHouseChance = 0.6f;
    public static float demonPortalChance = 0.5f;
    public static float demonHoardChance = 0.8f;
    public static float portalTickRate = 1.0f;
    public static int[] tierCostList = new int[]{1500};
    public static Set<IHoardDemon> hoardList = new HashSet<IHoardDemon>();
    public static List<DemonBuilding> buildingList = new ArrayList<DemonBuilding>();
    public Random rand = new Random();
    private GridSpace[][] area;
    private int negXRadius = 1;
    private int posXRadius = 1;
    private int negZRadius = 1;
    private int posZRadius = 1;
    private boolean isInitialized;
    public int houseCooldown;
    public int roadCooldown;
    public int tier;
    public int demonHouseCooldown;
    public int demonHoardCooldown;
    public float pointPool;
    public String nextDemonPortalName = "";
    public ForgeDirection nextDemonPortalDirection = ForgeDirection.DOWN;
    public int buildingStage = -1;
    public int delayBeforeParty = 0;
    public int lockdownTimer;

    public TEDemonPortal() {
        this.area = new GridSpace[this.negXRadius + this.posXRadius + 1][this.negZRadius + this.posZRadius + 1];
        for (int xIndex = -this.negXRadius; xIndex <= this.posXRadius; ++xIndex) {
            for (int zIndex = -this.negZRadius; zIndex <= this.posZRadius; ++zIndex) {
                if (Math.abs(xIndex) == 1 || Math.abs(zIndex) == 1) {
                    this.setGridSpace(xIndex, zIndex, new GridSpace(3, 4));
                    continue;
                }
                this.setGridSpace(xIndex, zIndex, new GridSpace());
            }
        }
        this.isInitialized = false;
        this.setGridSpace(0, 0, new GridSpace(1, this.field_145848_d));
        this.houseCooldown = 0;
        this.roadCooldown = 0;
        this.tier = 0;
        this.lockdownTimer = 0;
    }

    public boolean isLockedDown() {
        return this.lockdownTimer > 0;
    }

    public float getRoadChance() {
        if (this.isLockedDown()) {
            return 0.0f;
        }
        return demonRoadChance;
    }

    public float getHouseChance() {
        if (this.isLockedDown()) {
            return 0.0f;
        }
        return demonHouseChance;
    }

    public float getDemonPortalChance() {
        if (this.isLockedDown()) {
            return 0.0f;
        }
        return demonPortalChance;
    }

    public float getDemonHoardChance() {
        return demonHoardChance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decreaseRandomCooldown(int amount) {
        float totalChance = 0.0f;
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("roadChance", Float.valueOf(this.getRoadChance()));
        map.put("houseChance", Float.valueOf(this.getHouseChance()));
        map.put("demonPortalChance", Float.valueOf(this.getDemonPortalChance()));
        map.put("demonHoardChance", Float.valueOf(this.getDemonHoardChance()));
        String action = "";
        for (Map.Entry entry : map.entrySet()) {
            totalChance += ((Float)entry.getValue()).floatValue();
        }
        float pointer = this.rand.nextFloat() * totalChance;
        for (Map.Entry entry : map.entrySet()) {
            float value = ((Float)entry.getValue()).floatValue();
            if (pointer <= value) {
                action = (String)entry.getKey();
                break;
            }
            pointer -= value;
        }
        if (action.equals("roadChance")) {
            if (this.roadCooldown <= 0) return false;
            this.roadCooldown -= amount;
            return true;
        } else if (action.equals("houseChance")) {
            if (this.houseCooldown <= 0) return false;
            this.houseCooldown -= amount;
            return true;
        } else if (action.equals("demonPortalChance")) {
            this.demonHouseCooldown += amount;
            return true;
        } else {
            if (!action.equals("demonHoardChance")) return true;
            if (this.demonHoardCooldown <= 0) return false;
            this.demonHoardCooldown -= amount;
        }
        return true;
    }

    public void notifyDemons(EntityLivingBase demon, EntityLivingBase target, double radius) {
        this.lockdownTimer = 1000;
        for (IHoardDemon thrallDemon : hoardList) {
            if (!(thrallDemon instanceof EntityCreature) || thrallDemon == demon || ((EntityCreature)thrallDemon).func_70638_az() != null || ((EntityCreature)thrallDemon).func_142014_c(target)) continue;
            double xi = ((EntityCreature)thrallDemon).field_70165_t;
            double xf = demon.field_70165_t;
            double yi = ((EntityCreature)thrallDemon).field_70163_u;
            double yf = demon.field_70163_u;
            double zi = ((EntityCreature)thrallDemon).field_70161_v;
            double zf = demon.field_70161_v;
            if ((xi - xf) * (xi - xf) + (yi - yf) * (yi - yf) + (zi - zf) * (zi - zf) <= radius * radius) {
                ((EntityCreature)thrallDemon).func_70624_b(target);
                continue;
            }
            ((EntityCreature)thrallDemon).func_70661_as().func_75497_a((Entity)target, 2.0);
        }
    }

    public void notifyDemons(int xf, int yf, int zf, double radius) {
        for (IHoardDemon thrallDemon : hoardList) {
            double zi;
            double yi;
            double xi;
            if (!(thrallDemon instanceof EntityCreature) || ((EntityCreature)thrallDemon).func_70638_az() != null || !(((xi = ((EntityCreature)thrallDemon).field_70165_t) - (double)xf) * (xi - (double)xf) + ((yi = ((EntityCreature)thrallDemon).field_70163_u) - (double)yf) * (yi - (double)yf) + ((zi = ((EntityCreature)thrallDemon).field_70161_v) - (double)zf) * (zi - (double)zf) <= radius * radius)) continue;
            ((EntityCreature)thrallDemon).func_70661_as().func_75492_a((double)xf, (double)yf, (double)zf, 1.0);
        }
    }

    public void enthrallDemon(EntityLivingBase demon) {
        boolean enthrall;
        if (demon instanceof IHoardDemon && (enthrall = ((IHoardDemon)demon).thrallDemon(new Int3(this.field_145851_c, this.field_145848_d, this.field_145849_e)))) {
            hoardList.add((IHoardDemon)demon);
        }
    }

    public void initialize() {
        if (this.isInitialized) {
            return;
        }
        DemonType[] types = DemonType.values();
        this.type = types[this.rand.nextInt(types.length)];
        for (int xIndex = -this.negXRadius; xIndex <= this.posXRadius; ++xIndex) {
            for (int zIndex = -this.negZRadius; zIndex <= this.posZRadius; ++zIndex) {
                if (Math.abs(xIndex) == 1 || Math.abs(zIndex) == 1) {
                    this.setGridSpace(xIndex, zIndex, new GridSpace(3, this.field_145848_d));
                    continue;
                }
                if (xIndex == 0 && zIndex == 0) {
                    this.setGridSpace(0, 0, new GridSpace(1, this.field_145848_d));
                    continue;
                }
                this.setGridSpace(xIndex, zIndex, new GridSpace());
            }
        }
        this.houseCooldown = buildingGridDelay;
        this.roadCooldown = roadGridDelay;
        this.demonHoardCooldown = demonHoardDelay;
        this.createRandomRoad();
        if (this.createRandomBuilding(1, this.tier) >= 1) {
            System.out.println("Portal building successfully found!");
            this.buildingStage = 0;
        }
        this.isInitialized = true;
    }

    public void createParty() {
        this.field_145850_b.func_72876_a(null, (double)(this.field_145851_c + this.rand.nextInt(10) - this.rand.nextInt(10)), (double)this.field_145848_d, (double)(this.field_145849_e + this.rand.nextInt(10) - this.rand.nextInt(10)), 5.0f * this.rand.nextFloat(), false);
    }

    public void start() {
        this.delayBeforeParty = 200;
    }

    public void func_145845_h() {
        int gridsUsed;
        int roadsMade;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.delayBeforeParty > 0) {
            --this.delayBeforeParty;
            if (this.rand.nextInt(20) == 0) {
                this.createParty();
            }
            if (this.delayBeforeParty <= 0) {
                this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 15.0f, false);
                this.initialize();
            }
            return;
        }
        if (!this.isInitialized) {
            return;
        }
        this.lockdownTimer = Math.max(0, this.lockdownTimer - 1);
        this.incrementPoints();
        this.assignPoints();
        if (printDebug) {
            AlchemicalWizardry.logger.info("Roads: " + this.roadCooldown + " Buildings: " + this.houseCooldown + " Lockdown: " + this.lockdownTimer);
        }
        if (this.buildingStage >= 0 && this.buildingStage <= 2) {
            if (printDebug) {
                AlchemicalWizardry.logger.info("BuildingStage = " + this.buildingStage);
            }
            if (printDebug) {
                AlchemicalWizardry.logger.info("Tier = " + this.tier);
            }
            this.createPortalBuilding(this.buildingStage, this.nextDemonPortalName, this.tier);
            ++this.buildingStage;
            return;
        }
        if (this.roadCooldown <= 0 && (roadsMade = this.createRandomRoad()) > 0) {
            this.roadCooldown = roadGridDelay * roadsMade;
        }
        if (this.houseCooldown <= 0 && (gridsUsed = this.createRandomBuilding(0, this.tier)) > 0) {
            this.houseCooldown = buildingGridDelay * gridsUsed;
        }
        if (this.demonHoardCooldown <= 0) {
            int complexityCost;
            if (hoardList.size() <= demonLimit && (complexityCost = this.createRandomDemonHoard(this, this.tier, this.type, this.isLockedDown())) > 0) {
                this.demonHoardCooldown += demonHoardDelay * complexityCost;
            }
        }
        if (this.tier < tierCostList.length) {
            if (this.demonHouseCooldown > tierCostList[this.tier]) {
                ++this.tier;
                if (this.createRandomBuilding(1, this.tier) >= 1) {
                    this.buildingStage = 0;
                }
            }
        }
    }

    public void assignPoints() {
        if ((int)this.pointPool > 0 && this.decreaseRandomCooldown((int)this.pointPool)) {
            this.pointPool -= (float)((int)this.pointPool);
        }
    }

    public void incrementPoints() {
        this.pointPool += portalTickRate;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.negXRadius = par1NBTTagCompound.func_74762_e("negXRadius");
        this.negZRadius = par1NBTTagCompound.func_74762_e("negZRadius");
        this.posXRadius = par1NBTTagCompound.func_74762_e("posXRadius");
        this.posZRadius = par1NBTTagCompound.func_74762_e("posZRadius");
        this.houseCooldown = par1NBTTagCompound.func_74762_e("houseCooldown");
        this.roadCooldown = par1NBTTagCompound.func_74762_e("roadCooldown");
        this.demonHoardCooldown = par1NBTTagCompound.func_74762_e("demonHoardCooldown");
        this.area = new GridSpace[this.negXRadius + this.posXRadius + 1][this.negZRadius + this.posZRadius + 1];
        NBTTagList tagList = par1NBTTagCompound.func_150295_c("Grid", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            GridSpace space;
            int length = this.negZRadius + this.posZRadius + 1;
            int x = i / length;
            int z = i % length;
            NBTTagCompound tag = tagList.func_150305_b(i);
            this.area[x][z] = space = GridSpace.getGridFromTag(tag);
        }
        this.isInitialized = par1NBTTagCompound.func_74767_n("init");
        this.tier = par1NBTTagCompound.func_74762_e("tier");
        this.demonHouseCooldown = par1NBTTagCompound.func_74762_e("demonHouseCooldown");
        this.nextDemonPortalName = par1NBTTagCompound.func_74779_i("nextDemonPortalName");
        this.buildingStage = par1NBTTagCompound.func_74762_e("buildingStage");
        this.nextDemonPortalDirection = ForgeDirection.getOrientation((int)par1NBTTagCompound.func_74762_e("nextDemonPortalDirection"));
        this.pointPool = par1NBTTagCompound.func_74760_g("pointPool");
        this.lockdownTimer = par1NBTTagCompound.func_74762_e("lockdownTimer");
        this.delayBeforeParty = par1NBTTagCompound.func_74762_e("delayBeforeParty");
        this.type = DemonType.valueOf(par1NBTTagCompound.func_74779_i("demonType"));
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("negXRadius", this.negXRadius);
        par1NBTTagCompound.func_74768_a("negZRadius", this.negZRadius);
        par1NBTTagCompound.func_74768_a("posXRadius", this.posXRadius);
        par1NBTTagCompound.func_74768_a("posZRadius", this.posZRadius);
        par1NBTTagCompound.func_74768_a("houseCooldown", this.houseCooldown);
        par1NBTTagCompound.func_74768_a("roadCooldown", this.roadCooldown);
        par1NBTTagCompound.func_74768_a("demonHoardCooldown", this.demonHoardCooldown);
        NBTTagList gridList = new NBTTagList();
        for (int i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                int index = i + (this.negZRadius + this.posZRadius + 1) * j;
                GridSpace space = this.area[i][j];
                NBTTagCompound nextTag = space == null ? new GridSpace().getTag() : space.getTag();
                gridList.func_74742_a((NBTBase)nextTag);
            }
        }
        par1NBTTagCompound.func_74782_a("Grid", (NBTBase)gridList);
        par1NBTTagCompound.func_74757_a("init", this.isInitialized);
        par1NBTTagCompound.func_74768_a("tier", this.tier);
        par1NBTTagCompound.func_74768_a("demonHouseCooldown", this.demonHouseCooldown);
        par1NBTTagCompound.func_74778_a("nextDemonPortalName", this.nextDemonPortalName);
        par1NBTTagCompound.func_74768_a("buildingStage", this.buildingStage);
        par1NBTTagCompound.func_74768_a("nextDemonPortalDirection", this.nextDemonPortalDirection.ordinal());
        par1NBTTagCompound.func_74776_a("pointPool", this.pointPool);
        par1NBTTagCompound.func_74768_a("lockdownTimer", this.lockdownTimer);
        par1NBTTagCompound.func_74768_a("delayBeforeParty", this.delayBeforeParty);
        par1NBTTagCompound.func_74778_a("demonType", this.type.toString());
    }

    public int createRandomDemonHoard(TEDemonPortal teDemonPortal, int tier, DemonType type, boolean spawnGuardian) {
        ForgeDirection dir;
        int next = this.rand.nextInt(4);
        switch (next) {
            case 0: {
                dir = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                dir = ForgeDirection.SOUTH;
                break;
            }
            case 2: {
                dir = ForgeDirection.EAST;
                break;
            }
            case 3: {
                dir = ForgeDirection.WEST;
                break;
            }
            default: {
                dir = ForgeDirection.NORTH;
            }
        }
        Int3 road = this.findRoadSpaceFromDirection(dir, this.rand.nextInt(this.negXRadius + this.negZRadius + this.posXRadius + this.posZRadius) + 1);
        if (road == null) {
            return 0;
        }
        if (printDebug) {
            System.out.println("Spawning Demons");
        }
        return DemonPacketRegistry.spawnDemons(teDemonPortal, this.field_145850_b, this.field_145851_c + road.xCoord * 5, road.yCoord + 1, this.field_145849_e + road.zCoord * 5, type, tier, spawnGuardian);
    }

    public int createRandomRoad() {
        List<ForgeDirection> directions;
        ForgeDirection dir;
        int next = this.rand.nextInt(4);
        switch (next) {
            case 0: {
                dir = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                dir = ForgeDirection.SOUTH;
                break;
            }
            case 2: {
                dir = ForgeDirection.EAST;
                break;
            }
            case 3: {
                dir = ForgeDirection.WEST;
                break;
            }
            default: {
                dir = ForgeDirection.NORTH;
            }
        }
        int length = 5;
        Int3 road = this.findRoadSpaceFromDirection(dir, this.rand.nextInt(this.negXRadius + this.negZRadius + this.posXRadius + this.posZRadius) + 1);
        int x = road.xCoord;
        int yLevel = road.yCoord;
        int z = road.zCoord;
        if (printDebug) {
            AlchemicalWizardry.logger.info("X: " + x + " Z: " + z + " Direction: " + dir.toString());
        }
        if ((directions = this.findValidExtentionDirection(x, z)).size() <= 0) {
            return 0;
        }
        int maxDistance = 5;
        int distance = 0;
        ForgeDirection dominantDirection = null;
        for (ForgeDirection direction : directions) {
            int amt = this.getLength(direction, maxDistance, x, z);
            if (amt > distance) {
                distance = amt;
                dominantDirection = direction;
                continue;
            }
            if (amt != distance || !this.rand.nextBoolean()) continue;
            dominantDirection = direction;
        }
        if (dominantDirection == null) {
            return 0;
        }
        if (printDebug) {
            AlchemicalWizardry.logger.info("I got here!");
        }
        if (printDebug) {
            AlchemicalWizardry.logger.info("Distance: " + distance + " Direction: " + dominantDirection.toString() + " yLevel: " + yLevel);
        }
        this.createGriddedRoad(x, yLevel, z, dominantDirection, distance + 1, true);
        return distance;
    }

    public List<ForgeDirection> findValidExtentionDirection(int x, int z) {
        LinkedList<ForgeDirection> directions = new LinkedList<ForgeDirection>();
        if (this.getGridSpace(x, z) == null || !this.getGridSpace(x, z).isRoadSegment()) {
            return directions;
        }
        GridSpace nextGrid = this.getGridSpace(x + 1, z);
        if (nextGrid.isEmpty()) {
            directions.add(ForgeDirection.EAST);
        }
        if ((nextGrid = this.getGridSpace(x - 1, z)).isEmpty()) {
            directions.add(ForgeDirection.WEST);
        }
        if ((nextGrid = this.getGridSpace(x, z + 1)).isEmpty()) {
            directions.add(ForgeDirection.SOUTH);
        }
        if ((nextGrid = this.getGridSpace(x, z - 1)).isEmpty()) {
            directions.add(ForgeDirection.NORTH);
        }
        return directions;
    }

    public int getLength(ForgeDirection dir, int maxLength, int x, int z) {
        for (int i = 1; i <= maxLength; ++i) {
            GridSpace space = this.getGridSpace(x + i * dir.offsetX, z + i * dir.offsetZ);
            if (space.isEmpty()) {
                for (int k = 1; k <= this.getRoadSpacer(); ++k) {
                    GridSpace space1 = this.getGridSpace(x + i * dir.offsetX + dir.offsetZ * k, z + i * dir.offsetZ + dir.offsetX * k);
                    GridSpace space2 = this.getGridSpace(x + i * dir.offsetX - dir.offsetZ * k, z + i * dir.offsetZ - dir.offsetX * k);
                    if (!space1.isRoadSegment() && !space2.isRoadSegment()) continue;
                    return i - 1;
                }
                continue;
            }
            if (space.isRoadSegment()) {
                return i;
            }
            return i - 1;
        }
        return maxLength;
    }

    public Int3 findRoadSpaceFromDirection(ForgeDirection dir, int amount) {
        block10: {
            int index;
            block12: {
                block11: {
                    block9: {
                        index = 0;
                        if (dir != ForgeDirection.NORTH) break block9;
                        if (printDebug) {
                            System.out.print("NORTH!");
                        }
                        for (int i = Math.max(0, -limit + this.negZRadius); i <= this.negZRadius + Math.min(this.posZRadius, limit); ++i) {
                            for (int j = Math.max(0, -limit + this.negXRadius); j <= this.negXRadius + Math.min(this.posXRadius, limit); ++j) {
                                GridSpace space = this.area[j][i];
                                if (!space.isRoadSegment() || ++index < amount) continue;
                                return new Int3(j - this.negXRadius, space.getYLevel(), i - this.negZRadius);
                            }
                        }
                        break block10;
                    }
                    if (dir != ForgeDirection.SOUTH) break block11;
                    for (int i = this.negZRadius + Math.min(this.posZRadius, limit); i >= Math.max(0, -limit + this.negZRadius); --i) {
                        for (int j = Math.max(0, -limit + this.negXRadius); j <= this.negXRadius + Math.min(this.posXRadius, limit); ++j) {
                            GridSpace space = this.area[j][i];
                            if (!space.isRoadSegment() || ++index < amount) continue;
                            return new Int3(j - this.negXRadius, space.getYLevel(), i - this.negZRadius);
                        }
                    }
                    break block10;
                }
                if (dir != ForgeDirection.EAST) break block12;
                for (int i = this.negXRadius + Math.min(this.posXRadius, limit); i >= Math.max(0, -limit + this.negXRadius); --i) {
                    for (int j = Math.max(0, -limit + this.negZRadius); j <= this.negZRadius + Math.min(this.posZRadius, limit); ++j) {
                        GridSpace space = this.area[i][j];
                        if (!space.isRoadSegment() || ++index < amount) continue;
                        return new Int3(i - this.negXRadius, space.getYLevel(), j - this.negZRadius);
                    }
                }
                break block10;
            }
            if (dir != ForgeDirection.WEST) break block10;
            for (int i = Math.max(0, -limit + this.negXRadius); i <= this.negXRadius + Math.min(this.posXRadius, limit); ++i) {
                for (int j = Math.max(0, -limit + this.negZRadius); j <= this.negZRadius + Math.min(this.posZRadius, limit); ++j) {
                    GridSpace space = this.area[i][j];
                    if (!space.isRoadSegment() || ++index < amount) continue;
                    return new Int3(i - this.negXRadius, space.getYLevel(), j - this.negZRadius);
                }
            }
        }
        return new Int3(0, 0, 0);
    }

    public Int3 findEmptySpaceNearRoad(ForgeDirection dir, int amount, int closeness) {
        block10: {
            int index;
            block12: {
                block11: {
                    block9: {
                        index = 0;
                        if (dir != ForgeDirection.NORTH) break block9;
                        if (printDebug) {
                            System.out.print("NORTH!");
                        }
                        for (int i = 0; i <= this.negZRadius + this.posZRadius; ++i) {
                            for (int j = 0; j <= this.negXRadius + this.posXRadius; ++j) {
                                int yLevel;
                                GridSpace space = this.area[j][i];
                                if (!space.isEmpty() || (yLevel = this.findNearestRoadYLevel(j - this.negXRadius, i - this.negZRadius, closeness)) == -1 || ++index < amount) continue;
                                return new Int3(j - this.negXRadius, yLevel, i - this.negZRadius);
                            }
                        }
                        break block10;
                    }
                    if (dir != ForgeDirection.SOUTH) break block11;
                    for (int i = this.negZRadius + this.posZRadius; i >= 0; --i) {
                        for (int j = 0; j <= this.negXRadius + this.posXRadius; ++j) {
                            GridSpace space = this.area[j][i];
                            int yLevel = this.findNearestRoadYLevel(j - this.negXRadius, i - this.negZRadius, closeness);
                            if (yLevel == -1 || !space.isEmpty() || ++index < amount) continue;
                            return new Int3(j - this.negXRadius, yLevel, i - this.negZRadius);
                        }
                    }
                    break block10;
                }
                if (dir != ForgeDirection.EAST) break block12;
                for (int i = this.negXRadius + this.posXRadius; i >= 0; --i) {
                    for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                        GridSpace space = this.area[i][j];
                        int yLevel = this.findNearestRoadYLevel(i - this.negXRadius, j - this.negZRadius, closeness);
                        if (yLevel == -1 || !space.isEmpty() || ++index < amount) continue;
                        return new Int3(i - this.negXRadius, yLevel, j - this.negZRadius);
                    }
                }
                break block10;
            }
            if (dir != ForgeDirection.WEST) break block10;
            for (int i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
                for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                    GridSpace space = this.area[i][j];
                    int yLevel = this.findNearestRoadYLevel(i - this.negXRadius, j - this.negZRadius, closeness);
                    if (yLevel == -1 || !space.isEmpty() || ++index < amount) continue;
                    return new Int3(i - this.negXRadius, yLevel, j - this.negZRadius);
                }
            }
        }
        return new Int3(0, 0, 0);
    }

    public Int3 findEmptySpaceFromDirection(ForgeDirection dir, int amount) {
        block10: {
            int index;
            block12: {
                block11: {
                    block9: {
                        index = 0;
                        if (dir != ForgeDirection.NORTH) break block9;
                        if (printDebug) {
                            System.out.print("NORTH!");
                        }
                        for (int i = 0; i <= this.negZRadius + this.posZRadius; ++i) {
                            for (int j = 0; j <= this.negXRadius + this.posXRadius; ++j) {
                                GridSpace space = this.area[j][i];
                                if (!space.isEmpty() || ++index < amount) continue;
                                return new Int3(j - this.negXRadius, space.getYLevel(), i - this.negZRadius);
                            }
                        }
                        break block10;
                    }
                    if (dir != ForgeDirection.SOUTH) break block11;
                    for (int i = this.negZRadius + this.posZRadius; i >= 0; --i) {
                        for (int j = 0; j <= this.negXRadius + this.posXRadius; ++j) {
                            GridSpace space = this.area[j][i];
                            if (!space.isEmpty() || ++index < amount) continue;
                            return new Int3(j - this.negXRadius, space.getYLevel(), i - this.negZRadius);
                        }
                    }
                    break block10;
                }
                if (dir != ForgeDirection.EAST) break block12;
                for (int i = this.negXRadius + this.posXRadius; i >= 0; --i) {
                    for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                        GridSpace space = this.area[i][j];
                        if (!space.isEmpty() || ++index < amount) continue;
                        return new Int3(i - this.negXRadius, space.getYLevel(), j - this.negZRadius);
                    }
                }
                break block10;
            }
            if (dir != ForgeDirection.WEST) break block10;
            for (int i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
                for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                    GridSpace space = this.area[i][j];
                    if (!space.isEmpty() || ++index < amount) continue;
                    return new Int3(i - this.negXRadius, space.getYLevel(), j - this.negZRadius);
                }
            }
        }
        return new Int3(0, 0, 0);
    }

    public int createGriddedRoad(int gridXi, int yi, int gridZi, ForgeDirection dir, int gridLength, boolean convertStarter) {
        if (gridLength == 0 || gridLength == 1) {
            return 0;
        }
        if (convertStarter) {
            // empty if block
        }
        int initGridX = gridXi;
        int initGridZ = gridZi;
        int initY = yi;
        if (convertStarter) {
            this.setGridSpace(initGridX, initGridZ, new GridSpace(4, initY));
            DemonCrosspath crosspath = new DemonCrosspath(this.field_145851_c + initGridX * 5, initY, this.field_145849_e + initGridZ * 5);
            crosspath.createCrosspath(this.field_145850_b);
        }
        for (int index = 0; index < gridLength - 1; ++index) {
            DemonVillagePath path = new DemonVillagePath(this.field_145851_c + initGridX * 5, initY, this.field_145849_e + initGridZ * 5, dir, 6);
            DemonVillagePath.Int3AndBool temp = path.constructFullPath(this, this.field_145850_b, this.getRoadStepClearance());
            Int3 next = temp.coords;
            if (next != null) {
                initY = next.yCoord;
                if (printDebug) {
                    AlchemicalWizardry.logger.info("" + initY);
                }
            }
            if (!temp.bool) {
                return index;
            }
            if (this.getGridSpace(initGridX += dir.offsetX, initGridZ += dir.offsetZ).isRoadSegment()) continue;
            this.setGridSpace(initGridX, initGridZ, new GridSpace(3, initY));
        }
        return gridLength - 1;
    }

    public void expandAreaInNegX() {
        int i;
        GridSpace[][] newGrid = new GridSpace[this.negXRadius + this.posXRadius + 2][this.negZRadius + this.posZRadius + 1];
        for (i = 0; i <= this.negZRadius + this.posZRadius; ++i) {
            newGrid[0][i] = new GridSpace();
        }
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                newGrid[i + 1][j] = this.area[i][j];
            }
        }
        this.area = newGrid;
        ++this.negXRadius;
    }

    public void expandAreaInPosX() {
        int i;
        GridSpace[][] newGrid = new GridSpace[this.negXRadius + this.posXRadius + 2][this.negZRadius + this.posZRadius + 1];
        for (i = 0; i <= this.negZRadius + this.posZRadius; ++i) {
            newGrid[this.negXRadius + this.posXRadius + 1][i] = new GridSpace();
        }
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                newGrid[i][j] = this.area[i][j];
            }
        }
        this.area = newGrid;
        ++this.posXRadius;
    }

    public void expandAreaInNegZ() {
        int i;
        GridSpace[][] newGrid = new GridSpace[this.negXRadius + this.posXRadius + 1][this.negZRadius + this.posZRadius + 2];
        if (printDebug) {
            AlchemicalWizardry.logger.info("x " + newGrid.length + "z " + newGrid[0].length);
        }
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            newGrid[i][0] = new GridSpace();
        }
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                newGrid[i][j + 1] = this.area[i][j];
            }
        }
        this.area = newGrid;
        ++this.negZRadius;
    }

    public void expandAreaInPosZ() {
        int i;
        GridSpace[][] newGrid = new GridSpace[this.negXRadius + this.posXRadius + 1][this.negZRadius + this.posZRadius + 2];
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            newGrid[i][this.negZRadius + this.posZRadius + 1] = new GridSpace();
        }
        for (i = 0; i <= this.negXRadius + this.posXRadius; ++i) {
            for (int j = 0; j <= this.negZRadius + this.posZRadius; ++j) {
                newGrid[i][j] = this.area[i][j];
            }
        }
        this.area = newGrid;
        ++this.posZRadius;
    }

    public GridSpace getGridSpace(int x, int z) {
        if (x > this.posXRadius || x < -this.negXRadius || z > this.posZRadius || z < -this.negZRadius) {
            return new GridSpace();
        }
        return this.area[x + this.negXRadius][z + this.negZRadius];
    }

    public void setGridSpace(int x, int z, GridSpace space) {
        if (x > this.posXRadius) {
            this.expandAreaInPosX();
            this.setGridSpace(x, z, space);
            return;
        }
        if (x < -this.negXRadius) {
            this.expandAreaInNegX();
            this.setGridSpace(x, z, space);
            return;
        }
        if (z > this.posZRadius) {
            this.expandAreaInPosZ();
            this.setGridSpace(x, z, space);
            return;
        }
        if (z < -this.negZRadius) {
            this.expandAreaInNegZ();
            this.setGridSpace(x, z, space);
            return;
        }
        this.area[x + this.negXRadius][z + this.negZRadius] = space;
    }

    public void rightClickBlock(EntityPlayer player, int side) {
    }

    public int createRandomBuilding(int type, int tier) {
        switch (type) {
            case 0: {
                return this.createRandomHouse(tier);
            }
            case 1: {
                return this.createPortalBuilding(tier);
            }
        }
        return 0;
    }

    public int createPortalBuilding(int buildingTier) {
        if (printDebug) {
            AlchemicalWizardry.logger.info("Hello, I am here!");
        }
        int x = 0;
        int z = 0;
        GridSpace home = this.getGridSpace(x, z);
        int yLevel = home.getYLevel();
        GridSpaceHolder grid = this.createGSH();
        ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
        for (int i = 2; i < 6; ++i) {
            ForgeDirection testDir = ForgeDirection.getOrientation((int)i);
            directions.add(testDir);
        }
        if (directions.isEmpty()) {
            return 0;
        }
        HashMap schemMap = new HashMap();
        for (ForgeDirection nextDir : directions) {
            for (DemonBuilding build : buildingList) {
                if (build.buildingType != 1 || build.buildingTier != buildingTier) continue;
                System.out.println("This one matches!");
                if (schemMap.containsKey(nextDir)) {
                    ((List)schemMap.get(nextDir)).add(build);
                    continue;
                }
                schemMap.put(nextDir, new ArrayList());
                ((List)schemMap.get(nextDir)).add(build);
            }
        }
        if (schemMap.keySet().isEmpty()) {
            return 0;
        }
        ForgeDirection chosenDirection = (ForgeDirection)schemMap.keySet().toArray()[new Random().nextInt(schemMap.keySet().size())];
        DemonBuilding build = (DemonBuilding)((List)schemMap.get(chosenDirection)).get(new Random().nextInt(((List)schemMap.get(chosenDirection)).size()));
        Int3 portalSpace = build.getDoorSpace(chosenDirection);
        this.nextDemonPortalDirection = chosenDirection;
        this.nextDemonPortalName = build.getName();
        return build.getNumberOfGridSpaces();
    }

    public void createPortalBuilding(int stage, String name, int tier) {
        for (DemonBuilding build : buildingList) {
            if (build.buildingType != 1 || build.buildingTier != tier || !build.getName().equals(this.nextDemonPortalName)) continue;
            int x = 0;
            int z = 0;
            GridSpace home = this.getGridSpace(x, z);
            int yLevel = home.getYLevel();
            GridSpaceHolder grid = this.createGSH();
            ForgeDirection chosenDirection = this.nextDemonPortalDirection;
            Int3 portalSpace = build.getDoorSpace(chosenDirection);
            int yOffset = portalSpace.yCoord;
            switch (stage) {
                case 0: {
                    break;
                }
                case 1: {
                    int yDestination = yLevel + yOffset;
                    if (this.field_145848_d == yDestination) break;
                    BlockTeleposer.swapBlocks((Object)this, this.field_145850_b, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, yDestination, this.field_145849_e);
                    break;
                }
                case 2: {
                    build.destroyAllInField(this.field_145850_b, this.field_145851_c + x * 5, yLevel, this.field_145849_e + z * 5, chosenDirection.getOpposite());
                    build.buildAll(this, this.field_145850_b, this.field_145851_c + x * 5, yLevel, this.field_145849_e + z * 5, chosenDirection.getOpposite(), true);
                    build.setAllGridSpaces(x, z, yLevel, chosenDirection.getOpposite(), 1, grid);
                    this.loadGSH(grid);
                }
            }
            return;
        }
    }

    public int createRandomHouse(int buildingTier) {
        ForgeDirection dir;
        int next = this.rand.nextInt(4);
        switch (next) {
            case 0: {
                dir = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                dir = ForgeDirection.SOUTH;
                break;
            }
            case 2: {
                dir = ForgeDirection.EAST;
                break;
            }
            case 3: {
                dir = ForgeDirection.WEST;
                break;
            }
            default: {
                dir = ForgeDirection.NORTH;
            }
        }
        Int3 space = this.findRoadSpaceFromDirection(dir, 1 * this.rand.nextInt(this.negXRadius + this.negZRadius + this.posXRadius + this.posZRadius) + 1);
        int x = space.xCoord;
        int z = space.zCoord;
        int yLevel = space.yCoord;
        if (printDebug) {
            AlchemicalWizardry.logger.info("Road space - x: " + x + " z: " + z);
        }
        GridSpaceHolder grid = this.createGSH();
        if (!this.getGridSpace(x, z).isRoadSegment()) {
            return 0;
        }
        ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
        for (int i = 2; i < 6; ++i) {
            ForgeDirection testDir = ForgeDirection.getOrientation((int)i);
            if (!this.getGridSpace(x + testDir.offsetX, z + testDir.offsetZ).isEmpty()) continue;
            directions.add(testDir);
        }
        if (directions.isEmpty()) {
            return 0;
        }
        HashMap schemMap = new HashMap();
        for (ForgeDirection nextDir : directions) {
            for (DemonBuilding build : buildingList) {
                if (build.buildingTier != buildingTier || build.buildingType != 0) continue;
                Int3 offsetSpace = build.getGridOffsetFromRoad(nextDir, yLevel);
                int xOff = offsetSpace.xCoord;
                int zOff = offsetSpace.zCoord;
                if (build.isValid(grid, x + xOff, z + zOff, nextDir.getOpposite())) {
                    if (schemMap.containsKey(nextDir)) {
                        ((List)schemMap.get(nextDir)).add(build);
                        continue;
                    }
                    schemMap.put(nextDir, new ArrayList());
                    ((List)schemMap.get(nextDir)).add(build);
                    continue;
                }
                if (!printDebug) continue;
                AlchemicalWizardry.logger.info("This ISN'T valid!");
            }
        }
        if (schemMap.keySet().isEmpty()) {
            return 0;
        }
        ForgeDirection chosenDirection = (ForgeDirection)schemMap.keySet().toArray()[new Random().nextInt(schemMap.keySet().size())];
        DemonBuilding build = (DemonBuilding)((List)schemMap.get(chosenDirection)).get(new Random().nextInt(((List)schemMap.get(chosenDirection)).size()));
        Int3 offsetSpace = build.getGridOffsetFromRoad(chosenDirection, yLevel);
        int xOff = offsetSpace.xCoord;
        int zOff = offsetSpace.zCoord;
        build.destroyAllInField(this.field_145850_b, this.field_145851_c + (x + xOff) * 5, yLevel, this.field_145849_e + (z + zOff) * 5, chosenDirection.getOpposite());
        build.buildAll(this, this.field_145850_b, this.field_145851_c + (x + xOff) * 5, yLevel, this.field_145849_e + (z + zOff) * 5, chosenDirection.getOpposite(), true);
        build.setAllGridSpaces(x + xOff, z + zOff, yLevel, chosenDirection.getOpposite(), 5, grid);
        this.loadGSH(grid);
        DemonVillagePath path = new DemonVillagePath(this.field_145851_c + x * 5, yLevel, this.field_145849_e + z * 5, chosenDirection, 2);
        DemonVillagePath.Int3AndBool temp = path.constructFullPath(this, this.field_145850_b, this.getRoadStepClearance());
        return build.getNumberOfGridSpaces();
    }

    public int findNearestRoadYLevel(int xCoord, int zCoord, int maxDistance) {
        for (int l = 1; l <= maxDistance; ++l) {
            for (int i = -l; i <= l; ++i) {
                for (int j = -l; j <= l; ++j) {
                    if (Math.abs(i) != l && Math.abs(j) != l || !this.getGridSpace(xCoord + i, zCoord + j).isRoadSegment()) continue;
                    return this.getGridSpace(xCoord + i, zCoord + j).getYLevel();
                }
            }
        }
        return -1;
    }

    public void createRoad(int xi, int yi, int zi, ForgeDirection dir, int length, boolean doesNotDrop) {
        int curX = xi;
        int curY = yi;
        int curZ = zi;
        int roadRadius = this.getRoadRadius();
        if (dir.offsetY != 0) {
            return;
        }
        DemonVillagePath path = new DemonVillagePath(xi, yi, zi, dir, length);
        path.constructFullPath(this, this.field_145850_b, this.getRoadStepClearance());
    }

    public int placeMaterialOnNextAvailable() {
        return 0;
    }

    public int getRoadRadius() {
        return 1;
    }

    public Block getRoadBlock() {
        switch (this.tier) {
            case 0: {
                return (double)this.rand.nextFloat() < 0.6 ? Blocks.field_150347_e : Blocks.field_150341_Y;
            }
            case 1: {
                return Blocks.field_150417_aV;
            }
        }
        return Blocks.field_150385_bj;
    }

    public int getRoadMeta() {
        switch (this.tier) {
            case 1: {
                return (double)this.rand.nextFloat() < 0.6 ? 1 : 0;
            }
        }
        return 0;
    }

    public int getRoadStepClearance() {
        return 10;
    }

    public int getRoadSpacer() {
        return 1;
    }

    public GridSpaceHolder createGSH() {
        GridSpaceHolder grid = new GridSpaceHolder();
        grid.area = this.area;
        grid.negXRadius = this.negXRadius;
        grid.negZRadius = this.negZRadius;
        grid.posXRadius = this.posXRadius;
        grid.posZRadius = this.posZRadius;
        return grid;
    }

    public void loadGSH(GridSpaceHolder grid) {
        this.area = grid.area;
        this.negXRadius = grid.negXRadius;
        this.negZRadius = grid.negZRadius;
        this.posXRadius = grid.posXRadius;
        this.posZRadius = grid.posZRadius;
    }

    public static void loadBuildingList() {
        String folder = "config/BloodMagic/schematics";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = new File(folder);
        File[] files = file.listFiles();
        try {
            for (File f : files) {
                BufferedReader br = new BufferedReader(new FileReader(f));
                BuildingSchematic schema = (BuildingSchematic)gson.fromJson((Reader)br, BuildingSchematic.class);
                buildingList.add(new DemonBuilding(schema));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void addToPoints(int addition) {
        this.demonHouseCooldown += addition;
    }

    public void notifyPortalOfBreak() {
        for (IHoardDemon demon : hoardList) {
            if (!(demon instanceof Entity)) continue;
            ((Entity)demon).func_70106_y();
        }
    }
}

