/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.demonVillage;

import WayofTime.alchemicalWizardry.common.Int3;
import WayofTime.alchemicalWizardry.common.demonVillage.BuildingSchematic;
import WayofTime.alchemicalWizardry.common.demonVillage.GridSpaceHolder;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.TEDemonPortal;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DemonBuilding {
    public static final int BUILDING_HOUSE = 0;
    public static final int BUILDING_PORTAL = 1;
    public BuildingSchematic schematic;
    public GridSpaceHolder area;
    public int buildingTier;
    public int buildingType;
    public Int3 doorGridSpace;

    public DemonBuilding(BuildingSchematic schematic) {
        this.schematic = schematic;
        this.buildingType = schematic.buildingType;
        this.buildingTier = schematic.buildingTier;
        this.area = this.createGSHForSchematic(schematic);
        this.doorGridSpace = schematic.getGridSpotOfDoor();
    }

    public String getName() {
        return this.schematic.getName();
    }

    public boolean isValid(GridSpaceHolder master, int gridX, int gridZ, ForgeDirection dir) {
        return this.area.doesContainAll(master, gridX, gridZ, dir);
    }

    public void buildAll(TEDemonPortal teDemonPortal, World world, int xCoord, int yCoord, int zCoord, ForgeDirection dir, boolean populateInventories) {
        this.schematic.buildAll(teDemonPortal, world, xCoord, yCoord, zCoord, dir, populateInventories);
    }

    public void setAllGridSpaces(int xInit, int zInit, int yLevel, ForgeDirection dir, int type, GridSpaceHolder master) {
        this.area.setAllGridSpaces(xInit, zInit, yLevel, dir, type, master);
    }

    public GridSpaceHolder createGSHForSchematic(BuildingSchematic scheme) {
        switch (this.buildingType) {
            case 0: {
                return scheme.createGSH();
            }
        }
        return scheme.createGSH();
    }

    public Int3 getDoorSpace(ForgeDirection dir) {
        int x = 0;
        int z = 0;
        switch (dir) {
            case SOUTH: {
                x = -this.doorGridSpace.xCoord;
                z = -this.doorGridSpace.zCoord;
                break;
            }
            case WEST: {
                x = this.doorGridSpace.zCoord;
                z = -this.doorGridSpace.xCoord;
                break;
            }
            case EAST: {
                x = -this.doorGridSpace.zCoord;
                z = this.doorGridSpace.xCoord;
                break;
            }
            default: {
                x = this.doorGridSpace.xCoord;
                z = this.doorGridSpace.zCoord;
            }
        }
        return new Int3(x, this.doorGridSpace.yCoord, z);
    }

    public Int3 getGridOffsetFromRoad(ForgeDirection sideOfRoad, int yLevel) {
        Int3 doorSpace = this.getDoorSpace(sideOfRoad);
        int x = doorSpace.xCoord;
        int z = doorSpace.zCoord;
        switch (sideOfRoad) {
            case SOUTH: {
                ++z;
                break;
            }
            case EAST: {
                ++x;
                break;
            }
            case WEST: {
                --x;
                break;
            }
            default: {
                --z;
            }
        }
        return new Int3(x, yLevel, z);
    }

    public void destroyAllInField(World world, int xCoord, int yCoord, int zCoord, ForgeDirection dir) {
        this.schematic.destroyAllInField(world, xCoord, yCoord, zCoord, dir);
    }

    public int getNumberOfGridSpaces() {
        return this.area.getNumberOfGridSpaces();
    }
}

