/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;

public class NEIAltarRecipeHandler
extends TemplateRecipeHandler {
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("alchemicalwizardry.altar") && ((Object)((Object)this)).getClass() == NEIAltarRecipeHandler.class) {
            for (AltarRecipe recipe : AltarRecipeRegistry.altarRecipes) {
                if (recipe == null || recipe.result == null) continue;
                this.arecipes.add(new CachedAltarRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (AltarRecipe recipe : AltarRecipeRegistry.altarRecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.result, (ItemStack)result) || recipe == null || recipe.result == null) continue;
            this.arecipes.add(new CachedAltarRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (AltarRecipe recipe : AltarRecipeRegistry.altarRecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.requiredItem, (ItemStack)ingredient) || recipe == null || recipe.result == null) continue;
            this.arecipes.add(new CachedAltarRecipe(recipe));
        }
    }

    public Point getMouse(int width, int height) {
        Point mousepos = this.getMousePosition();
        int guiLeft = (width - 176) / 2;
        int guiTop = (height - 166) / 2;
        Point relMouse = new Point(mousepos.x - guiLeft, mousepos.y - guiTop);
        return relMouse;
    }

    public int getGuiWidth(GuiRecipe gui) {
        try {
            Field f = gui.getClass().getField("width");
            return (Integer)f.get(gui);
        }
        catch (NoSuchFieldException e) {
            try {
                Field f = gui.getClass().getField("field_146294_l");
                return (Integer)f.get(gui);
            }
            catch (Exception e2) {
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getGuiHeight(GuiRecipe gui) {
        try {
            Field f = gui.getClass().getField("height");
            return (Integer)f.get(gui);
        }
        catch (NoSuchFieldException e) {
            try {
                Field f = gui.getClass().getField("field_146295_m");
                return (Integer)f.get(gui);
            }
            catch (Exception e2) {
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void drawExtras(int id) {
        CachedAltarRecipe recipe = (CachedAltarRecipe)((Object)this.arecipes.get(id));
        Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a77" + StatCollector.func_74838_a((String)"bm.string.tier") + ": " + recipe.tier, 78, 5, 0);
        Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a77LP: " + recipe.lp_amount, 78, 15, 0);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int id) {
        int yHigh;
        currenttip = super.handleTooltip(gui, currenttip, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        CachedAltarRecipe recipe = (CachedAltarRecipe)((Object)this.arecipes.get(id));
        int yLow = id % 2 == 0 ? 38 : 102;
        int n = yHigh = id % 2 == 0 ? 72 : 136;
        if (mouse.x >= 19 && mouse.x <= 80 && mouse.y >= yLow && mouse.y <= yHigh) {
            currenttip.add(StatCollector.func_74838_a((String)"bm.string.consume") + ": " + recipe.consumption + "LP/t");
            currenttip.add(StatCollector.func_74838_a((String)"bm.string.drain") + ": " + recipe.drain + "LP/t");
        }
        return currenttip;
    }

    public String getOverlayIdentifier() {
        return "altarrecipes";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(90, 32, 22, 16), "alchemicalwizardry.altar", new Object[0]));
    }

    public String getRecipeName() {
        return "          " + StatCollector.func_74838_a((String)"tile.bloodAltar.name");
    }

    public String getGuiTexture() {
        return new ResourceLocation("alchemicalwizardry", "gui/nei/altar.png").toString();
    }

    public static Point getMousePosition() {
        Dimension size = NEIAltarRecipeHandler.displaySize();
        Dimension res = NEIAltarRecipeHandler.displayRes();
        return new Point(Mouse.getX() * size.width / res.width, size.height - Mouse.getY() * size.height / res.height - 1);
    }

    public static Dimension displaySize() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        return new Dimension(res.func_78326_a(), res.func_78328_b());
    }

    public static Dimension displayRes() {
        Minecraft mc = Minecraft.func_71410_x();
        return new Dimension(mc.field_71443_c, mc.field_71440_d);
    }

    public class CachedAltarRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        int tier;
        int lp_amount;
        int consumption;
        int drain;

        public CachedAltarRecipe(AltarRecipe recipe) {
            super((TemplateRecipeHandler)NEIAltarRecipeHandler.this);
            this.input = new PositionedStack((Object)recipe.requiredItem, 38, 2, false);
            this.output = new PositionedStack((Object)recipe.result, 132, 32, false);
            this.tier = recipe.minTier;
            this.lp_amount = recipe.liquidRequired;
            this.consumption = recipe.consumptionRate;
            this.drain = recipe.drainRate;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

