/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.spell;

import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class APISpellHelper {
    public static int getPlayerLPTag(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:StoredLP")) {
            return data.func_74762_e("BM:StoredLP");
        }
        return 0;
    }

    public static void setPlayerLPTag(EntityPlayer player, int amount) {
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a("BM:StoredLP", amount);
    }

    public static int getPlayerMaxLPTag(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:MaxStoredLP")) {
            return data.func_74762_e("BM:MaxStoredLP");
        }
        return 0;
    }

    public static void setPlayerMaxLPTag(EntityPlayer player, int amount) {
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a("BM:MaxStoredLP", amount);
    }

    public static float getPlayerCurrentReagentAmount(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:StoredReagentAmount")) {
            return data.func_74760_g("BM:StoredReagentAmount");
        }
        return 0.0f;
    }

    public static void setPlayerCurrentReagentAmount(EntityPlayer player, float amount) {
        NBTTagCompound data = player.getEntityData();
        data.func_74776_a("BM:StoredReagentAmount", amount);
    }

    public static float getPlayerMaxReagentAmount(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:MaxReagentAmount")) {
            return data.func_74760_g("BM:MaxReagentAmount");
        }
        return 0.0f;
    }

    public static void setPlayerMaxReagentAmount(EntityPlayer player, float amount) {
        NBTTagCompound data = player.getEntityData();
        data.func_74776_a("BM:MaxReagentAmount", amount);
    }

    public static Reagent getPlayerReagentType(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:ReagentType")) {
            return ReagentRegistry.getReagentForKey(data.func_74779_i("BM:ReagentType"));
        }
        return null;
    }

    public static void setPlayerReagentType(EntityPlayer player, String str) {
        NBTTagCompound data = player.getEntityData();
        data.func_74778_a("BM:ReagentType", str);
    }

    public static void setPlayerReagentType(EntityPlayer player, Reagent reagent) {
        APISpellHelper.setPlayerReagentType(player, ReagentRegistry.getKeyForReagent(reagent));
    }

    public static float getCurrentAdditionalHP(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:CurrentAddedHP")) {
            return data.func_74760_g("BM:CurrentAddedHP");
        }
        return 0.0f;
    }

    public static void setCurrentAdditionalHP(EntityPlayer player, float amount) {
        NBTTagCompound data = player.getEntityData();
        data.func_74776_a("BM:CurrentAddedHP", amount);
    }

    public static float getCurrentAdditionalMaxHP(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:MaxAddedHP")) {
            return data.func_74760_g("BM:MaxAddedHP");
        }
        return 0.0f;
    }

    public static void setCurrentAdditionalMaxHP(EntityPlayer player, float maxHP) {
        NBTTagCompound data = player.getEntityData();
        data.func_74776_a("BM:MaxAddedHP", maxHP);
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            // empty if block
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    public static List<ItemStack> getItemsFromBlock(World world, Block block, int x, int y, int z, int meta, boolean silkTouch, int fortune) {
        boolean canSilk = block.canSilkHarvest(world, null, x, y, z, meta);
        if (canSilk && silkTouch) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack item = new ItemStack(block, 1, meta);
            items.add(item);
            return items;
        }
        return block.getDrops(world, x, y, z, meta, fortune);
    }

    public static void spawnItemListInWorld(List<ItemStack> items, World world, float x, float y, float z) {
        for (ItemStack stack : items) {
            EntityItem itemEntity = new EntityItem(world, (double)x, (double)y, (double)z, stack);
            itemEntity.field_145804_b = 10;
            world.func_72838_d((Entity)itemEntity);
        }
    }

    public static String getNumeralForInt(int num) {
        switch (num) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
        }
        return "";
    }
}

