/*
 * Decompiled with CFR 0.152.
 */
package gravestone.tileentity;

import gravestone.block.GraveStoneHelper;
import gravestone.block.enums.EnumGraves;
import gravestone.config.GraveStoneConfig;
import gravestone.core.TimeHelper;
import gravestone.core.event.GSRenderEventHandler;
import gravestone.core.logger.GSLogger;
import gravestone.tileentity.GSGraveStoneItems;
import gravestone.tileentity.GSGraveStoneSpawn;
import gravestone.tileentity.TileEntityGSGrave;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityGSGraveStone
extends TileEntityGSGrave {
    protected GSGraveStoneSpawn gsSpawn;
    protected ItemStack sword = null;
    protected ItemStack flower = null;
    public static final int FOG_RANGE = 30;

    public TileEntityGSGraveStone() {
        this.gsSpawn = new GSGraveStoneSpawn(this);
        this.gSItems = new GSGraveStoneItems(this);
    }

    public TileEntityGSGraveStone(World world) {
        this.field_145850_b = world;
        this.gsSpawn = new GSGraveStoneSpawn(this);
        this.gSItems = new GSGraveStoneItems(this);
    }

    public void func_145845_h() {
        EntityPlayer player;
        this.gsSpawn.updateEntity();
        if (this.field_145850_b.field_72995_K && GraveStoneConfig.isFogEnabled && (player = this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 30.0)) != null && player.func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) && TileEntityGSGraveStone.isFogTime(this.field_145850_b)) {
            GSRenderEventHandler.addFog();
        }
    }

    public static boolean isFogTime(World world) {
        if (world.func_72896_J()) {
            return false;
        }
        long dayTime = TimeHelper.getDayTime(world);
        return dayTime > 12000L && dayTime < 24000L;
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1 && this.field_145850_b.field_72995_K) {
            this.gsSpawn.setMinDelay();
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.readType(nbtTag);
        this.gSItems.readItems(nbtTag);
        this.gSDeathText.readText(nbtTag);
        if (nbtTag.func_74764_b("Age")) {
            this.age = nbtTag.func_74762_e("Age");
        }
        this.readSwordInfo(nbtTag);
        this.readFlowerInfo(nbtTag);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        this.saveType(nbtTag);
        this.gSItems.saveItems(nbtTag);
        this.gSDeathText.saveText(nbtTag);
        nbtTag.func_74768_a("Age", this.age);
        this.writeSwordInfo(nbtTag);
        this.writeFlowerInfo(nbtTag);
    }

    private void readSwordInfo(NBTTagCompound nbtTag) {
        if (this.graveType > 4 && this.graveType < 10 || nbtTag.func_74764_b("SwordGrave")) {
            this.convertSword(nbtTag);
        } else if (nbtTag.func_74764_b("Sword")) {
            this.sword = ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l("Sword"));
        }
    }

    private void writeSwordInfo(NBTTagCompound nbtTag) {
        if (this.sword != null) {
            NBTTagCompound swordNBT = new NBTTagCompound();
            this.sword.func_77955_b(swordNBT);
            nbtTag.func_74782_a("Sword", (NBTBase)swordNBT);
        }
    }

    private void readFlowerInfo(NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("Flower")) {
            this.flower = ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l("Flower"));
        }
    }

    private void writeFlowerInfo(NBTTagCompound nbtTag) {
        if (this.flower != null) {
            NBTTagCompound flowerNBT = new NBTTagCompound();
            this.flower.func_77955_b(flowerNBT);
            nbtTag.func_74782_a("Flower", (NBTBase)flowerNBT);
        }
    }

    public ItemStack getSword() {
        return this.sword;
    }

    public void setSword(ItemStack sword) {
        this.sword = sword;
    }

    public void dropSword() {
        if (this.sword != null) {
            GSGraveStoneItems.dropItem(this.sword, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean isSwordGrave() {
        return this.sword != null;
    }

    public ItemStack getFlower() {
        return this.flower;
    }

    public void setFlower(ItemStack flower) {
        this.flower = flower;
    }

    public void dropFlower() {
        if (this.flower != null) {
            GSGraveStoneItems.dropItem(this.flower, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean hasFlower() {
        return this.flower != null;
    }

    public EnumGraves getGraveType() {
        return EnumGraves.getByID(this.graveType);
    }

    public boolean isEmpty() {
        return this.gSItems.graveContents.isEmpty();
    }

    private void convertSword(NBTTagCompound nbtTag) {
        GSLogger.logInfo("Start converting sword gravestone!");
        try {
            Item sword;
            byte swordType = nbtTag.func_74771_c("SwordType");
            if (swordType == 0) {
                swordType = (byte)(this.graveType - 4);
            }
            switch (swordType) {
                case 5: {
                    sword = Items.field_151048_u;
                    break;
                }
                case 3: {
                    sword = Items.field_151040_l;
                    break;
                }
                case 2: {
                    sword = Items.field_151052_q;
                    break;
                }
                case 4: {
                    sword = Items.field_151010_B;
                    break;
                }
                default: {
                    sword = Items.field_151041_m;
                }
            }
            GSLogger.logInfo("Sword type - " + nbtTag.func_74771_c("SwordType") + ". Will be converted to " + sword.func_77658_a());
            int damage = 0;
            if (nbtTag.func_74764_b("SwordDamage")) {
                damage = nbtTag.func_74762_e("SwordDamage");
                GSLogger.logInfo("Sword damage - " + damage);
            }
            ItemStack stack = new ItemStack(sword, 1, damage);
            if (nbtTag.func_74764_b("SwordName")) {
                stack.func_151001_c(nbtTag.func_74779_i("SwordName"));
                GSLogger.logInfo("Sword name - " + nbtTag.func_74779_i("SwordName"));
            }
            if (nbtTag.func_74764_b("SwordNBT")) {
                stack.func_77982_d(nbtTag.func_74775_l("SwordNBT"));
            }
            this.sword = stack;
        }
        catch (Exception e) {
            GSLogger.logError("Something went wrong!!!");
            e.printStackTrace();
        }
        GSLogger.logInfo("Gravestone converting complete!");
    }

    @Override
    public void setGraveContent(Random random, boolean isPetGrave, boolean allLoot) {
        super.setGraveContent(random, isPetGrave, allLoot);
        this.setRandomFlower(random);
    }

    public void setRandomFlower(Random random) {
        ItemStack flower;
        if (random.nextInt(4) == 0 && GraveStoneHelper.canFlowerBePlaced(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, flower = new ItemStack((Block)GraveStoneHelper.FLOWERS.get(random.nextInt(GraveStoneHelper.FLOWERS.size())), 1), this)) {
            this.setFlower(flower);
        }
    }
}

