/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.catacombs.components;

import gravestone.core.GSBlock;
import gravestone.structures.BoundingBoxHelper;
import gravestone.structures.catacombs.components.CatacombsBaseComponent;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class Entrance
extends CatacombsBaseComponent {
    public static final int X_LENGTH = 4;
    private int stairsLength;
    private int corridorLength;

    public Entrance(int direction, Random random, int x, int y, int z) {
        super(direction);
        this.stairsLength = 4 + random.nextInt(4);
        this.corridorLength = 2 + random.nextInt(2);
        this.field_74887_e = BoundingBoxHelper.getCorrectBox(direction, x, y - this.stairsLength * 3, z, 4, this.stairsLength * 3, (this.stairsLength + this.corridorLength) * 3 + 5, this.xShift);
        switch (direction) {
            case 0: {
                this.leftXEnd = 3;
                this.leftZEnd = (this.stairsLength + this.corridorLength) * 3;
                this.rightXEnd = 0;
                this.rightZEnd = this.leftZEnd;
                break;
            }
            case 1: {
                this.leftXEnd = 3;
                this.leftZEnd = (this.stairsLength + this.corridorLength) * 3 + 4;
                this.rightXEnd = 0;
                this.rightZEnd = this.leftZEnd;
                break;
            }
            case 2: {
                this.leftXEnd = 0;
                this.leftZEnd = (this.stairsLength + this.corridorLength) * 3 + 4;
                this.rightXEnd = 3;
                this.rightZEnd = this.leftZEnd;
                break;
            }
            case 3: {
                this.leftXEnd = 0;
                this.leftZEnd = (this.stairsLength + this.corridorLength) * 3;
                this.rightXEnd = 3;
                this.rightZEnd = this.leftZEnd;
            }
        }
    }

    @Override
    public boolean addComponentParts(World world, Random random) {
        int top = this.field_74887_e.field_78894_e - this.field_74887_e.field_78895_b - 1;
        int metaBot = this.func_151555_a(Blocks.field_150387_bl, 2);
        int metaTop = this.func_151555_a(Blocks.field_150390_bg, 3) + 4;
        int shiftY = top;
        int shiftZ = 0;
        for (int i = 0; i < this.stairsLength; ++i) {
            shiftZ = i * 3;
            shiftY = top - i * 3 + 1;
            this.func_74878_a(world, this.field_74887_e, 1, shiftY, shiftZ, 2, shiftY, shiftZ + 3);
            this.func_74878_a(world, this.field_74887_e, 1, shiftY - 1, shiftZ + 1, 2, shiftY - 1, shiftZ + 4);
            this.func_74878_a(world, this.field_74887_e, 1, shiftY - 2, shiftZ + 2, 2, shiftY - 2, shiftZ + 5);
            this.func_151549_a(world, this.field_74887_e, 0, shiftY, shiftZ, 0, shiftY + 4, shiftZ, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
            this.func_151549_a(world, this.field_74887_e, 3, shiftY, shiftZ, 3, shiftY + 4, shiftZ, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
            this.func_74882_a(world, this.field_74887_e, 0, shiftY - 2, shiftZ + 1, 0, shiftY + 3, shiftZ + 2, false, random, this.getCemeteryCatacombsStones());
            this.func_74882_a(world, this.field_74887_e, 3, shiftY - 2, shiftZ + 1, 3, shiftY + 3, shiftZ + 2, false, random, this.getCemeteryCatacombsStones());
            this.func_151556_a(world, this.field_74887_e, 1, shiftY, shiftZ, 2, shiftY, shiftZ, Blocks.field_150387_bl, metaBot, Blocks.field_150387_bl, metaBot, false);
            this.func_151556_a(world, this.field_74887_e, 1, shiftY - 1, shiftZ + 1, 2, shiftY - 1, shiftZ + 1, Blocks.field_150387_bl, metaBot, Blocks.field_150387_bl, metaBot, false);
            this.func_151556_a(world, this.field_74887_e, 1, shiftY - 2, shiftZ + 2, 2, shiftY - 2, shiftZ + 2, Blocks.field_150387_bl, metaBot, Blocks.field_150387_bl, metaBot, false);
            this.func_151556_a(world, this.field_74887_e, 1, shiftY, shiftZ + 4, 2, shiftY, shiftZ + 4, Blocks.field_150390_bg, metaTop, Blocks.field_150390_bg, metaTop, false);
            this.func_151556_a(world, this.field_74887_e, 1, shiftY - 1, shiftZ + 5, 2, shiftY - 1, shiftZ + 5, Blocks.field_150390_bg, metaTop, Blocks.field_150390_bg, metaTop, false);
            this.func_151556_a(world, this.field_74887_e, 1, shiftY - 2, shiftZ + 6, 2, shiftY - 2, shiftZ + 6, Blocks.field_150390_bg, metaTop, Blocks.field_150390_bg, metaTop, false);
        }
        int zLength = this.corridorLength * 3;
        this.func_74878_a(world, this.field_74887_e, 1, ++shiftY - 2, shiftZ += 3, 2, shiftY - 1, shiftZ);
        this.func_74878_a(world, this.field_74887_e, 1, shiftY - 3, shiftZ + 1, 2, shiftY - 1, shiftZ + zLength + 4);
        this.func_151550_a(world, Blocks.field_150385_bj, 0, 0, shiftY, shiftZ, this.field_74887_e);
        this.func_151550_a(world, Blocks.field_150385_bj, 0, 3, shiftY, shiftZ, this.field_74887_e);
        this.func_151549_a(world, this.field_74887_e, 0, shiftY, shiftZ + 1, 3, shiftY, shiftZ + zLength + 4, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_151549_a(world, this.field_74887_e, 0, shiftY - 4, shiftZ, 3, shiftY - 4, shiftZ + zLength + 4, GSBlock.trap, GSBlock.trap, false);
        for (int j = 0; j < this.corridorLength; ++j) {
            this.func_151549_a(world, this.field_74887_e, 0, shiftY - 3, shiftZ, 0, shiftY - 1, shiftZ, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
            this.func_151549_a(world, this.field_74887_e, 3, shiftY - 3, shiftZ, 3, shiftY - 1, shiftZ, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
            this.func_74882_a(world, this.field_74887_e, 0, shiftY - 3, shiftZ + 1, 0, shiftY - 1, shiftZ + 2, false, random, this.getCemeteryCatacombsStones());
            this.func_74882_a(world, this.field_74887_e, 3, shiftY - 3, shiftZ + 1, 3, shiftY - 1, shiftZ + 2, false, random, this.getCemeteryCatacombsStones());
            this.func_151551_a(world, this.field_74887_e, random, 0.3f, shiftY - 1, shiftY - 3, shiftZ + 1, shiftY - 1, shiftY - 3, shiftZ + 1, Blocks.field_150321_G, Blocks.field_150321_G, false);
            this.func_151551_a(world, this.field_74887_e, random, 0.3f, shiftY - 2, shiftY - 3, shiftZ + 2, shiftY - 2, shiftY - 3, shiftZ + 2, Blocks.field_150321_G, Blocks.field_150321_G, false);
            shiftZ += 3;
        }
        this.func_74882_a(world, this.field_74887_e, 1, shiftY - 3, shiftZ += 4, 2, shiftY - 1, shiftZ, false, random, this.getCemeteryCatacombsStones());
        return true;
    }

    @Override
    public boolean canGoOnlyTop() {
        return false;
    }
}

