/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures;

import gravestone.block.BlockGSSpawner;
import gravestone.block.enums.EnumHauntedChest;
import gravestone.core.GSBlock;
import gravestone.structures.ComponentGraveStone;
import gravestone.tileentity.TileEntityGSHauntedChest;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class ObjectsGenerationHelper {
    private static final int[] POTIONS = new int[]{32764, 32692};
    private static final WeightedRandomChestContent[] NETHER_CHEST_CONTENT = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 3, 5), new WeightedRandomChestContent(Items.field_151042_j, 0, 1, 5, 5), new WeightedRandomChestContent(Items.field_151043_k, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151010_B, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151171_ah, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151033_d, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151075_bm, 0, 3, 7, 5), new WeightedRandomChestContent(Items.field_151141_av, 0, 1, 1, 10), new WeightedRandomChestContent(Items.field_151136_bY, 0, 1, 1, 8), new WeightedRandomChestContent(Items.field_151138_bX, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151125_bZ, 0, 1, 1, 3)};

    private ObjectsGenerationHelper() {
    }

    public static void generateChest(ComponentGraveStone component, World world, Random random, int xCoord, int yCoord, int zCoord, boolean defaultChest, EnumChestTypes chestType) {
        if (chestType.equals((Object)EnumChestTypes.ALL_CHESTS) && random.nextInt(7) == 0) {
            ObjectsGenerationHelper.generateHauntedChest(component, world, random, xCoord, yCoord, zCoord);
        } else {
            ObjectsGenerationHelper.generateVanillaChest(component, world, random, xCoord, yCoord, zCoord, defaultChest, chestType);
        }
    }

    public static void generateVanillaChest(ComponentGraveStone component, World world, Random random, int xCoord, int yCoord, int zCoord, boolean defaultChest, EnumChestTypes chestType) {
        int count;
        WeightedRandomChestContent[] items;
        int y = component.func_74862_a(yCoord);
        int x = component.func_74865_a(xCoord, zCoord);
        int z = component.func_74873_b(xCoord, zCoord);
        ChestGenHooks chest = ObjectsGenerationHelper.getChest(random, chestType);
        if (chest == null) {
            items = NETHER_CHEST_CONTENT;
            count = 2 + random.nextInt(4);
        } else {
            items = chest.getItems(random);
            count = chest.getCount(random);
        }
        if (defaultChest) {
            component.func_74879_a(world, component.func_74874_b(), random, xCoord, yCoord, zCoord, items, count);
        } else {
            ObjectsGenerationHelper.generateTrappedChestContents(component, world, random, xCoord, yCoord, zCoord, items, count);
        }
    }

    public static void generateHauntedChest(ComponentGraveStone component, World world, Random random, int xCoord, int yCoord, int zCoord) {
        int x = component.func_74865_a(xCoord, zCoord);
        int y = component.func_74862_a(yCoord);
        int z = component.func_74873_b(xCoord, zCoord);
        world.func_147465_d(x, y, z, (Block)GSBlock.hauntedChest, 0, 2);
        TileEntityGSHauntedChest te = (TileEntityGSHauntedChest)world.func_147438_o(x, y, z);
        if (te != null) {
            te.setChestType(EnumHauntedChest.getById((byte)random.nextInt(EnumHauntedChest.values().length)));
        }
    }

    public static void generateTrappedChestContents(ComponentGraveStone component, World world, Random random, int xCoord, int yCoord, int zCoord, WeightedRandomChestContent[] chestContent, int count) {
        int x = component.func_74865_a(xCoord, zCoord);
        int y = component.func_74862_a(yCoord);
        int z = component.func_74873_b(xCoord, zCoord);
        world.func_147465_d(x, y, z, Blocks.field_150447_bR, 0, 2);
        TileEntityChest tileentitychest = (TileEntityChest)world.func_147438_o(x, y, z);
        if (tileentitychest != null) {
            WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])chestContent, (IInventory)tileentitychest, (int)count);
        }
    }

    private static ChestGenHooks getChest(Random random, EnumChestTypes chestType) {
        switch (chestType) {
            case VALUABLE_CHESTS: {
                switch (random.nextInt(7)) {
                    case 1: {
                        return ChestGenHooks.getInfo((String)"dungeonChest");
                    }
                    case 2: {
                        return ChestGenHooks.getInfo((String)"mineshaftCorridor");
                    }
                    case 3: {
                        return ChestGenHooks.getInfo((String)"pyramidDesertyChest");
                    }
                    case 4: {
                        return ChestGenHooks.getInfo((String)"strongholdCrossing");
                    }
                    case 5: {
                        return ChestGenHooks.getInfo((String)"strongholdLibrary");
                    }
                    case 6: {
                        return null;
                    }
                }
                return ChestGenHooks.getInfo((String)"strongholdCorridor");
            }
        }
        switch (random.nextInt(9)) {
            case 1: {
                return ChestGenHooks.getInfo((String)"dungeonChest");
            }
            case 2: {
                return ChestGenHooks.getInfo((String)"mineshaftCorridor");
            }
            case 3: {
                return ChestGenHooks.getInfo((String)"pyramidDesertyChest");
            }
            case 4: {
                return ChestGenHooks.getInfo((String)"pyramidJungleChest");
            }
            case 5: {
                return ChestGenHooks.getInfo((String)"strongholdCrossing");
            }
            case 6: {
                return ChestGenHooks.getInfo((String)"strongholdLibrary");
            }
            case 7: {
                return ChestGenHooks.getInfo((String)"villageBlacksmith");
            }
            case 8: {
                return null;
            }
        }
        return ChestGenHooks.getInfo((String)"strongholdCorridor");
    }

    public static void generateSpawner(ComponentGraveStone component, World world, Random random, int xCoord, int yCoord, int zCoord) {
        int y = component.func_74862_a(yCoord);
        int x = component.func_74865_a(xCoord, zCoord);
        int z = component.func_74873_b(xCoord, zCoord);
        world.func_147465_d(x, y, z, (Block)GSBlock.spawner, (int)BlockGSSpawner.MOB_SPAWNERS.get(random.nextInt(BlockGSSpawner.MOB_SPAWNERS.size())).byteValue(), 2);
    }

    public static void generateMinecraftSpawner(ComponentGraveStone component, World world, int xCoord, int yCoord, int zCoord, String mobNmae) {
        int y = component.func_74862_a(yCoord);
        int x = component.func_74865_a(xCoord, zCoord);
        int z = component.func_74873_b(xCoord, zCoord);
        world.func_147449_b(x, y, z, Blocks.field_150474_ac);
        TileEntityMobSpawner tileEntity = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            tileEntity.func_145881_a().func_98272_a(mobNmae);
        }
    }

    public static void generateDispenser(World world, ComponentGraveStone component, Random random, int xCoord, int yCoord, int zCoord, int direction) {
        int x = component.func_74865_a(xCoord, zCoord);
        int y = component.func_74862_a(yCoord);
        int z = component.func_74873_b(xCoord, zCoord);
        world.func_147449_b(x, y, z, Blocks.field_150367_z);
        ObjectsGenerationHelper.setDispenserMeta(world, x, y, z, direction);
        TileEntityDispenser dispenser = (TileEntityDispenser)world.func_147438_o(x, y, z);
        if (dispenser != null) {
            ObjectsGenerationHelper.generateDispenserContents(random, dispenser);
        }
    }

    public static void generateDispenserContents(Random random, TileEntityDispenser dispenserEntity) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = new ItemStack((Item)Items.field_151068_bn, ObjectsGenerationHelper.getRandomCount(random), POTIONS[random.nextInt(POTIONS.length)]);
            dispenserEntity.func_70299_a(i, stack);
        }
    }

    private static int getRandomCount(Random random) {
        return 5 + random.nextInt(5);
    }

    public static void setDispenserMeta(World world, int x, int y, int z, int direction) {
        switch (direction) {
            case 0: {
                world.func_72921_c(x, y, z, 2, 2);
                break;
            }
            case 1: {
                world.func_72921_c(x, y, z, 5, 2);
                break;
            }
            case 2: {
                world.func_72921_c(x, y, z, 3, 2);
                break;
            }
            case 3: {
                world.func_72921_c(x, y, z, 4, 2);
            }
        }
    }

    public static enum EnumChestTypes {
        ALL_CHESTS,
        VALUABLE_CHESTS;

    }
}

