/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures;

import gravestone.block.GraveStoneHelper;
import gravestone.core.GSBlock;
import gravestone.structures.ComponentGraveStone;
import gravestone.tileentity.TileEntityGSGraveStone;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GraveGenerationHelper {
    private GraveGenerationHelper() {
    }

    public static void placeGrave(ComponentGraveStone component, World world, Random random, int x, int y, int z, int graveMeta, byte graveType, Item sword, boolean allLoot) {
        component.func_151550_a(world, (Block)GSBlock.graveStone, graveMeta, x, y, z, component.func_74874_b());
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(component.func_74865_a(x, z), component.func_74862_a(y), component.func_74873_b(x, z));
        if (tileEntity != null) {
            if (GraveStoneHelper.isSwordGrave(graveType)) {
                tileEntity.setSword(new ItemStack(sword));
            }
            tileEntity.setGraveType(graveType);
            tileEntity.setGraveContent(random, GraveStoneHelper.isPetGrave(graveType), allLoot);
        }
    }

    public static void fillGraves(ComponentGraveStone component, World world, Random random, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, int graveMeta, byte graveType, Item sword, boolean allLoot) {
        for (int y = yStart; y <= yEnd; ++y) {
            for (int x = xStart; x <= xEnd; ++x) {
                for (int z = zStart; z <= zEnd; ++z) {
                    GraveGenerationHelper.placeGrave(component, world, random, x, y, z, graveMeta, graveType, sword, allLoot);
                }
            }
        }
    }

    public static boolean canPlaceGrave(World world, int x, int minY, int z, int maxY) {
        for (int y = maxY; y >= minY - 1; --y) {
            Block block = world.func_147439_a(x, y, z);
            if (block == null) continue;
            if (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150353_l)) {
                return false;
            }
            if (!GraveStoneHelper.canPlaceBlockAt(world, block, x, y, z)) continue;
            return true;
        }
        return false;
    }
}

