/*
 * Decompiled with CFR 0.152.
 */
package gravestone.renderer.tileentity;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.block.enums.EnumGraves;
import gravestone.models.block.ModelGraveStone;
import gravestone.models.block.graves.ModelCatStatueGraveStone;
import gravestone.models.block.graves.ModelCrossGraveStone;
import gravestone.models.block.graves.ModelDogStatueGraveStone;
import gravestone.models.block.graves.ModelHorisontalPlateGraveStone;
import gravestone.models.block.graves.ModelHorseGraveStone;
import gravestone.models.block.graves.ModelSwordGrave;
import gravestone.models.block.graves.ModelVerticalPlateGraveStone;
import gravestone.renderer.tileentity.TileEntityGSRenderer;
import gravestone.tileentity.TileEntityGSGraveStone;
import java.util.Map;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityGSGraveStoneRenderer
extends TileEntityGSRenderer {
    public static ModelGraveStone verticalPlate = new ModelVerticalPlateGraveStone();
    public static ModelGraveStone cross = new ModelCrossGraveStone();
    public static ModelGraveStone horisontalPlate = new ModelHorisontalPlateGraveStone();
    public static ModelGraveStone dogStatue = new ModelDogStatueGraveStone();
    public static ModelGraveStone catStatue = new ModelCatStatueGraveStone();
    public static ModelGraveStone horseStatue = new ModelHorseGraveStone();
    public static ModelGraveStone swordGrave = new ModelSwordGrave();
    public static TileEntityGSGraveStoneRenderer instance;
    private final Map<EnumGraves, ModelGraveStone> MODELS_MAP = ImmutableMap.builder().put((Object)EnumGraves.STONE_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.STONE_CROSS, (Object)cross).put((Object)EnumGraves.STONE_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.STONE_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.STONE_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.WOODEN_SWORD, (Object)swordGrave).put((Object)EnumGraves.STONE_SWORD, (Object)swordGrave).put((Object)EnumGraves.IRON_SWORD, (Object)swordGrave).put((Object)EnumGraves.GOLDEN_SWORD, (Object)swordGrave).put((Object)EnumGraves.DIAMOND_SWORD, (Object)swordGrave).put((Object)EnumGraves.STONE_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.WOODEN_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.SANDSTONE_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.IRON_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.GOLDEN_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.DIAMOND_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.EMERALD_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.LAPIS_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.REDSTONE_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.OBSIDIAN_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.QUARTZ_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.ICE_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.MOSSY_VERTICAL_PLATE, (Object)verticalPlate).put((Object)EnumGraves.WOODEN_CROSS, (Object)cross).put((Object)EnumGraves.SANDSTONE_CROSS, (Object)cross).put((Object)EnumGraves.IRON_CROSS, (Object)cross).put((Object)EnumGraves.GOLDEN_CROSS, (Object)cross).put((Object)EnumGraves.DIAMOND_CROSS, (Object)cross).put((Object)EnumGraves.EMERALD_CROSS, (Object)cross).put((Object)EnumGraves.LAPIS_CROSS, (Object)cross).put((Object)EnumGraves.REDSTONE_CROSS, (Object)cross).put((Object)EnumGraves.OBSIDIAN_CROSS, (Object)cross).put((Object)EnumGraves.QUARTZ_CROSS, (Object)cross).put((Object)EnumGraves.ICE_CROSS, (Object)cross).put((Object)EnumGraves.MOSSY_CROSS, (Object)cross).put((Object)EnumGraves.WOODEN_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.SANDSTONE_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.IRON_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.GOLDEN_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.DIAMOND_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.EMERALD_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.LAPIS_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.REDSTONE_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.OBSIDIAN_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.QUARTZ_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.ICE_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.MOSSY_HORISONTAL_PLATE, (Object)horisontalPlate).put((Object)EnumGraves.WOODEN_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.SANDSTONE_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.IRON_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.GOLDEN_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.DIAMOND_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.EMERALD_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.LAPIS_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.REDSTONE_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.OBSIDIAN_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.QUARTZ_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.ICE_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.MOSSY_DOG_STATUE, (Object)dogStatue).put((Object)EnumGraves.WOODEN_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.SANDSTONE_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.IRON_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.GOLDEN_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.DIAMOND_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.EMERALD_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.LAPIS_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.REDSTONE_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.OBSIDIAN_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.QUARTZ_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.ICE_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.MOSSY_CAT_STATUE, (Object)catStatue).put((Object)EnumGraves.WOODEN_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.SANDSTONE_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.IRON_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.GOLDEN_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.DIAMOND_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.EMERALD_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.LAPIS_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.REDSTONE_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.OBSIDIAN_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.QUARTZ_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.ICE_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.MOSSY_HORSE_STATUE, (Object)horseStatue).put((Object)EnumGraves.SWORD, (Object)swordGrave).build();

    public TileEntityGSGraveStoneRenderer() {
        instance = this;
    }

    @Override
    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)te;
        EnumGraves graveType = tileEntity.getGraveType();
        int meta = 0;
        if (tileEntity.func_145831_w() != null) {
            meta = tileEntity.func_145832_p();
        }
        if (graveType != EnumGraves.SWORD) {
            this.bindTextureByName(graveType.getTexture());
        }
        GL11.glPushMatrix();
        if (tileEntity.func_145831_w() == null && tileEntity.isSwordGrave()) {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 2.0f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.5f, (float)-1.5f, (float)-1.5f);
        } else {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        }
        switch (TileEntityGSGraveStoneRenderer.getGraveDirection(meta)) {
            case 0: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 1: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (tileEntity.isSwordGrave()) {
            this.renderSword(tileEntity);
        } else {
            if (tileEntity.isEnchanted()) {
                this.MODELS_MAP.get(graveType).renderEnchanted();
            } else {
                this.MODELS_MAP.get(graveType).renderAll();
            }
            if (tileEntity.hasFlower()) {
                this.renderFlower(tileEntity);
            }
        }
        GL11.glPopMatrix();
    }

    private static int getGraveDirection(int meta) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return 2;
    }

    private void renderSword(TileEntityGSGraveStone te) {
        ItemStack sword = te.getSword();
        if (te.isEnchanted() && !sword.func_77948_v()) {
            if (!sword.func_77942_o()) {
                sword.func_77982_d(new NBTTagCompound());
            }
            sword.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        EntityItem entityitem = new EntityItem(te.func_145831_w(), 0.0, 0.0, 0.0, sword);
        entityitem.field_70290_d = 0.0f;
        GL11.glTranslatef((float)0.24f, (float)0.83f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)-1.5f, (float)-1.5f);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    private void renderFlower(TileEntityGSGraveStone te) {
        EntityItem entityitem = new EntityItem(te.func_145831_w(), 0.0, 0.0, 0.0, te.getFlower());
        entityitem.field_70290_d = 0.0f;
        GL11.glTranslatef((float)0.0f, (float)1.45f, (float)-0.1f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
    }
}

