/*
 * Decompiled with CFR 0.152.
 */
package gravestone.core.event;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gravestone.block.BlockGSGraveStone;
import gravestone.block.GraveStoneHelper;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSBlock;
import gravestone.core.GSMobSpawn;
import gravestone.core.MobHandler;
import gravestone.core.logger.GravesLogger;
import gravestone.entity.monster.EntitySkullCrawler;
import gravestone.entity.monster.EntityWitherSkullCrawler;
import gravestone.entity.monster.EntityZombieSkullCrawler;
import gravestone.item.corpse.CorpseHelper;
import gravestone.item.enums.EnumCorpse;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;

public class GSEventsHandler {
    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (!GraveStoneConfig.generateGravesInLava && event.source.field_76373_n.equals("lava")) {
                return;
            }
            long spawnTime = MobHandler.getMobSpawnTime(event.entity);
            MobHandler.clearMobsSpawnTime(event.entity);
            if (GraveStoneConfig.generatePlayerGraves && event.entityLiving instanceof EntityPlayer) {
                GraveStoneHelper.createPlayerGrave((EntityPlayer)event.entity, event, spawnTime);
            } else {
                if (GraveStoneConfig.generateVillagerGraves && event.entity instanceof EntityVillager) {
                    GraveStoneHelper.createGrave(event.entity, event, CorpseHelper.getCorpse(event.entity, EnumCorpse.VILLAGER), BlockGSGraveStone.EnumGraveType.PLAYER_GRAVES, true, spawnTime);
                    return;
                }
                if (GraveStoneConfig.generatePetGraves && event.entity instanceof EntityTameable) {
                    GraveStoneHelper.createPetGrave(event.entity, event, spawnTime);
                    return;
                }
                if (GraveStoneConfig.generatePetGraves && event.entity instanceof EntityHorse) {
                    GraveStoneHelper.createHorseGrave((EntityHorse)event.entity, event, spawnTime);
                    return;
                }
            }
            if (GraveStoneConfig.spawnSkullCrawlersAtMobsDeath) {
                if (event.entity instanceof EntitySkeleton) {
                    EntitySkullCrawler crawler = GSMobSpawn.isWitherSkeleton((EntitySkeleton)event.entity) ? new EntityWitherSkullCrawler(event.entity.field_70170_p) : new EntitySkullCrawler(event.entity.field_70170_p);
                    GSMobSpawn.spawnCrawler(event.entity, crawler);
                } else if (event.entity instanceof EntityZombie) {
                    GSMobSpawn.spawnCrawler(event.entity, new EntityZombieSkullCrawler(event.entity.field_70170_p));
                }
            }
            if (event.entity instanceof EntityCreeper && ((EntityCreeper)event.entity).func_70830_n()) {
                GSBlock.memorial.dropCreeperMemorial(event.entity.field_70170_p, (int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v);
            }
        }
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && ((entity = event.entity) instanceof EntityVillager || entity instanceof EntityWolf || entity instanceof EntityOcelot || entity instanceof EntityHorse)) {
            MobHandler.setMobSpawnTime(event.entity);
        }
    }

    @SubscribeEvent
    public void worldLoading(WorldEvent.Load event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MobHandler.loadMobsSpawnTime(event.world);
            GravesLogger.setWorldDirectory(event.world.func_72860_G().func_75765_b());
        }
    }
}

