/*
 * Decompiled with CFR 0.152.
 */
package gravestone.block;

import gravestone.block.BlockGSGraveStone;
import gravestone.block.enums.EnumGraves;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSBlock;
import gravestone.core.GSMobSpawn;
import gravestone.core.compatibility.GSCompatibilityBackpacksMod;
import gravestone.core.compatibility.GSCompatibilityBattlegear;
import gravestone.core.compatibility.GSCompatibilityBaubles;
import gravestone.core.compatibility.GSCompatibilityEnderIO;
import gravestone.core.compatibility.GSCompatibilityGalacticraft;
import gravestone.core.compatibility.GSCompatibilityMariculture;
import gravestone.core.compatibility.GSCompatibilityRpgInventory;
import gravestone.core.compatibility.GSCompatibilityTheCampingMod;
import gravestone.core.compatibility.GSCompatibilityTinkerConstruct;
import gravestone.core.compatibility.GSCompatibilityisArsMagica;
import gravestone.core.logger.GSLogger;
import gravestone.item.corpse.CorpseHelper;
import gravestone.item.enums.EnumCorpse;
import gravestone.tileentity.DeathMessageInfo;
import gravestone.tileentity.TileEntityGSGraveStone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class GraveStoneHelper {
    public static ArrayList<Item> swordsList = new ArrayList<Item>(Arrays.asList(Items.field_151041_m, Items.field_151052_q, Items.field_151040_l, Items.field_151010_B, Items.field_151048_u));
    public static final Item[] GENERATED_SWORD_GRAVES = new Item[]{Items.field_151041_m, Items.field_151052_q};
    public static final EnumGraves[] GENERATED_WOODEN_GRAVES = new EnumGraves[]{EnumGraves.WOODEN_VERTICAL_PLATE, EnumGraves.WOODEN_CROSS, EnumGraves.WOODEN_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_SANDSTONE_GRAVES = new EnumGraves[]{EnumGraves.SANDSTONE_VERTICAL_PLATE, EnumGraves.SANDSTONE_CROSS, EnumGraves.SANDSTONE_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_STONE_GRAVES = new EnumGraves[]{EnumGraves.STONE_VERTICAL_PLATE, EnumGraves.STONE_CROSS, EnumGraves.STONE_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_MOSSY_GRAVES = new EnumGraves[]{EnumGraves.MOSSY_VERTICAL_PLATE, EnumGraves.MOSSY_CROSS, EnumGraves.MOSSY_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_IRON_GRAVES = new EnumGraves[]{EnumGraves.IRON_VERTICAL_PLATE, EnumGraves.IRON_CROSS, EnumGraves.IRON_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_GOLDEN_GRAVES = new EnumGraves[]{EnumGraves.GOLDEN_VERTICAL_PLATE, EnumGraves.GOLDEN_CROSS, EnumGraves.GOLDEN_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_DIAMOND_GRAVES = new EnumGraves[]{EnumGraves.DIAMOND_VERTICAL_PLATE, EnumGraves.DIAMOND_CROSS, EnumGraves.DIAMOND_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_EMERALD_GRAVES = new EnumGraves[]{EnumGraves.EMERALD_VERTICAL_PLATE, EnumGraves.EMERALD_CROSS, EnumGraves.EMERALD_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_LAPIS_GRAVES = new EnumGraves[]{EnumGraves.LAPIS_VERTICAL_PLATE, EnumGraves.LAPIS_CROSS, EnumGraves.LAPIS_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_REDSTONE_GRAVES = new EnumGraves[]{EnumGraves.REDSTONE_VERTICAL_PLATE, EnumGraves.REDSTONE_CROSS, EnumGraves.REDSTONE_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_OBSIDIAN_GRAVES = new EnumGraves[]{EnumGraves.OBSIDIAN_VERTICAL_PLATE, EnumGraves.OBSIDIAN_CROSS, EnumGraves.OBSIDIAN_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_QUARTZ_GRAVES = new EnumGraves[]{EnumGraves.QUARTZ_VERTICAL_PLATE, EnumGraves.QUARTZ_CROSS, EnumGraves.QUARTZ_HORISONTAL_PLATE};
    public static final EnumGraves[] GENERATED_ICE_GRAVES = new EnumGraves[]{EnumGraves.ICE_VERTICAL_PLATE, EnumGraves.ICE_CROSS, EnumGraves.ICE_HORISONTAL_PLATE};
    public static final EnumGraves[] PETS_GRAVES = new EnumGraves[]{EnumGraves.WOODEN_DOG_STATUE, EnumGraves.WOODEN_CAT_STATUE, EnumGraves.SANDSTONE_DOG_STATUE, EnumGraves.SANDSTONE_CAT_STATUE, EnumGraves.STONE_DOG_STATUE, EnumGraves.STONE_CAT_STATUE, EnumGraves.MOSSY_DOG_STATUE, EnumGraves.MOSSY_CAT_STATUE, EnumGraves.IRON_DOG_STATUE, EnumGraves.IRON_CAT_STATUE, EnumGraves.GOLDEN_DOG_STATUE, EnumGraves.GOLDEN_CAT_STATUE, EnumGraves.DIAMOND_DOG_STATUE, EnumGraves.DIAMOND_CAT_STATUE, EnumGraves.EMERALD_DOG_STATUE, EnumGraves.EMERALD_CAT_STATUE, EnumGraves.LAPIS_DOG_STATUE, EnumGraves.LAPIS_CAT_STATUE, EnumGraves.REDSTONE_DOG_STATUE, EnumGraves.REDSTONE_CAT_STATUE, EnumGraves.OBSIDIAN_DOG_STATUE, EnumGraves.OBSIDIAN_CAT_STATUE, EnumGraves.QUARTZ_DOG_STATUE, EnumGraves.QUARTZ_CAT_STATUE, EnumGraves.ICE_DOG_STATUE, EnumGraves.ICE_CAT_STATUE};
    public static final byte[] DOGS_GRAVES = new byte[]{(byte)EnumGraves.WOODEN_DOG_STATUE.ordinal(), (byte)EnumGraves.SANDSTONE_DOG_STATUE.ordinal(), (byte)EnumGraves.STONE_DOG_STATUE.ordinal(), (byte)EnumGraves.MOSSY_DOG_STATUE.ordinal(), (byte)EnumGraves.IRON_DOG_STATUE.ordinal(), (byte)EnumGraves.GOLDEN_DOG_STATUE.ordinal(), (byte)EnumGraves.DIAMOND_DOG_STATUE.ordinal(), (byte)EnumGraves.EMERALD_DOG_STATUE.ordinal(), (byte)EnumGraves.LAPIS_DOG_STATUE.ordinal(), (byte)EnumGraves.REDSTONE_DOG_STATUE.ordinal(), (byte)EnumGraves.OBSIDIAN_DOG_STATUE.ordinal(), (byte)EnumGraves.QUARTZ_DOG_STATUE.ordinal(), (byte)EnumGraves.ICE_DOG_STATUE.ordinal()};
    public static final EnumGraves[] CATS_GRAVES = new EnumGraves[]{EnumGraves.WOODEN_CAT_STATUE, EnumGraves.SANDSTONE_CAT_STATUE, EnumGraves.STONE_CAT_STATUE, EnumGraves.MOSSY_CAT_STATUE, EnumGraves.IRON_CAT_STATUE, EnumGraves.GOLDEN_CAT_STATUE, EnumGraves.DIAMOND_CAT_STATUE, EnumGraves.EMERALD_CAT_STATUE, EnumGraves.LAPIS_CAT_STATUE, EnumGraves.REDSTONE_CAT_STATUE, EnumGraves.OBSIDIAN_CAT_STATUE, EnumGraves.QUARTZ_CAT_STATUE, EnumGraves.ICE_CAT_STATUE};
    public static final EnumGraves[] DOG_WOODEN_GRAVES = new EnumGraves[]{EnumGraves.WOODEN_DOG_STATUE};
    public static final EnumGraves[] DOG_SANDSTONE_GRAVES = new EnumGraves[]{EnumGraves.SANDSTONE_DOG_STATUE};
    public static final EnumGraves[] DOG_STONE_GRAVES = new EnumGraves[]{EnumGraves.STONE_DOG_STATUE};
    public static final EnumGraves[] DOG_MOSSY_GRAVES = new EnumGraves[]{EnumGraves.MOSSY_DOG_STATUE};
    public static final EnumGraves[] DOG_GOLDEN_GRAVES = new EnumGraves[]{EnumGraves.GOLDEN_DOG_STATUE};
    public static final EnumGraves[] DOG_DIAMOND_GRAVES = new EnumGraves[]{EnumGraves.DIAMOND_DOG_STATUE};
    public static final EnumGraves[] DOG_OBSIDIAN_GRAVES = new EnumGraves[]{EnumGraves.OBSIDIAN_DOG_STATUE};
    public static final EnumGraves[] DOG_QUARTZ_GRAVES = new EnumGraves[]{EnumGraves.QUARTZ_DOG_STATUE};
    public static final EnumGraves[] DOG_ICE_GRAVES = new EnumGraves[]{EnumGraves.ICE_DOG_STATUE};
    public static final EnumGraves[] CAT_WOODEN_GRAVES = new EnumGraves[]{EnumGraves.WOODEN_CAT_STATUE};
    public static final EnumGraves[] CAT_SANDSTONE_GRAVES = new EnumGraves[]{EnumGraves.SANDSTONE_CAT_STATUE};
    public static final EnumGraves[] CAT_STONE_GRAVES = new EnumGraves[]{EnumGraves.STONE_CAT_STATUE};
    public static final EnumGraves[] CAT_MOSSY_GRAVES = new EnumGraves[]{EnumGraves.MOSSY_CAT_STATUE};
    public static final EnumGraves[] CAT_GOLDEN_GRAVES = new EnumGraves[]{EnumGraves.GOLDEN_CAT_STATUE};
    public static final EnumGraves[] CAT_DIAMOND_GRAVES = new EnumGraves[]{EnumGraves.DIAMOND_CAT_STATUE};
    public static final EnumGraves[] CAT_OBSIDIAN_GRAVES = new EnumGraves[]{EnumGraves.OBSIDIAN_CAT_STATUE};
    public static final EnumGraves[] CAT_QUARTZ_GRAVES = new EnumGraves[]{EnumGraves.QUARTZ_CAT_STATUE};
    public static final EnumGraves[] CAT_ICE_GRAVES = new EnumGraves[]{EnumGraves.ICE_CAT_STATUE};
    public static final EnumGraves[] HORSE_WOODEN_GRAVES = new EnumGraves[]{EnumGraves.WOODEN_HORSE_STATUE};
    public static final EnumGraves[] HORSE_SANDSTONE_GRAVES = new EnumGraves[]{EnumGraves.SANDSTONE_HORSE_STATUE};
    public static final EnumGraves[] HORSE_STONE_GRAVES = new EnumGraves[]{EnumGraves.STONE_HORSE_STATUE};
    public static final EnumGraves[] HORSE_MOSSY_GRAVES = new EnumGraves[]{EnumGraves.MOSSY_HORSE_STATUE};
    public static final EnumGraves[] HORSE_OBSIDIAN_GRAVES = new EnumGraves[]{EnumGraves.OBSIDIAN_HORSE_STATUE};
    public static final EnumGraves[] HORSE_QUARTZ_GRAVES = new EnumGraves[]{EnumGraves.QUARTZ_HORSE_STATUE};
    public static final EnumGraves[] HORSE_ICE_GRAVES = new EnumGraves[]{EnumGraves.ICE_HORSE_STATUE};
    public static final List<Block> FLOWERS_GROUND = Arrays.asList(Blocks.field_150349_c, Blocks.field_150346_d);
    public static final List<BlockFlower> FLOWERS = Arrays.asList(Blocks.field_150327_N, Blocks.field_150328_O);
    public static final List<EnumGraves> FLOWER_GRAVES = Arrays.asList(EnumGraves.WOODEN_VERTICAL_PLATE, EnumGraves.WOODEN_CROSS, EnumGraves.SANDSTONE_VERTICAL_PLATE, EnumGraves.SANDSTONE_CROSS, EnumGraves.STONE_VERTICAL_PLATE, EnumGraves.STONE_CROSS, EnumGraves.MOSSY_VERTICAL_PLATE, EnumGraves.MOSSY_CROSS, EnumGraves.IRON_VERTICAL_PLATE, EnumGraves.IRON_CROSS, EnumGraves.GOLDEN_VERTICAL_PLATE, EnumGraves.GOLDEN_CROSS, EnumGraves.DIAMOND_VERTICAL_PLATE, EnumGraves.DIAMOND_CROSS, EnumGraves.EMERALD_VERTICAL_PLATE, EnumGraves.EMERALD_CROSS, EnumGraves.LAPIS_VERTICAL_PLATE, EnumGraves.LAPIS_CROSS, EnumGraves.REDSTONE_VERTICAL_PLATE, EnumGraves.REDSTONE_CROSS, EnumGraves.OBSIDIAN_VERTICAL_PLATE, EnumGraves.OBSIDIAN_CROSS, EnumGraves.QUARTZ_VERTICAL_PLATE, EnumGraves.QUARTZ_CROSS, EnumGraves.ICE_VERTICAL_PLATE, EnumGraves.ICE_CROSS);

    private GraveStoneHelper() {
    }

    public static ItemStack oldCheckSword(List<ItemStack> items) {
        if (items != null) {
            for (ItemStack stack : items) {
                if (stack == null || !swordsList.contains(stack.func_77973_b())) continue;
                ItemStack sword = stack.func_77946_l();
                items.remove(stack);
                return sword;
            }
        }
        return null;
    }

    public static boolean isSwordGrave(byte graveType) {
        return graveType == EnumGraves.SWORD.ordinal();
    }

    public static byte getGraveType(World world, int x, int z, Random random, BlockGSGraveStone.EnumGraveType graveType) {
        switch (graveType) {
            case PLAYER_GRAVES: {
                if ((double)random.nextFloat() > 0.1) {
                    return GraveStoneHelper.getRandomGrave(GraveStoneHelper.getPlayerGraveTypes(world, x, z), random);
                }
                return (byte)EnumGraves.SWORD.ordinal();
            }
            case PETS_GRAVES: {
                ArrayList<EnumGraves> petsGravesList = new ArrayList<EnumGraves>();
                petsGravesList.addAll(GraveStoneHelper.getDogGraveTypes(world, x, z));
                petsGravesList.addAll(GraveStoneHelper.getCatGraveTypes(world, x, z));
                return GraveStoneHelper.getRandomGrave(petsGravesList, random);
            }
            case DOGS_GRAVES: {
                return GraveStoneHelper.getRandomGrave(GraveStoneHelper.getDogGraveTypes(world, x, z), random);
            }
            case CATS_GRAVES: {
                return GraveStoneHelper.getRandomGrave(GraveStoneHelper.getCatGraveTypes(world, x, z), random);
            }
        }
        if ((double)random.nextFloat() > 0.2) {
            if ((double)random.nextFloat() > 0.1) {
                return GraveStoneHelper.getRandomGrave(GraveStoneHelper.getPlayerGraveTypes(world, x, z), random);
            }
            return (byte)EnumGraves.SWORD.ordinal();
        }
        ArrayList<EnumGraves> petsGravesList = new ArrayList<EnumGraves>();
        petsGravesList.addAll(GraveStoneHelper.getDogGraveTypes(world, x, z));
        petsGravesList.addAll(GraveStoneHelper.getCatGraveTypes(world, x, z));
        return GraveStoneHelper.getRandomGrave(petsGravesList, random);
    }

    public static int getMetaDirection(int direction) {
        switch (direction) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public static boolean isPetGrave(byte graveType) {
        return Arrays.binarySearch(PETS_GRAVES, EnumGraves.getByID(graveType)) >= 0;
    }

    public static byte oldGraveTypeToSwordType(byte graveType) {
        return (byte)(graveType - 4);
    }

    public static void replaceGround(World world, int x, int y, int z) {
        Block botBlock = world.func_147439_a(x, y, z);
        if (botBlock.equals(Blocks.field_150349_c) || botBlock.equals(Blocks.field_150391_bh)) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
    }

    public static void spawnMob(World world, int x, int y, int z) {
        Entity mob;
        TileEntityGSGraveStone tileEntity;
        if (GraveStoneConfig.spawnMobAtGraveDestruction && world.field_73012_v.nextInt(10) == 0 && (tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z)) != null && (mob = GSMobSpawn.getMobEntity(world, tileEntity.getGraveType(), x, y, z)) != null) {
            GSMobSpawn.spawnMob(world, mob, x, y, z, false);
        }
    }

    public static boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return GraveStoneHelper.canPlaceBlockAt(world, world.func_147439_a(x, y, z), x, y, z);
    }

    public static boolean canPlaceBlockAt(World world, Block block, int x, int y, int z) {
        if (GraveStoneConfig.canPlaceGravesEveryWhere) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        String tool = block.getHarvestTool(meta);
        if (tool != null) {
            return tool.equals("shovel");
        }
        return false;
    }

    public static int getMetadataBasedOnRotation(int rotation) {
        if (rotation >= 315 || rotation < 45) {
            return 1;
        }
        if (rotation >= 45 && rotation < 135) {
            return 2;
        }
        if (rotation >= 135 && rotation < 225) {
            return 0;
        }
        return 3;
    }

    public static int[] findPlaceForGrave(World world, int x, int y, int z) {
        boolean canGenerateGrave = false;
        int[] coordinates = new int[3];
        int newY = GraveStoneHelper.getGround(world, x, y, z);
        if (GraveStoneHelper.canGenerateGraveAtCoordinates(world, x, newY, z)) {
            coordinates[0] = x;
            coordinates[1] = newY;
            coordinates[2] = z;
            return coordinates;
        }
        int dx = 1;
        int dz = 1;
        while (Math.abs(dx) < 9 && Math.abs(dz) < 9) {
            int newZ;
            int newX;
            if (dx < 0) {
                for (newX = x - 1; newX >= x + dx; --newX) {
                    newY = GraveStoneHelper.getGround(world, newX, y, z);
                    if (!GraveStoneHelper.canGenerateGraveAtCoordinates(world, newX, newY, z)) continue;
                    coordinates[0] = newX;
                    coordinates[1] = newY;
                    coordinates[2] = z;
                    return coordinates;
                }
            } else {
                for (newX = x + 1; newX <= x + dx; ++newX) {
                    newY = GraveStoneHelper.getGround(world, newX, y, z);
                    if (!GraveStoneHelper.canGenerateGraveAtCoordinates(world, newX, newY, z)) continue;
                    coordinates[0] = newX;
                    coordinates[1] = newY;
                    coordinates[2] = z;
                    return coordinates;
                }
            }
            x += dx;
            if (dz < 0) {
                for (newZ = z - 1; newZ >= z + dz; --newZ) {
                    newY = GraveStoneHelper.getGround(world, x, y, newZ);
                    if (!GraveStoneHelper.canGenerateGraveAtCoordinates(world, x, newY, newZ)) continue;
                    coordinates[0] = x;
                    coordinates[1] = newY;
                    coordinates[2] = newZ;
                    return coordinates;
                }
            } else {
                for (newZ = z + 1; newZ <= z + dz; ++newZ) {
                    newY = GraveStoneHelper.getGround(world, x, y, newZ);
                    if (!GraveStoneHelper.canGenerateGraveAtCoordinates(world, x, newY, newZ)) continue;
                    coordinates[0] = x;
                    coordinates[1] = newY;
                    coordinates[2] = newZ;
                    return coordinates;
                }
            }
            z += dz;
            dx = dx < 0 ? Math.abs(dx) + 1 : (dx + 1) * -1;
            if (dz < 0) {
                dz = Math.abs(dz) + 1;
                continue;
            }
            dz = (dz + 1) * -1;
        }
        return null;
    }

    private static int getGround(World world, int x, int y, int z) {
        while ((world.func_147437_c(x, y - 1, z) || world.func_147439_a(x, y - 1, z).func_149688_o().func_76224_d() || world.func_147439_a(x, y - 1, z).func_149688_o().func_76222_j()) && y > 1) {
            --y;
        }
        return y;
    }

    private static boolean canGenerateGraveAtCoordinates(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a() && (world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z).func_149688_o().func_76224_d() || world.func_147439_a(x, y, z).func_149688_o().func_76222_j());
    }

    public static void createPlayerGrave(EntityPlayer player, LivingDeathEvent event, long spawnTime) {
        if (player.field_70170_p != null && !player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && GraveStoneConfig.graveItemsCount > 0) {
            LinkedList<ItemStack> items = new LinkedList<ItemStack>();
            items.addAll(Arrays.asList(player.field_71071_by.field_70462_a));
            items.addAll(Arrays.asList(player.field_71071_by.field_70460_b));
            GSCompatibilityBattlegear.addItems(items, player);
            GSCompatibilityTheCampingMod.addItems(items, player);
            GSCompatibilityBaubles.addItems(items, player);
            GSCompatibilityMariculture.addItems(items, player);
            GSCompatibilityTinkerConstruct.addItems(items, player);
            GSCompatibilityRpgInventory.addItems(items, player);
            GSCompatibilityGalacticraft.addItems(items, player);
            GSCompatibilityBackpacksMod.addItems(items, player);
            player.field_71071_by.func_146027_a(null, -1);
            GSCompatibilityisArsMagica.getSoulboundItemsBack(items, player);
            GSCompatibilityEnderIO.getSoulboundItemsBack(items, player);
            GraveStoneHelper.createGrave((Entity)player, event, items, BlockGSGraveStone.EnumGraveType.PLAYER_GRAVES, false, spawnTime);
        } else {
            GraveStoneHelper.createGrave((Entity)player, event, null, BlockGSGraveStone.EnumGraveType.PLAYER_GRAVES, false, spawnTime);
        }
    }

    public static void createGrave(Entity entity, LivingDeathEvent event, List<ItemStack> items, BlockGSGraveStone.EnumGraveType entityType, boolean isVillager, long spawnTime) {
        int age = (int)(entity.field_70170_p.func_72820_D() - spawnTime) / 24000;
        GSBlock.graveStone.createOnDeath(entity, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v - 1, GraveStoneHelper.getDeathMessage((EntityLivingBase)entity, event.source.field_76373_n, isVillager), MathHelper.func_76141_d((float)entity.field_70177_z), items, age, entityType, event.source);
    }

    public static void createPetGrave(Entity entity, LivingDeathEvent event, long spawnTime) {
        EntityTameable pet = (EntityTameable)entity;
        if (pet.func_70909_n()) {
            if (pet instanceof EntityWolf) {
                GraveStoneHelper.createGrave(entity, event, CorpseHelper.getCorpse(entity, EnumCorpse.DOG), BlockGSGraveStone.EnumGraveType.DOGS_GRAVES, false, spawnTime);
            } else if (pet instanceof EntityOcelot) {
                GraveStoneHelper.createGrave(entity, event, CorpseHelper.getCorpse(entity, EnumCorpse.CAT), BlockGSGraveStone.EnumGraveType.CATS_GRAVES, false, spawnTime);
            }
        }
    }

    public static void createHorseGrave(EntityHorse horse, LivingDeathEvent event, long spawnTime) {
        if (horse.func_110248_bS()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.addAll(CorpseHelper.getCorpse((Entity)horse, EnumCorpse.HORSE));
            items.addAll(GraveStoneHelper.getHorseItems(horse));
            GraveStoneHelper.createGrave((Entity)horse, event, items, BlockGSGraveStone.EnumGraveType.HORSE_GRAVES, false, spawnTime);
        }
    }

    private static List<ItemStack> getHorseItems(EntityHorse horse) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        NBTTagCompound nbt = new NBTTagCompound();
        horse.func_70014_b(nbt);
        NBTTagList nbtItemsList = nbt.func_150295_c("Items", 10);
        if (horse.func_110261_ca()) {
            for (int i = 0; i < nbtItemsList.func_74745_c(); ++i) {
                items.add(ItemStack.func_77949_a((NBTTagCompound)nbtItemsList.func_150305_b(i)));
            }
            items.add(new ItemStack((Block)Blocks.field_150486_ae));
        }
        nbtItemsList = new NBTTagList();
        for (int slot = 2; slot < 17; ++slot) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74774_a("Slot", (byte)slot);
            new ItemStack(Blocks.field_150350_a).func_77955_b(nbtTagCompound);
            nbtItemsList.func_74742_a((NBTBase)nbtTagCompound);
        }
        nbt.func_82580_o("Items");
        nbt.func_74782_a("Items", (NBTBase)nbtItemsList);
        horse.func_70037_a(nbt);
        horse.func_110207_m(false);
        return items;
    }

    private static DeathMessageInfo getDeathMessage(EntityLivingBase entity, String damageType, boolean isVillager) {
        EntityLivingBase killer = entity.func_94060_bK();
        String shortString = "death.attack." + damageType;
        String fullString = shortString + ".player";
        String entityName = entity.func_70005_c_();
        if (entityName == null) {
            entityName = "entity." + EntityList.func_75621_b((Entity)entity) + ".name";
        }
        if (killer != null) {
            String killerName;
            if (killer instanceof EntityPlayer) {
                killerName = ((EntityPlayer)killer).getDisplayName();
                if (isVillager) {
                    GSLogger.logInfoGrave("Villager was killed by " + killerName);
                }
            } else {
                killerName = EntityList.func_75621_b((Entity)killer);
                killerName = killerName == null ? "entity.generic.name" : "entity." + killerName + ".name";
            }
            if (StatCollector.func_94522_b((String)fullString)) {
                return new DeathMessageInfo(entityName, fullString, killerName);
            }
            return new DeathMessageInfo(entityName, shortString, killerName);
        }
        return new DeathMessageInfo(entityName, shortString, null);
    }

    public static void addSwordInfo(NBTTagCompound nbt, ItemStack sword) {
        NBTTagCompound swordNBT = new NBTTagCompound();
        sword.func_77955_b(swordNBT);
        nbt.func_74782_a("Sword", (NBTBase)swordNBT);
    }

    public static ItemStack getSwordAsGrave(Item grave, ItemStack sword) {
        ItemStack graveStoneStack = new ItemStack(grave, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("GraveType", (byte)EnumGraves.SWORD.ordinal());
        GraveStoneHelper.addSwordInfo(nbt, sword);
        graveStoneStack.func_77982_d(nbt);
        return graveStoneStack;
    }

    public static Item getRandomSwordForGeneration(byte graveType, Random random) {
        if (graveType == EnumGraves.SWORD.ordinal()) {
            return GENERATED_SWORD_GRAVES[random.nextInt(GENERATED_SWORD_GRAVES.length)];
        }
        return null;
    }

    public static void addSwordToSwordsList(Item sword) {
        swordsList.add(sword);
    }

    public static byte getRandomGrave(List<EnumGraves> graveTypes, Random rand) {
        if (graveTypes.size() > 0) {
            return (byte)graveTypes.get(rand.nextInt(graveTypes.size())).ordinal();
        }
        return 0;
    }

    public static boolean canFlowerBePlaced(World world, int x, int y, int z, ItemStack item, TileEntityGSGraveStone te) {
        return Block.func_149634_a((Item)item.func_77973_b()).func_149718_j(world, x, y, z) && GraveStoneHelper.canFlowerBePlacedOnGrave(te);
    }

    public static boolean canFlowerBePlacedOnGrave(TileEntityGSGraveStone te) {
        return !te.isSwordGrave() && FLOWER_GRAVES.contains(te.getGraveType());
    }

    public static ArrayList<EnumGraves> getPlayerGraveTypes(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        ArrayList<EnumGraves> graveTypes = new ArrayList<EnumGraves>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            graveTypes.addAll(Arrays.asList(GENERATED_SANDSTONE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            graveTypes.addAll(Arrays.asList(GENERATED_MOSSY_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) || biomeTypesList.contains(BiomeDictionary.Type.HILLS) || biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            graveTypes.addAll(Arrays.asList(GENERATED_STONE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            graveTypes.addAll(Arrays.asList(GENERATED_WOODEN_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            graveTypes.addAll(Arrays.asList(GENERATED_ICE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            graveTypes.addAll(Arrays.asList(GENERATED_QUARTZ_GRAVES));
        }
        if (graveTypes.isEmpty()) {
            graveTypes.addAll(Arrays.asList(GENERATED_STONE_GRAVES));
        }
        return graveTypes;
    }

    public static ArrayList<EnumGraves> getDogGraveTypes(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        ArrayList<EnumGraves> graveTypes = new ArrayList<EnumGraves>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            graveTypes.addAll(Arrays.asList(DOG_SANDSTONE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            graveTypes.addAll(Arrays.asList(DOG_MOSSY_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) || biomeTypesList.contains(BiomeDictionary.Type.HILLS) || biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            graveTypes.addAll(Arrays.asList(DOG_STONE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            graveTypes.addAll(Arrays.asList(DOG_WOODEN_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            graveTypes.addAll(Arrays.asList(DOG_ICE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            graveTypes.addAll(Arrays.asList(DOG_QUARTZ_GRAVES));
        }
        if (graveTypes.isEmpty()) {
            graveTypes.addAll(Arrays.asList(DOG_STONE_GRAVES));
        }
        return graveTypes;
    }

    public static ArrayList<EnumGraves> getCatGraveTypes(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        ArrayList<EnumGraves> graveTypes = new ArrayList<EnumGraves>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            graveTypes.addAll(Arrays.asList(CAT_SANDSTONE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            graveTypes.addAll(Arrays.asList(CAT_MOSSY_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) || biomeTypesList.contains(BiomeDictionary.Type.HILLS) || biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            graveTypes.addAll(Arrays.asList(CAT_STONE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            graveTypes.addAll(Arrays.asList(CAT_WOODEN_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            graveTypes.addAll(Arrays.asList(CAT_ICE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            graveTypes.addAll(Arrays.asList(CAT_QUARTZ_GRAVES));
        }
        if (graveTypes.isEmpty()) {
            graveTypes.addAll(Arrays.asList(CAT_STONE_GRAVES));
        }
        return graveTypes;
    }

    public static ArrayList<EnumGraves> getHorseGraveTypes(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        ArrayList<EnumGraves> graveTypes = new ArrayList<EnumGraves>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            graveTypes.addAll(Arrays.asList(HORSE_SANDSTONE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            graveTypes.addAll(Arrays.asList(HORSE_MOSSY_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) || biomeTypesList.contains(BiomeDictionary.Type.HILLS) || biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            graveTypes.addAll(Arrays.asList(HORSE_STONE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            graveTypes.addAll(Arrays.asList(HORSE_WOODEN_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            graveTypes.addAll(Arrays.asList(HORSE_ICE_GRAVES));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            graveTypes.addAll(Arrays.asList(HORSE_QUARTZ_GRAVES));
        }
        if (graveTypes.isEmpty()) {
            graveTypes.addAll(Arrays.asList(HORSE_STONE_GRAVES));
        }
        return graveTypes;
    }

    public static ArrayList<EnumGraves> getPlayerGraveForDeath(DamageSource damageSource, String damageType) {
        ArrayList<EnumGraves> graveTypes = new ArrayList<EnumGraves>();
        if (GraveStoneHelper.isFireDamage(damageSource, damageType) || GraveStoneHelper.isLavaDamage(damageSource, damageType) || GraveStoneHelper.isBlastDamage(damageType) || GraveStoneHelper.isFireballDamage(damageType)) {
            graveTypes.addAll(Arrays.asList(GENERATED_OBSIDIAN_GRAVES));
        }
        return graveTypes;
    }

    public static ArrayList<EnumGraves> getDogGraveForDeath(DamageSource damageSource, String damageType) {
        ArrayList<EnumGraves> graveTypes = new ArrayList<EnumGraves>();
        if (GraveStoneHelper.isFireDamage(damageSource, damageType) || GraveStoneHelper.isLavaDamage(damageSource, damageType) || GraveStoneHelper.isBlastDamage(damageType) || GraveStoneHelper.isFireballDamage(damageType)) {
            graveTypes.addAll(Arrays.asList(DOG_OBSIDIAN_GRAVES));
        }
        return graveTypes;
    }

    public static ArrayList<EnumGraves> getCatGraveForDeath(DamageSource damageSource, String damageType) {
        ArrayList<EnumGraves> graveTypes = new ArrayList<EnumGraves>();
        if (GraveStoneHelper.isFireDamage(damageSource, damageType) || GraveStoneHelper.isLavaDamage(damageSource, damageType) || GraveStoneHelper.isBlastDamage(damageType) || GraveStoneHelper.isFireballDamage(damageType)) {
            graveTypes.addAll(Arrays.asList(CAT_OBSIDIAN_GRAVES));
        }
        return graveTypes;
    }

    public static ArrayList<EnumGraves> getHorseGraveForDeath(DamageSource damageSource, String damageType) {
        ArrayList<EnumGraves> graveTypes = new ArrayList<EnumGraves>();
        if (GraveStoneHelper.isFireDamage(damageSource, damageType) || GraveStoneHelper.isLavaDamage(damageSource, damageType) || GraveStoneHelper.isBlastDamage(damageType) || GraveStoneHelper.isFireballDamage(damageType)) {
            graveTypes.addAll(Arrays.asList(HORSE_OBSIDIAN_GRAVES));
        }
        return graveTypes;
    }

    public static ArrayList<EnumGraves> getPlayerGraveForLevel(Entity entity) {
        ArrayList<EnumGraves> graveTypes = new ArrayList<EnumGraves>();
        if (entity instanceof EntityPlayer) {
            int level = ((EntityPlayer)entity).field_71068_ca;
            if (level >= 65) {
                graveTypes.addAll(Arrays.asList(GENERATED_EMERALD_GRAVES));
            } else if (level >= 55) {
                graveTypes.addAll(Arrays.asList(GENERATED_DIAMOND_GRAVES));
            } else if (level >= 45) {
                graveTypes.addAll(Arrays.asList(GENERATED_REDSTONE_GRAVES));
            } else if (level >= 35) {
                graveTypes.addAll(Arrays.asList(GENERATED_GOLDEN_GRAVES));
            } else if (level >= 25) {
                graveTypes.addAll(Arrays.asList(GENERATED_LAPIS_GRAVES));
            } else if (level >= 15) {
                graveTypes.addAll(Arrays.asList(GENERATED_IRON_GRAVES));
            }
        }
        return graveTypes;
    }

    public static boolean isFireDamage(DamageSource damageSource, String damageType) {
        return DamageSource.field_76372_a.equals(damageSource) || DamageSource.field_76370_b.equals(damageSource) || damageType.toLowerCase().contains("nFire");
    }

    public static boolean isLavaDamage(DamageSource damageSource, String damageType) {
        return DamageSource.field_76371_c.equals(damageSource) || damageType.toLowerCase().contains("lava");
    }

    public static boolean isBlastDamage(String damageType) {
        return damageType.toLowerCase().contains("explosion");
    }

    public static boolean isFireballDamage(String damageType) {
        return damageType.toLowerCase().contains("fireball");
    }

    public static boolean isMagicDamage(DamageSource damageSource, String damageType) {
        return DamageSource.field_76376_m.equals(damageSource) || damageType.toLowerCase().contains("magic");
    }
}

