/*
 * Decompiled with CFR 0.152.
 */
package gravestone.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.block.enums.EnumSpawner;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSBlock;
import gravestone.core.GSTabs;
import gravestone.core.Resources;
import gravestone.particle.EntityGreenFlameFX;
import gravestone.tileentity.TileEntityGSSpawner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class BlockGSSpawner
extends BlockMobSpawner {
    public static final List<Byte> MOB_SPAWNERS = new ArrayList<Byte>(Arrays.asList((byte)EnumSpawner.SKELETON_SPAWNER.ordinal(), (byte)EnumSpawner.ZOMBIE_SPAWNER.ordinal()));
    public static final List<Byte> BOSS_SPAWNERS = new ArrayList<Byte>(Arrays.asList((byte)EnumSpawner.WITHER_SPAWNER.ordinal()));

    public BlockGSSpawner() {
        this.func_149663_c("Spawner");
        this.func_149711_c(5.0f);
        this.func_149715_a(0.45f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149649_H();
        this.func_149647_a(GSTabs.otherItemsTab);
        this.func_149658_d(Resources.PENTAGRAM_ICO);
        this.func_149676_a(-0.5f, 0.0f, -0.5f, 1.5f, 0.05f, 1.5f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityGSSpawner();
    }

    public int func_149645_b() {
        return GraveStoneConfig.spawnerRenderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        double xPos = (float)x + 0.5f;
        double yPos = (double)y + 0.85;
        double zPos = (float)z + 0.5f;
        double dRotation = Math.toRadians(72.0);
        double rotation = Math.toRadians(-36.0);
        double d = 1.07;
        for (int i = 0; i < 5; ++i) {
            double dx = -Math.sin(rotation) * d;
            double dz = Math.cos(rotation) * d;
            world.func_72869_a("smoke", xPos + dx, yPos, zPos + dz, 0.0, 0.0, 0.0);
            EntityGreenFlameFX entityfx = new EntityGreenFlameFX(world, xPos + dx, yPos, zPos + dz, 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityfx);
            rotation += dRotation;
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), this.func_149745_a(world.field_73012_v), this.getItemMeta(metadata)));
        for (int i = 0; i < 5; ++i) {
            if ((fortune <= 0 || world.field_73012_v.nextInt(100) >= 5 * fortune) && world.field_73012_v.nextInt(100) >= 5 * fortune) continue;
            ret.add(this.getCustomItemsDropped(metadata));
        }
        return ret;
    }

    public ItemStack getCustomItemsDropped(int meta) {
        switch (meta) {
            case 1: {
                return new ItemStack((Block)GSBlock.skullCandle, 1, 0);
            }
            case 2: {
                return new ItemStack((Block)GSBlock.skullCandle, 1, 2);
            }
        }
        return new ItemStack((Block)GSBlock.skullCandle, 1, 1);
    }

    public int getItemMeta(int metadata) {
        return 15;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return Items.field_151100_aR;
    }

    public int func_149745_a(Random random) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (byte meta : MOB_SPAWNERS) {
            list.add(new ItemStack(item, 1, (int)meta));
        }
        for (byte meta : BOSS_SPAWNERS) {
            list.add(new ItemStack(item, 1, (int)meta));
        }
    }
}

