/*
 * Decompiled with CFR 0.152.
 */
package gravestone.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.block.enums.EnumSkullCandle;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSTabs;
import gravestone.core.TimeHelper;
import gravestone.particle.EntityGreenFlameFX;
import gravestone.tileentity.TileEntityGSSkullCandle;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.api.crafting.IInfusionStabiliser;

public class BlockGSSkullCandle
extends BlockContainer
implements IInfusionStabiliser {
    public BlockGSSkullCandle() {
        super(Material.field_151594_q);
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c("Skull Candle");
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149715_a(1.0f);
        this.func_149658_d("snow");
        this.func_149647_a(GSTabs.otherItemsTab);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return GraveStoneConfig.skullCandleRenderID;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityGSSkullCandle();
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        world.func_72921_c(x, y, z, stack.func_77960_j(), 2);
        TileEntityGSSkullCandle tileEntity = (TileEntityGSSkullCandle)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            float skullRotation = entity.field_70177_z - 180.0f - 22.5f;
            if (skullRotation < 0.0f) {
                skullRotation = 360.0f + skullRotation;
            }
            tileEntity.setRotation((byte)MathHelper.func_76143_f((double)(skullRotation * 8.0f / 360.0f)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < EnumSkullCandle.values().length; i = (int)((byte)(i + 1))) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityGSSkullCandle tileEntity = (TileEntityGSSkullCandle)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            double xPos = (float)x + 0.5f;
            double yPos = (double)y + 0.85;
            double zPos = (float)z + 0.5f;
            double rotation = Math.toRadians((float)(tileEntity.getRotation() * 360) / 8.0f);
            double d = 0.07;
            double dx = -Math.sin(rotation) * d;
            double dz = Math.cos(rotation) * d;
            long dayTime = TimeHelper.getDayTime(world);
            if (dayTime < 13000L || dayTime > 23000L) {
                world.func_72869_a("flame", xPos + dx, yPos, zPos + dz, 0.0, 0.0, 0.0);
            } else {
                EntityGreenFlameFX entityfx = new EntityGreenFlameFX(world, xPos + dx, yPos, zPos + dz, 0.0, 0.0, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityfx);
            }
            world.func_72869_a("smoke", xPos + dx, yPos, zPos + dz, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean canStabaliseInfusion(World world, int x, int y, int z) {
        return true;
    }
}

