/*
 * Decompiled with CFR 0.152.
 */
package gravestone.block;

import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.ModGraveStone;
import gravestone.block.enums.EnumHangedMobs;
import gravestone.block.enums.EnumMemorials;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSTabs;
import gravestone.item.ItemGSCorpse;
import gravestone.item.corpse.VillagerCorpseHelper;
import gravestone.item.enums.EnumCorpse;
import gravestone.particle.EntityBigFlameFX;
import gravestone.tileentity.TileEntityGSMemorial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BlockGSMemorial
extends BlockContainer {
    public static final byte[] TAB_MEMORIALS = new byte[]{(byte)EnumMemorials.WOODEN_CROSS.ordinal(), (byte)EnumMemorials.SANDSTONE_CROSS.ordinal(), (byte)EnumMemorials.STONE_CROSS.ordinal(), (byte)EnumMemorials.MOSSY_CROSS.ordinal(), (byte)EnumMemorials.IRON_CROSS.ordinal(), (byte)EnumMemorials.GOLDEN_CROSS.ordinal(), (byte)EnumMemorials.DIAMOND_CROSS.ordinal(), (byte)EnumMemorials.EMERALD_CROSS.ordinal(), (byte)EnumMemorials.LAPIS_CROSS.ordinal(), (byte)EnumMemorials.REDSTONE_CROSS.ordinal(), (byte)EnumMemorials.OBSIDIAN_CROSS.ordinal(), (byte)EnumMemorials.QUARTZ_CROSS.ordinal(), (byte)EnumMemorials.ICE_CROSS.ordinal(), (byte)EnumMemorials.QUARTZ_OBELISK.ordinal(), (byte)EnumMemorials.WOODEN_STEVE_STATUE.ordinal(), (byte)EnumMemorials.SANDSTONE_STEVE_STATUE.ordinal(), (byte)EnumMemorials.STONE_STEVE_STATUE.ordinal(), (byte)EnumMemorials.MOSSY_STEVE_STATUE.ordinal(), (byte)EnumMemorials.IRON_STEVE_STATUE.ordinal(), (byte)EnumMemorials.GOLDEN_STEVE_STATUE.ordinal(), (byte)EnumMemorials.DIAMOND_STEVE_STATUE.ordinal(), (byte)EnumMemorials.EMERALD_STEVE_STATUE.ordinal(), (byte)EnumMemorials.LAPIS_STEVE_STATUE.ordinal(), (byte)EnumMemorials.REDSTONE_STEVE_STATUE.ordinal(), (byte)EnumMemorials.OBSIDIAN_STEVE_STATUE.ordinal(), (byte)EnumMemorials.QUARTZ_STEVE_STATUE.ordinal(), (byte)EnumMemorials.ICE_STEVE_STATUE.ordinal(), (byte)EnumMemorials.WOODEN_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.SANDSTONE_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.STONE_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.MOSSY_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.IRON_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.GOLDEN_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.DIAMOND_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.EMERALD_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.LAPIS_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.REDSTONE_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.OBSIDIAN_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.QUARTZ_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.ICE_VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.WOODEN_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.SANDSTONE_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.STONE_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.MOSSY_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.IRON_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.GOLDEN_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.DIAMOND_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.EMERALD_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.LAPIS_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.REDSTONE_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.OBSIDIAN_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.QUARTZ_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.ICE_ANGEL_STATUE.ordinal(), (byte)EnumMemorials.WOODEN_DOG_STATUE.ordinal(), (byte)EnumMemorials.SANDSTONE_DOG_STATUE.ordinal(), (byte)EnumMemorials.STONE_DOG_STATUE.ordinal(), (byte)EnumMemorials.MOSSY_DOG_STATUE.ordinal(), (byte)EnumMemorials.IRON_DOG_STATUE.ordinal(), (byte)EnumMemorials.GOLDEN_DOG_STATUE.ordinal(), (byte)EnumMemorials.DIAMOND_DOG_STATUE.ordinal(), (byte)EnumMemorials.EMERALD_DOG_STATUE.ordinal(), (byte)EnumMemorials.LAPIS_DOG_STATUE.ordinal(), (byte)EnumMemorials.REDSTONE_DOG_STATUE.ordinal(), (byte)EnumMemorials.OBSIDIAN_DOG_STATUE.ordinal(), (byte)EnumMemorials.QUARTZ_DOG_STATUE.ordinal(), (byte)EnumMemorials.ICE_DOG_STATUE.ordinal(), (byte)EnumMemorials.WOODEN_CAT_STATUE.ordinal(), (byte)EnumMemorials.SANDSTONE_CAT_STATUE.ordinal(), (byte)EnumMemorials.STONE_CAT_STATUE.ordinal(), (byte)EnumMemorials.MOSSY_CAT_STATUE.ordinal(), (byte)EnumMemorials.IRON_CAT_STATUE.ordinal(), (byte)EnumMemorials.GOLDEN_CAT_STATUE.ordinal(), (byte)EnumMemorials.DIAMOND_CAT_STATUE.ordinal(), (byte)EnumMemorials.EMERALD_CAT_STATUE.ordinal(), (byte)EnumMemorials.LAPIS_CAT_STATUE.ordinal(), (byte)EnumMemorials.REDSTONE_CAT_STATUE.ordinal(), (byte)EnumMemorials.OBSIDIAN_CAT_STATUE.ordinal(), (byte)EnumMemorials.QUARTZ_CAT_STATUE.ordinal(), (byte)EnumMemorials.ICE_CAT_STATUE.ordinal(), (byte)EnumMemorials.WOODEN_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.SANDSTONE_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.STONE_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.MOSSY_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.IRON_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.GOLDEN_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.DIAMOND_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.EMERALD_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.LAPIS_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.REDSTONE_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.OBSIDIAN_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.QUARTZ_CREEPER_STATUE.ordinal(), (byte)EnumMemorials.ICE_CREEPER_STATUE.ordinal()};
    public static final EnumMemorials[] WOODEN_GENERATED_MEMORIALS = new EnumMemorials[]{EnumMemorials.WOODEN_CROSS, EnumMemorials.QUARTZ_OBELISK, EnumMemorials.WOODEN_STEVE_STATUE, EnumMemorials.WOODEN_VILLAGER_STATUE, EnumMemorials.WOODEN_ANGEL_STATUE, EnumMemorials.WOODEN_DOG_STATUE, EnumMemorials.WOODEN_CAT_STATUE};
    public static final EnumMemorials[] SANDSTONE_GENERATED_MEMORIALS = new EnumMemorials[]{EnumMemorials.SANDSTONE_CROSS, EnumMemorials.QUARTZ_OBELISK, EnumMemorials.SANDSTONE_STEVE_STATUE, EnumMemorials.SANDSTONE_VILLAGER_STATUE, EnumMemorials.SANDSTONE_ANGEL_STATUE, EnumMemorials.SANDSTONE_DOG_STATUE, EnumMemorials.SANDSTONE_CAT_STATUE};
    public static final EnumMemorials[] STONE_GENERATED_MEMORIALS = new EnumMemorials[]{EnumMemorials.STONE_CROSS, EnumMemorials.QUARTZ_OBELISK, EnumMemorials.STONE_STEVE_STATUE, EnumMemorials.STONE_VILLAGER_STATUE, EnumMemorials.STONE_ANGEL_STATUE, EnumMemorials.STONE_DOG_STATUE, EnumMemorials.STONE_CAT_STATUE};
    public static final EnumMemorials[] MOSSY_GENERATED_MEMORIALS = new EnumMemorials[]{EnumMemorials.MOSSY_CROSS, EnumMemorials.QUARTZ_OBELISK, EnumMemorials.MOSSY_STEVE_STATUE, EnumMemorials.MOSSY_VILLAGER_STATUE, EnumMemorials.MOSSY_ANGEL_STATUE, EnumMemorials.MOSSY_DOG_STATUE, EnumMemorials.MOSSY_CAT_STATUE};
    public static final EnumMemorials[] QUARTZ_GENERATED_MEMORIALS = new EnumMemorials[]{EnumMemorials.QUARTZ_CROSS, EnumMemorials.QUARTZ_OBELISK, EnumMemorials.QUARTZ_STEVE_STATUE, EnumMemorials.QUARTZ_VILLAGER_STATUE, EnumMemorials.QUARTZ_ANGEL_STATUE, EnumMemorials.QUARTZ_DOG_STATUE, EnumMemorials.QUARTZ_CAT_STATUE};
    public static final EnumMemorials[] ICE_GENERATED_MEMORIALS = new EnumMemorials[]{EnumMemorials.ICE_CROSS, EnumMemorials.QUARTZ_OBELISK, EnumMemorials.ICE_STEVE_STATUE, EnumMemorials.ICE_VILLAGER_STATUE, EnumMemorials.ICE_ANGEL_STATUE, EnumMemorials.ICE_DOG_STATUE, EnumMemorials.ICE_CAT_STATUE};
    public static final EnumMemorials[] WOODEN_DOG_MEMORIALS = new EnumMemorials[]{EnumMemorials.WOODEN_DOG_STATUE};
    public static final EnumMemorials[] SANDSTONE_DOG_MEMORIALS = new EnumMemorials[]{EnumMemorials.SANDSTONE_DOG_STATUE};
    public static final EnumMemorials[] STONE_DOG_MEMORIALS = new EnumMemorials[]{EnumMemorials.STONE_DOG_STATUE};
    public static final EnumMemorials[] MOSSY_DOG_MEMORIALS = new EnumMemorials[]{EnumMemorials.MOSSY_DOG_STATUE};
    public static final EnumMemorials[] QUARTZ_DOG_MEMORIALS = new EnumMemorials[]{EnumMemorials.QUARTZ_DOG_STATUE};
    public static final EnumMemorials[] ICE_DOG_MEMORIALS = new EnumMemorials[]{EnumMemorials.ICE_DOG_STATUE};
    public static final EnumMemorials[] WOODEN_CAT_MEMORIALS = new EnumMemorials[]{EnumMemorials.WOODEN_CAT_STATUE};
    public static final EnumMemorials[] SANDSTONE_CAT_MEMORIALS = new EnumMemorials[]{EnumMemorials.SANDSTONE_CAT_STATUE};
    public static final EnumMemorials[] STONE_CAT_MEMORIALS = new EnumMemorials[]{EnumMemorials.STONE_CAT_STATUE};
    public static final EnumMemorials[] MOSSY_CAT_MEMORIALS = new EnumMemorials[]{EnumMemorials.MOSSY_CAT_STATUE};
    public static final EnumMemorials[] QUARTZ_CAT_MEMORIALS = new EnumMemorials[]{EnumMemorials.QUARTZ_CAT_STATUE};
    public static final EnumMemorials[] ICE_CAT_MEMORIALS = new EnumMemorials[]{EnumMemorials.ICE_CAT_STATUE};
    public static final EnumMemorials[] WOODEN_CREEPER_MEMORIALS = new EnumMemorials[]{EnumMemorials.WOODEN_CREEPER_STATUE};
    public static final EnumMemorials[] SANDSTONE_CREEPER_MEMORIALS = new EnumMemorials[]{EnumMemorials.SANDSTONE_CREEPER_STATUE};
    public static final EnumMemorials[] STONE_CREEPER_MEMORIALS = new EnumMemorials[]{EnumMemorials.STONE_CREEPER_STATUE};
    public static final EnumMemorials[] MOSSY_CREEPER_MEMORIALS = new EnumMemorials[]{EnumMemorials.MOSSY_CREEPER_STATUE};
    public static final EnumMemorials[] QUARTZ_CREEPER_MEMORIALS = new EnumMemorials[]{EnumMemorials.QUARTZ_CREEPER_STATUE};
    public static final EnumMemorials[] ICE_CREEPER_MEMORIALS = new EnumMemorials[]{EnumMemorials.ICE_CREEPER_STATUE};
    public static final EnumMemorials[] WOODEN_STATUES_MEMORIALS = new EnumMemorials[]{EnumMemorials.WOODEN_STEVE_STATUE, EnumMemorials.WOODEN_VILLAGER_STATUE, EnumMemorials.WOODEN_ANGEL_STATUE};
    public static final EnumMemorials[] SANDSTONE_STATUES_MEMORIALS = new EnumMemorials[]{EnumMemorials.SANDSTONE_STEVE_STATUE, EnumMemorials.SANDSTONE_VILLAGER_STATUE, EnumMemorials.SANDSTONE_ANGEL_STATUE};
    public static final EnumMemorials[] STONE_STATUES_MEMORIALS = new EnumMemorials[]{EnumMemorials.STONE_STEVE_STATUE, EnumMemorials.STONE_VILLAGER_STATUE, EnumMemorials.STONE_ANGEL_STATUE};
    public static final EnumMemorials[] MOSSY_STATUES_MEMORIALS = new EnumMemorials[]{EnumMemorials.MOSSY_STEVE_STATUE, EnumMemorials.MOSSY_VILLAGER_STATUE, EnumMemorials.MOSSY_ANGEL_STATUE};
    public static final EnumMemorials[] QUARTZ_STATUES_MEMORIALS = new EnumMemorials[]{EnumMemorials.QUARTZ_STEVE_STATUE, EnumMemorials.QUARTZ_VILLAGER_STATUE, EnumMemorials.QUARTZ_ANGEL_STATUE};
    public static final EnumMemorials[] ICE_STATUES_MEMORIALS = new EnumMemorials[]{EnumMemorials.ICE_STEVE_STATUE, EnumMemorials.ICE_VILLAGER_STATUE, EnumMemorials.ICE_ANGEL_STATUE};
    public static final EnumMemorials[] TORTURE_MEMORIALS = new EnumMemorials[]{EnumMemorials.GIBBET, EnumMemorials.STOCKS, EnumMemorials.BURNING_STAKE};

    public BlockGSMemorial() {
        super(Material.field_151576_e);
        this.field_149758_A = true;
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c("Memorial");
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(GSTabs.memorialsTab);
        this.func_149658_d("stone");
    }

    public static int getMetaDirection(int direction) {
        switch (direction) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public static byte getMemorialType(World world, int x, int z, Random random, int memorialType) {
        switch (memorialType) {
            default: {
                return BlockGSMemorial.getRandomMemorial(BlockGSMemorial.getGeneratedMemorialsTypes(world, x, z), random);
            }
            case 1: {
                return BlockGSMemorial.getRandomMemorial(BlockGSMemorial.getPetsMemorialsTypes(world, x, z), random);
            }
            case 2: {
                return BlockGSMemorial.getRandomMemorial(BlockGSMemorial.getDogsMemorialsTypes(world, x, z), random);
            }
            case 3: {
                return BlockGSMemorial.getRandomMemorial(BlockGSMemorial.getCatsMemorialsTypes(world, x, z), random);
            }
            case 4: {
                return BlockGSMemorial.getRandomMemorial(BlockGSMemorial.getCreeperMemorialsTypes(world, x, z), random);
            }
            case 5: 
        }
        return BlockGSMemorial.getRandomMemorial(BlockGSMemorial.getStatuesMemorialsTypes(world, x, z), random);
    }

    public static byte getRandomMemorial(List<EnumMemorials> memorialTypes, Random rand) {
        if (memorialTypes.size() > 0) {
            return (byte)memorialTypes.get(rand.nextInt(memorialTypes.size())).ordinal();
        }
        return 0;
    }

    public static ArrayList<EnumMemorials> getGeneratedMemorialsTypes(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        ArrayList<EnumMemorials> memorialTypes = new ArrayList<EnumMemorials>();
        if (biomeTypesList.contains(BiomeDictionary.Type.DESERT) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            memorialTypes.addAll(Arrays.asList(SANDSTONE_GENERATED_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            memorialTypes.addAll(Arrays.asList(MOSSY_GENERATED_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) || biomeTypesList.contains(BiomeDictionary.Type.HILLS) || biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            memorialTypes.addAll(Arrays.asList(STONE_GENERATED_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            memorialTypes.addAll(Arrays.asList(WOODEN_GENERATED_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FROZEN)) {
            memorialTypes.addAll(Arrays.asList(ICE_GENERATED_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            memorialTypes.addAll(Arrays.asList(QUARTZ_GENERATED_MEMORIALS));
        }
        if (memorialTypes.isEmpty()) {
            memorialTypes.addAll(Arrays.asList(STONE_GENERATED_MEMORIALS));
        }
        return memorialTypes;
    }

    public static ArrayList<EnumMemorials> getPetsMemorialsTypes(World world, int x, int z) {
        ArrayList<EnumMemorials> memorialTypes = new ArrayList<EnumMemorials>();
        memorialTypes.addAll(BlockGSMemorial.getDogsMemorialsTypes(world, x, z));
        memorialTypes.addAll(BlockGSMemorial.getCatsMemorialsTypes(world, x, z));
        return memorialTypes;
    }

    public static ArrayList<EnumMemorials> getDogsMemorialsTypes(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        ArrayList<EnumMemorials> memorialTypes = new ArrayList<EnumMemorials>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            memorialTypes.addAll(Arrays.asList(SANDSTONE_DOG_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            memorialTypes.addAll(Arrays.asList(MOSSY_DOG_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) || biomeTypesList.contains(BiomeDictionary.Type.HILLS) || biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            memorialTypes.addAll(Arrays.asList(STONE_DOG_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            memorialTypes.addAll(Arrays.asList(WOODEN_DOG_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            memorialTypes.addAll(Arrays.asList(ICE_DOG_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            memorialTypes.addAll(Arrays.asList(QUARTZ_DOG_MEMORIALS));
        }
        if (memorialTypes.isEmpty()) {
            memorialTypes.addAll(Arrays.asList(STONE_DOG_MEMORIALS));
        }
        return memorialTypes;
    }

    public static ArrayList<EnumMemorials> getCatsMemorialsTypes(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        ArrayList<EnumMemorials> memorialTypes = new ArrayList<EnumMemorials>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            memorialTypes.addAll(Arrays.asList(SANDSTONE_CAT_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            memorialTypes.addAll(Arrays.asList(MOSSY_CAT_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) || biomeTypesList.contains(BiomeDictionary.Type.HILLS) || biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            memorialTypes.addAll(Arrays.asList(STONE_CAT_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            memorialTypes.addAll(Arrays.asList(WOODEN_CAT_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            memorialTypes.addAll(Arrays.asList(ICE_CAT_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            memorialTypes.addAll(Arrays.asList(QUARTZ_CAT_MEMORIALS));
        }
        if (memorialTypes.isEmpty()) {
            memorialTypes.addAll(Arrays.asList(STONE_CAT_MEMORIALS));
        }
        return memorialTypes;
    }

    public static ArrayList<EnumMemorials> getCreeperMemorialsTypes(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        ArrayList<EnumMemorials> memorialTypes = new ArrayList<EnumMemorials>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            memorialTypes.addAll(Arrays.asList(SANDSTONE_CREEPER_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            memorialTypes.addAll(Arrays.asList(MOSSY_CREEPER_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) || biomeTypesList.contains(BiomeDictionary.Type.HILLS) || biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            memorialTypes.addAll(Arrays.asList(STONE_CREEPER_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            memorialTypes.addAll(Arrays.asList(WOODEN_CREEPER_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            memorialTypes.addAll(Arrays.asList(ICE_CREEPER_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            memorialTypes.addAll(Arrays.asList(QUARTZ_CREEPER_MEMORIALS));
        }
        if (memorialTypes.isEmpty()) {
            memorialTypes.addAll(Arrays.asList(STONE_CREEPER_MEMORIALS));
        }
        return memorialTypes;
    }

    public static ArrayList<EnumMemorials> getStatuesMemorialsTypes(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
        ArrayList<EnumMemorials> memorialTypes = new ArrayList<EnumMemorials>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            memorialTypes.addAll(Arrays.asList(SANDSTONE_STATUES_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            memorialTypes.addAll(Arrays.asList(MOSSY_STATUES_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) || biomeTypesList.contains(BiomeDictionary.Type.HILLS) || biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            memorialTypes.addAll(Arrays.asList(STONE_STATUES_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            memorialTypes.addAll(Arrays.asList(WOODEN_STATUES_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            memorialTypes.addAll(Arrays.asList(ICE_STATUES_MEMORIALS));
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            memorialTypes.addAll(Arrays.asList(QUARTZ_STATUES_MEMORIALS));
        }
        if (memorialTypes.isEmpty()) {
            memorialTypes.addAll(Arrays.asList(STONE_STATUES_MEMORIALS));
        }
        return memorialTypes;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int direction = MathHelper.func_76141_d((float)player.field_70177_z);
        if (direction < 0) {
            direction = 360 + direction;
        }
        int metadata = this.getMetadataBasedOnRotation(direction);
        world.func_72921_c(x, y, z, metadata, 2);
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)world.func_147438_o(x, y, z);
        if (tileEntity != null && itemStack.field_77990_d != null) {
            if (itemStack.field_77990_d.func_74764_b("isLocalized") && itemStack.field_77990_d.func_74767_n("isLocalized")) {
                tileEntity.getDeathTextComponent().setLocalized();
                if (itemStack.field_77990_d.func_74764_b("name") && itemStack.field_77990_d.func_74764_b("KillerName")) {
                    tileEntity.getDeathTextComponent().setName(itemStack.field_77990_d.func_74779_i("name"));
                    tileEntity.getDeathTextComponent().setKillerName(itemStack.field_77990_d.func_74779_i("KillerName"));
                }
            }
            if (itemStack.field_77990_d.func_74764_b("DeathText")) {
                tileEntity.getDeathTextComponent().setDeathText(itemStack.field_77990_d.func_74779_i("DeathText"));
            }
            if (itemStack.field_77990_d.func_74764_b("GraveType")) {
                tileEntity.setGraveType(itemStack.field_77990_d.func_74771_c("GraveType"));
            } else {
                tileEntity.setGraveType((byte)0);
            }
            if (itemStack.field_77990_d.func_74764_b("HangedMob")) {
                tileEntity.setHangedMob(EnumHangedMobs.getByID(itemStack.field_77990_d.func_74771_c("HangedMob")));
                tileEntity.setHangedVillagerProfession(itemStack.field_77990_d.func_74762_e("HangedVillagerProfession"));
            }
        }
    }

    private int getMetadataBasedOnRotation(int rotation) {
        if (rotation >= 315 || rotation < 45) {
            return 1;
        }
        if (rotation >= 45 && rotation < 135) {
            return 2;
        }
        if (rotation >= 135 && rotation < 225) {
            return 0;
        }
        return 3;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        int meta = access.func_72805_g(x, y, z);
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)access.func_147438_o(x, y, z);
        EnumMemorials memorialType = tileEntity != null ? tileEntity.getMemorialType() : EnumMemorials.STONE_CROSS;
        block0 : switch (memorialType) {
            case WOODEN_CROSS: 
            case SANDSTONE_CROSS: 
            case STONE_CROSS: 
            case MOSSY_CROSS: 
            case IRON_CROSS: 
            case GOLDEN_CROSS: 
            case DIAMOND_CROSS: 
            case EMERALD_CROSS: 
            case LAPIS_CROSS: 
            case REDSTONE_CROSS: 
            case OBSIDIAN_CROSS: 
            case QUARTZ_CROSS: 
            case ICE_CROSS: 
            case WOODEN_OBELISK: 
            case SANDSTONE_OBELISK: 
            case STONE_OBELISK: 
            case MOSSY_OBELISK: 
            case IRON_OBELISK: 
            case GOLDEN_OBELISK: 
            case DIAMOND_OBELISK: 
            case EMERALD_OBELISK: 
            case LAPIS_OBELISK: 
            case REDSTONE_OBELISK: 
            case OBSIDIAN_OBELISK: 
            case QUARTZ_OBELISK: 
            case ICE_OBELISK: {
                this.func_149676_a(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f);
                break;
            }
            case WOODEN_STEVE_STATUE: 
            case SANDSTONE_STEVE_STATUE: 
            case STONE_STEVE_STATUE: 
            case MOSSY_STEVE_STATUE: 
            case IRON_STEVE_STATUE: 
            case GOLDEN_STEVE_STATUE: 
            case DIAMOND_STEVE_STATUE: 
            case EMERALD_STEVE_STATUE: 
            case LAPIS_STEVE_STATUE: 
            case REDSTONE_STEVE_STATUE: 
            case OBSIDIAN_STEVE_STATUE: 
            case QUARTZ_STEVE_STATUE: 
            case ICE_STEVE_STATUE: 
            case WOODEN_VILLAGER_STATUE: 
            case SANDSTONE_VILLAGER_STATUE: 
            case STONE_VILLAGER_STATUE: 
            case MOSSY_VILLAGER_STATUE: 
            case IRON_VILLAGER_STATUE: 
            case GOLDEN_VILLAGER_STATUE: 
            case DIAMOND_VILLAGER_STATUE: 
            case EMERALD_VILLAGER_STATUE: 
            case LAPIS_VILLAGER_STATUE: 
            case REDSTONE_VILLAGER_STATUE: 
            case OBSIDIAN_VILLAGER_STATUE: 
            case QUARTZ_VILLAGER_STATUE: 
            case ICE_VILLAGER_STATUE: 
            case WOODEN_ANGEL_STATUE: 
            case SANDSTONE_ANGEL_STATUE: 
            case STONE_ANGEL_STATUE: 
            case MOSSY_ANGEL_STATUE: 
            case IRON_ANGEL_STATUE: 
            case GOLDEN_ANGEL_STATUE: 
            case DIAMOND_ANGEL_STATUE: 
            case EMERALD_ANGEL_STATUE: 
            case LAPIS_ANGEL_STATUE: 
            case REDSTONE_ANGEL_STATUE: 
            case OBSIDIAN_ANGEL_STATUE: 
            case QUARTZ_ANGEL_STATUE: 
            case ICE_ANGEL_STATUE: {
                this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 3.0f, 0.875f);
                break;
            }
            case WOODEN_DOG_STATUE: 
            case WOODEN_CAT_STATUE: 
            case SANDSTONE_DOG_STATUE: 
            case SANDSTONE_CAT_STATUE: 
            case STONE_DOG_STATUE: 
            case STONE_CAT_STATUE: 
            case MOSSY_DOG_STATUE: 
            case MOSSY_CAT_STATUE: 
            case IRON_DOG_STATUE: 
            case IRON_CAT_STATUE: 
            case GOLDEN_DOG_STATUE: 
            case GOLDEN_CAT_STATUE: 
            case DIAMOND_DOG_STATUE: 
            case DIAMOND_CAT_STATUE: 
            case EMERALD_DOG_STATUE: 
            case EMERALD_CAT_STATUE: 
            case LAPIS_DOG_STATUE: 
            case LAPIS_CAT_STATUE: 
            case REDSTONE_DOG_STATUE: 
            case REDSTONE_CAT_STATUE: 
            case OBSIDIAN_DOG_STATUE: 
            case OBSIDIAN_CAT_STATUE: 
            case QUARTZ_DOG_STATUE: 
            case QUARTZ_CAT_STATUE: 
            case ICE_DOG_STATUE: 
            case ICE_CAT_STATUE: {
                this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 2.0f, 0.875f);
                break;
            }
            case WOODEN_CREEPER_STATUE: 
            case SANDSTONE_CREEPER_STATUE: 
            case STONE_CREEPER_STATUE: 
            case MOSSY_CREEPER_STATUE: 
            case IRON_CREEPER_STATUE: 
            case GOLDEN_CREEPER_STATUE: 
            case DIAMOND_CREEPER_STATUE: 
            case EMERALD_CREEPER_STATUE: 
            case LAPIS_CREEPER_STATUE: 
            case REDSTONE_CREEPER_STATUE: 
            case OBSIDIAN_CREEPER_STATUE: 
            case QUARTZ_CREEPER_STATUE: 
            case ICE_CREEPER_STATUE: {
                this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 2.5f, 0.875f);
                break;
            }
            case GIBBET: 
            case BURNING_STAKE: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 2.5f, 1.0f);
                break;
            }
            case STOCKS: {
                switch (meta) {
                    case 0: 
                    case 1: {
                        this.func_149676_a(-0.5f, 0.0f, 0.0f, 1.5f, 2.0f, 1.0f);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.func_149676_a(0.0f, 0.0f, -0.5f, 1.0f, 2.0f, 1.5f);
                    }
                }
            }
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return GraveStoneConfig.memorialRenderID;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntityGSMemorial te = (TileEntityGSMemorial)world.func_147438_o(x, y, z);
        if (te != null) {
            String deathText;
            ItemStack item = player.field_71071_by.func_70448_g();
            if (item != null && item.func_77973_b() instanceof ItemGSCorpse && EnumCorpse.getById((byte)item.func_77960_j()).equals(EnumCorpse.VILLAGER) && te.getHangedMob() == EnumHangedMobs.NONE && (te.getMemorialType().equals(EnumMemorials.GIBBET) || te.getMemorialType().equals(EnumMemorials.STOCKS) || te.getMemorialType().equals(EnumMemorials.BURNING_STAKE))) {
                te.setHangedMob(EnumHangedMobs.VILLAGER);
                te.setHangedVillagerProfession(VillagerCorpseHelper.getVillagerType(item.func_77978_p()));
                --item.field_77994_a;
            }
            if (world.field_72995_K && (deathText = te.getDeathTextComponent().getDeathText()).length() != 0) {
                String name;
                if (te.getDeathTextComponent().isLocalized() && (name = ModGraveStone.proxy.getLocalizedEntityName(te.getDeathTextComponent().getName())).length() != 0) {
                    String killerName = ModGraveStone.proxy.getLocalizedEntityName(te.getDeathTextComponent().getKillerName());
                    if (killerName.length() == 0) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name}));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name, killerName}));
                    }
                    return false;
                }
                player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[0]));
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityGSMemorial(world);
    }

    public int func_149692_a(int metadata) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        Iterator it;
        Collection villagerIds;
        ItemStack villagerStack;
        ItemStack stack;
        byte mobType;
        for (int i = 0; i < TAB_MEMORIALS.length; i = (int)((byte)(i + 1))) {
            list.add(BlockGSMemorial.getMemorialItemForCreativeInventory(item, TAB_MEMORIALS[i]));
        }
        block10: for (mobType = 0; mobType < EnumHangedMobs.values().length; mobType = (byte)(mobType + 1)) {
            stack = BlockGSMemorial.getMemorialItemForCreativeInventory(item, (byte)EnumMemorials.GIBBET.ordinal());
            stack.func_77978_p().func_74774_a("HangedMob", mobType);
            switch (EnumHangedMobs.values()[mobType]) {
                case VILLAGER: {
                    for (int villagerProfession = 0; villagerProfession <= 4; villagerProfession = (int)((byte)(villagerProfession + 1))) {
                        villagerStack = stack.func_77946_l();
                        villagerStack.func_77978_p().func_74768_a("HangedVillagerProfession", villagerProfession);
                        list.add(villagerStack);
                    }
                    villagerIds = VillagerRegistry.getRegisteredVillagers();
                    it = villagerIds.iterator();
                    while (it.hasNext()) {
                        villagerStack = stack.func_77946_l();
                        villagerStack.func_77978_p().func_74768_a("HangedVillagerProfession", ((Integer)it.next()).intValue());
                        list.add(villagerStack);
                    }
                    continue block10;
                }
                default: {
                    list.add(stack);
                }
            }
        }
        block13: for (mobType = 0; mobType < EnumHangedMobs.values().length; mobType = (byte)(mobType + 1)) {
            stack = BlockGSMemorial.getMemorialItemForCreativeInventory(item, (byte)EnumMemorials.STOCKS.ordinal());
            stack.func_77978_p().func_74774_a("HangedMob", mobType);
            switch (EnumHangedMobs.values()[mobType]) {
                case VILLAGER: {
                    for (int villagerProfession = 0; villagerProfession <= 4; villagerProfession = (int)((byte)(villagerProfession + 1))) {
                        villagerStack = stack.func_77946_l();
                        villagerStack.func_77978_p().func_74768_a("HangedVillagerProfession", villagerProfession);
                        list.add(villagerStack);
                    }
                    villagerIds = VillagerRegistry.getRegisteredVillagers();
                    it = villagerIds.iterator();
                    while (it.hasNext()) {
                        villagerStack = stack.func_77946_l();
                        villagerStack.func_77978_p().func_74768_a("HangedVillagerProfession", ((Integer)it.next()).intValue());
                        list.add(villagerStack);
                    }
                    continue block13;
                }
                default: {
                    list.add(stack);
                }
            }
        }
        block16: for (mobType = 0; mobType < EnumHangedMobs.values().length; mobType = (byte)(mobType + 1)) {
            stack = BlockGSMemorial.getMemorialItemForCreativeInventory(item, (byte)EnumMemorials.BURNING_STAKE.ordinal());
            stack.func_77978_p().func_74774_a("HangedMob", mobType);
            switch (EnumHangedMobs.values()[mobType]) {
                case VILLAGER: {
                    for (int villagerProfession = 0; villagerProfession <= 4; villagerProfession = (int)((byte)(villagerProfession + 1))) {
                        villagerStack = stack.func_77946_l();
                        villagerStack.func_77978_p().func_74768_a("HangedVillagerProfession", villagerProfession);
                        list.add(villagerStack);
                    }
                    villagerIds = VillagerRegistry.getRegisteredVillagers();
                    it = villagerIds.iterator();
                    while (it.hasNext()) {
                        villagerStack = stack.func_77946_l();
                        villagerStack.func_77978_p().func_74768_a("HangedVillagerProfession", ((Integer)it.next()).intValue());
                        list.add(villagerStack);
                    }
                    continue block16;
                }
                default: {
                    list.add(stack);
                }
            }
        }
    }

    private static ItemStack getMemorialItemForCreativeInventory(Item item, byte graveType) {
        ItemStack stack = new ItemStack(item, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("GraveType", graveType);
        stack.func_77982_d(nbt);
        return stack;
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        player.func_71020_j(0.025f);
        ItemStack itemStack = EnchantmentHelper.func_77502_d((EntityLivingBase)player) ? this.getBlockItemStack(world, x, y, z) : this.getBlockItemStackWithoutInfo(world, x, y, z);
        if (itemStack != null) {
            this.func_149642_a(world, x, y, z, itemStack);
        }
    }

    private ItemStack getBlockItemStack(World world, int x, int y, int z) {
        ItemStack itemStack = this.func_149644_j(0);
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (tileEntity.getDeathTextComponent().isLocalized()) {
                nbt.func_74757_a("isLocalized", true);
                nbt.func_74778_a("name", tileEntity.getDeathTextComponent().getName());
                nbt.func_74778_a("KillerName", tileEntity.getDeathTextComponent().getKillerName());
            }
            nbt.func_74778_a("DeathText", tileEntity.getDeathTextComponent().getDeathText());
            nbt.func_74774_a("GraveType", tileEntity.getGraveTypeNum());
            nbt.func_74757_a("Enchanted", tileEntity.isEnchanted());
            nbt.func_74774_a("HangedMob", (byte)tileEntity.getHangedMob().ordinal());
            nbt.func_74768_a("HangedVillagerProfession", tileEntity.getHangedVillagerProfession());
            itemStack.func_77982_d(nbt);
        }
        return itemStack;
    }

    private ItemStack getBlockItemStackWithoutInfo(World world, int x, int y, int z) {
        ItemStack itemStack = this.func_149644_j(0);
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", tileEntity.getGraveTypeNum());
            itemStack.func_77982_d(nbt);
        }
        return itemStack;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int metadata) {
    }

    public void dropCreeperMemorial(World world, int x, int y, int z) {
        byte memorialType = BlockGSMemorial.getMemorialType(world, x, z, new Random(), 4);
        ItemStack itemStack = new ItemStack((Block)this);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("GraveType", memorialType);
        itemStack.func_77982_d(nbt);
        this.func_149642_a(world, x, y, z, itemStack);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = this.func_149644_j(0);
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)world.func_147438_o(x, y, z);
        if (tileEntity != null && itemStack != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", tileEntity.getGraveTypeNum());
            nbt.func_74774_a("HangedMob", (byte)tileEntity.getHangedMob().ordinal());
            nbt.func_74768_a("HangedVillagerProfession", tileEntity.getHangedVillagerProfession());
            itemStack.func_77982_d(nbt);
        }
        return itemStack;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity.getMemorialType() == EnumMemorials.BURNING_STAKE && tileEntity.getHangedMob() != EnumHangedMobs.NONE) {
            return 15;
        }
        return super.getLightValue(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity.getMemorialType() == EnumMemorials.BURNING_STAKE && tileEntity.getHangedMob() != EnumHangedMobs.NONE) {
            EntityBigFlameFX entityfx;
            double zPos;
            double xPos;
            int angle;
            double yPos = (double)y + 0.25;
            for (angle = 0; angle < 20; ++angle) {
                xPos = (double)x + 0.5 + Math.sin((double)angle * 0.2792) * 0.75;
                zPos = (double)z + 0.5 + Math.cos((double)angle * 0.2792) * 0.75;
                entityfx = new EntityBigFlameFX(world, xPos, yPos, zPos, 0.0, 0.0, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityfx);
            }
            yPos += 0.25;
            for (angle = 0; angle < 11; ++angle) {
                xPos = (double)x + 0.5 + Math.sin((double)angle * 0.5584) * 0.5;
                zPos = (double)z + 0.5 + Math.cos((double)angle * 0.5584) * 0.5;
                entityfx = new EntityBigFlameFX(world, xPos, yPos, zPos, 0.0, 0.0, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityfx);
            }
            yPos += 0.35;
            for (angle = 0; angle < 5; ++angle) {
                xPos = (double)x + 0.5 + Math.sin((double)angle * 1.1168) * 0.2;
                zPos = (double)z + 0.5 + Math.cos((double)angle * 1.1168) * 0.2;
                entityfx = new EntityBigFlameFX(world, xPos, yPos, zPos, 0.0, 0.0, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityfx);
                world.func_72869_a("lava", xPos, yPos, zPos, 0.0, 0.0, 0.0);
                world.func_72869_a("largesmoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
            }
        }
    }
}

