/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import forestry.api.core.ForestryAPI;
import forestry.api.storage.EnumBackpackType;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginLepidopterology;
import forestry.storage.BackpackDefinition;
import forestry.storage.items.ItemBackpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemNaturalistBackpack
extends ItemBackpack {
    private final int guiId;

    public ItemNaturalistBackpack(int guiId, BackpackDefinition definition) {
        super(definition, EnumBackpackType.APIARIST);
        this.guiId = guiId;
    }

    @Override
    public void openGui(EntityPlayer player, ItemStack itemstack) {
        player.openGui(ForestryAPI.instance, this.guiId, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    public static class BackpackDefinitionLepidopterist
    extends BackpackDefinition {
        public BackpackDefinitionLepidopterist(String name, int primaryColor) {
            super(name, primaryColor);
        }

        @Override
        public boolean isValidItem(ItemStack stack) {
            return PluginLepidopterology.butterflyInterface.isMember(stack);
        }
    }

    public static class BackpackDefinitionApiarist
    extends BackpackDefinition {
        public BackpackDefinitionApiarist(String name, int primaryColor) {
            super(name, primaryColor);
        }

        @Override
        public boolean isValidItem(ItemStack stack) {
            return PluginApiculture.beeInterface.isMember(stack);
        }
    }
}

