/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.GuiHandlerBase;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.gui.IPagedInventory;
import forestry.core.inventory.ItemInventoryBackpack;
import forestry.core.network.GuiId;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.gui.ContainerNaturalistBackpack;
import forestry.storage.gui.GuiBackpack;
import forestry.storage.gui.GuiBackpackT2;
import forestry.storage.items.ItemBackpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiHandlerStorage
extends GuiHandlerBase {
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerStorage.decodeGuiID(id);
        int guiData = GuiHandlerStorage.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case ApiaristBackpackGUI: {
                ItemStack equipped = this.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
                PagedBackpackInventory inventory = new PagedBackpackInventory(ItemBackpack.class, 125, equipped, x, y, z, cleanId);
                return new GuiNaturalistInventory(speciesRoot, player, new ContainerNaturalistBackpack(player.field_71071_by, inventory, guiData, 25), inventory, guiData, 5);
            }
            case BackpackGUI: {
                ItemStack equipped = this.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new GuiBackpack(new ContainerBackpack(player, new ItemInventoryBackpack(ItemBackpack.class, 15, equipped)));
            }
            case BackpackT2GUI: {
                ItemStack equipped = this.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new GuiBackpackT2(new ContainerBackpack(player, new ItemInventoryBackpack(ItemBackpack.class, 45, equipped)));
            }
            case LepidopteristBackpackGUI: {
                ItemStack equipped = this.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
                PagedBackpackInventory inventory = new PagedBackpackInventory(ItemBackpack.class, 125, equipped, x, y, z, id);
                return new GuiNaturalistInventory(speciesRoot, player, new ContainerNaturalistBackpack(player.field_71071_by, inventory, guiData, 25), inventory, guiData, 5);
            }
        }
        return null;
    }

    private ItemStack getBackpackItem(EntityPlayer player) {
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return null;
        }
        if (equipped.func_77973_b() instanceof ItemBackpack) {
            return equipped;
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerStorage.decodeGuiID(id);
        int guiData = GuiHandlerStorage.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case ApiaristBackpackGUI: {
                ItemStack equipped = this.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerNaturalistBackpack(player.field_71071_by, new PagedBackpackInventory(ItemBackpack.class, 125, equipped, x, y, z, cleanId), guiData, 25);
            }
            case BackpackGUI: {
                ItemStack equipped = this.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerBackpack(player, new ItemInventoryBackpack(ItemBackpack.class, 15, equipped));
            }
            case BackpackT2GUI: {
                ItemStack equipped = this.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerBackpack(player, new ItemInventoryBackpack(ItemBackpack.class, 45, equipped));
            }
            case LepidopteristBackpackGUI: {
                ItemStack equipped = this.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerNaturalistBackpack(player.field_71071_by, new PagedBackpackInventory(ItemBackpack.class, 125, equipped, x, y, z, cleanId), guiData, 25);
            }
        }
        return null;
    }

    public static class PagedBackpackInventory
    extends ItemInventoryBackpack
    implements IPagedInventory {
        private final int guiId;

        public PagedBackpackInventory(Class<? extends Item> itemClass, int size, ItemStack itemstack, int x, int y, int z, int guiId) {
            super(itemClass, size, itemstack);
            this.guiId = guiId;
        }

        @Override
        public void flipPage(EntityPlayer player, int page) {
            this.onGuiSaved(player);
            player.openGui(ForestryAPI.instance, GuiHandlerBase.encodeGuiData(this.guiId, page), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }
}

