/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.storage.IBackpackDefinition;
import forestry.core.utils.StackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class BackpackDefinition
implements IBackpackDefinition {
    private final String name;
    private final int primaryColor;
    private final int secondaryColor;
    private final ArrayList<ItemStack> validItems = new ArrayList();

    public BackpackDefinition(String name, int primaryColor) {
        this(name, primaryColor, 0xFFFFFF);
    }

    public BackpackDefinition(String name, int primaryColor, int secondaryColor) {
        this.name = name;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public String getName() {
        return "Update Forestry!";
    }

    @Override
    public String getName(ItemStack backpack) {
        NBTTagCompound nbt;
        Item item = backpack.func_77973_b();
        String display = ("" + StatCollector.func_74838_a((String)(item.func_77657_g(backpack) + ".name"))).trim();
        if (backpack.field_77990_d != null && backpack.field_77990_d.func_150297_b("display", 10) && (nbt = backpack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
            display = nbt.func_74779_i("Name");
        }
        return display;
    }

    @Override
    public int getPrimaryColour() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColour() {
        return this.secondaryColor;
    }

    @Override
    public void addValidItem(ItemStack validItem) {
        if (validItem.func_77973_b() != null) {
            this.validItems.add(validItem);
        }
    }

    @Override
    public void addValidItems(List<ItemStack> validItems) {
        for (ItemStack validItem : validItems) {
            this.addValidItem(validItem);
        }
    }

    public ArrayList<ItemStack> getValidItems() {
        return this.validItems;
    }

    @Override
    public boolean isValidItem(EntityPlayer player, ItemStack itemstack) {
        return this.isValidItem(itemstack);
    }

    @Override
    public boolean isValidItem(ItemStack itemstack) {
        for (ItemStack stack : this.getValidItems()) {
            if (!StackUtils.isCraftingEquivalent(stack, itemstack, true, false)) continue;
            return true;
        }
        return false;
    }
}

