/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameData;
import forestry.api.core.Tabs;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.StorageManager;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.fluids.Fluids;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.IResupplyHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemCrated;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginManager;
import forestry.storage.BackpackDefinition;
import forestry.storage.BackpackHelper;
import forestry.storage.CrateRegistry;
import forestry.storage.GuiHandlerStorage;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.ResupplyHandler;
import forestry.storage.items.ItemNaturalistBackpack;
import forestry.storage.proxy.ProxyStorage;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

@Plugin(pluginID="Storage", name="Storage", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.storage.description")
public class PluginStorage
extends ForestryPlugin
implements IOreDictionaryHandler {
    private static final List<ItemCrated> crates = new ArrayList<ItemCrated>();
    private static final String CONFIG_CATEGORY = "backpacks";
    @SidedProxy(clientSide="forestry.storage.proxy.ClientProxyStorage", serverSide="forestry.storage.proxy.ProxyStorage")
    public static ProxyStorage proxy;
    private final ArrayList<ItemStack> minerItems = new ArrayList();
    private final ArrayList<ItemStack> diggerItems = new ArrayList();
    private final ArrayList<ItemStack> foresterItems = new ArrayList();
    private final ArrayList<ItemStack> hunterItems = new ArrayList();
    private final ArrayList<ItemStack> adventurerItems = new ArrayList();
    private final ArrayList<ItemStack> builderItems = new ArrayList();
    private Configuration config;

    @Override
    public void preInit() {
        BackpackManager.backpackInterface = new BackpackHelper();
        BackpackManager.backpackItems = new ArrayList[6];
        BackpackManager.backpackItems[0] = this.minerItems;
        BackpackManager.backpackItems[1] = this.diggerItems;
        BackpackManager.backpackItems[2] = this.foresterItems;
        BackpackManager.backpackItems[3] = this.hunterItems;
        BackpackManager.backpackItems[4] = this.adventurerItems;
        BackpackManager.backpackItems[5] = this.builderItems;
        StorageManager.crateRegistry = new CrateRegistry();
    }

    @Override
    public void postInit() {
        PluginStorage.scanForItems();
        this.config = new Configuration();
        Property backpackConf = this.config.get("backpacks.miner.items", CONFIG_CATEGORY, "");
        backpackConf.comment = "add additional blocks and items for the miner's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Miner's Backpack", backpackConf.value, BackpackManager.definitions.get("miner"));
        backpackConf = this.config.get("backpacks.digger.items", CONFIG_CATEGORY, "");
        backpackConf.comment = "add additional blocks and items for the digger's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Digger's Backpack", backpackConf.value, BackpackManager.definitions.get("digger"));
        backpackConf = this.config.get("backpacks.forester.items", CONFIG_CATEGORY, "");
        backpackConf.comment = "add additional blocks and items for the forester's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Forester's Backpack", backpackConf.value, BackpackManager.definitions.get("forester"));
        backpackConf = this.config.get("backpacks.hunter.items", CONFIG_CATEGORY, "");
        backpackConf.comment = "add additional blocks and items for the hunter's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Hunter's Backpack", backpackConf.value, BackpackManager.definitions.get("hunter"));
        backpackConf = this.config.get("backpacks.adventurer.items", CONFIG_CATEGORY, "");
        backpackConf.comment = "add blocks and items for the adventurer's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Adventurer's Backpack", backpackConf.value, BackpackManager.definitions.get("adventurer"));
        backpackConf = this.config.get("backpacks.builder.items", CONFIG_CATEGORY, "");
        backpackConf.comment = "add blocks and items for the builder's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Builder's Backpack", backpackConf.value, BackpackManager.definitions.get("builder"));
        this.config.save();
        BackpackManager.definitions.get("miner").addValidItems(this.minerItems);
        BackpackManager.definitions.get("digger").addValidItems(this.diggerItems);
        BackpackManager.definitions.get("forester").addValidItems(this.foresterItems);
        BackpackManager.definitions.get("hunter").addValidItems(this.hunterItems);
        BackpackManager.definitions.get("adventurer").addValidItems(this.adventurerItems);
        BackpackManager.definitions.get("builder").addValidItems(this.builderItems);
    }

    public static void registerCrate(ItemCrated crate) {
        proxy.registerCrate(crate);
        crates.add(crate);
    }

    public static void createCrateRecipes() {
        for (ItemCrated crate : crates) {
            ItemStack itemStack = new ItemStack((Item)crate);
            if (crate.usesOreDict()) {
                RecipeManagers.carpenterManager.addCratingWithOreDict(itemStack);
                continue;
            }
            RecipeManagers.carpenterManager.addCrating(itemStack);
        }
    }

    public static void addBackpackItem(String pack, ItemStack stack) {
        if (stack == null) {
            return;
        }
        BackpackManager.definitions.get(pack).addValidItem(stack);
    }

    public static void addBackpackItem(String pack, Block block) {
        BackpackManager.definitions.get(pack).addValidItem(new ItemStack(block, 1, Short.MAX_VALUE));
    }

    public static void addBackpackItem(String pack, Item item) {
        BackpackManager.definitions.get(pack).addValidItem(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static void scanForItems() {
        for (Object id : Block.field_149771_c.func_148742_b()) {
            try {
                Block block = (Block)Block.field_149771_c.func_82594_a(id);
                if (block instanceof IPlantable || block instanceof IShearable || block instanceof BlockLog || block instanceof BlockMelon || block instanceof BlockPumpkin) {
                    PluginStorage.addBackpackItem("forester", block);
                }
                if (!(block instanceof BlockStairs) && block.func_149645_b() != 10 && !(block instanceof BlockFence) && block.func_149645_b() != 11 && !(block instanceof BlockFenceGate) && block.func_149645_b() != 21 && !(block instanceof BlockWall) && block.func_149645_b() != 32 && !(block instanceof BlockBasePressurePlate) && !(block instanceof BlockLever) && !(block instanceof BlockButton) && !(block instanceof BlockTorch) && !(block instanceof BlockRedstoneDiode) && !(block instanceof BlockChest) && block.func_149645_b() != 22 && !(block instanceof BlockWorkbench) && !(block instanceof BlockFurnace) && !(block instanceof BlockLadder) && block.func_149645_b() != 8 && !(block instanceof BlockTrapDoor) && !block.func_149739_a().contains("door")) continue;
                PluginStorage.addBackpackItem("builder", block);
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
        }
        for (Object id : Item.field_150901_e.func_148742_b()) {
            try {
                Item item = (Item)Item.field_150901_e.func_82594_a(id);
                if (item instanceof IPlantable) {
                    PluginStorage.addBackpackItem("forester", item);
                    continue;
                }
                if (item instanceof ItemFood) {
                    PluginStorage.addBackpackItem("hunter", item);
                    continue;
                }
                if (!(item instanceof ItemDoor)) continue;
                PluginStorage.addBackpackItem("builder", item);
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
        }
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-backpack-items")) {
            String[] tokens = message.getStringValue().split("@");
            if (tokens.length != 2) {
                Logger.getLogger("Forestry").log(Level.INFO, String.format("Received an invalid 'add-backpack-items' request %s from mod %s", message.getStringValue(), message.getSender()));
                return true;
            }
            if (!BackpackManager.definitions.containsKey(tokens[0])) {
                Logger.getLogger("Forestry").log(Level.INFO, String.format("Received an invalid 'add-backpack-items' request %s from mod %s for non-existent backpack %s.", message.getStringValue(), message.getSender(), tokens[0]));
                return true;
            }
            PluginStorage.parseBackpackItems(tokens[0] + "'s Backpack", tokens[1], BackpackManager.definitions.get(tokens[0]));
            return true;
        }
        return false;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerStorage();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerStorage();
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return new ResupplyHandler();
    }

    @Override
    protected void registerItems() {
        BackpackDefinition definition;
        ForestryItem.crate.registerItem(new ItemCrated(null, false), "crate");
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            definition = new ItemNaturalistBackpack.BackpackDefinitionApiarist("apiarist", 12882493);
            BackpackManager.definitions.put(definition.getKey(), definition);
            ForestryItem.apiaristBackpack.registerItem(new ItemNaturalistBackpack(GuiId.ApiaristBackpackGUI.ordinal(), definition).func_77637_a(Tabs.tabApiculture), "apiaristBag");
        }
        if (PluginManager.Module.LEPIDOPTEROLOGY.isEnabled()) {
            definition = new ItemNaturalistBackpack.BackpackDefinitionLepidopterist("lepidopterist", 10050353);
            BackpackManager.definitions.put(definition.getKey(), definition);
            ForestryItem.lepidopteristBackpack.registerItem(new ItemNaturalistBackpack(GuiId.LepidopteristBackpackGUI.ordinal(), definition).func_77637_a(Tabs.tabLepidopterology), "lepidopteristBag");
        }
        definition = new BackpackDefinition("miner", 3545213);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.minerBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T1), "minerBag");
        ForestryItem.minerBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T2), "minerBagT2");
        definition = new BackpackDefinition("digger", 3554501);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.diggerBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T1), "diggerBag");
        ForestryItem.diggerBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T2), "diggerBagT2");
        definition = new BackpackDefinition("forester", 3437607);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.foresterBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T1), "foresterBag");
        ForestryItem.foresterBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T2), "foresterBagT2");
        definition = new BackpackDefinition("hunter", 4268565);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.hunterBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T1), "hunterBag");
        ForestryItem.hunterBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T2), "hunterBagT2");
        definition = new BackpackDefinition("adventurer", 8370370);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.adventurerBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T1), "adventurerBag");
        ForestryItem.adventurerBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T2), "adventurerBagT2");
        definition = new BackpackDefinition("builder", 0xDD3A3A);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.builderBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T1), "builderBag");
        ForestryItem.builderBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition, EnumBackpackType.T2), "builderBagT2");
    }

    @Override
    protected void registerBackpackItems() {
        this.minerItems.add(new ItemStack(Blocks.field_150343_Z));
        this.minerItems.add(new ItemStack(Blocks.field_150365_q));
        this.minerItems.add(new ItemStack(Items.field_151044_h));
        this.minerItems.add(new ItemStack(Blocks.field_150482_ag));
        this.minerItems.add(new ItemStack(Items.field_151045_i));
        this.minerItems.add(new ItemStack(Blocks.field_150352_o));
        this.minerItems.add(new ItemStack(Items.field_151043_k));
        this.minerItems.add(new ItemStack(Blocks.field_150366_p));
        this.minerItems.add(new ItemStack(Items.field_151042_j));
        this.minerItems.add(new ItemStack(Blocks.field_150369_x));
        this.minerItems.add(new ItemStack(Blocks.field_150450_ax));
        this.minerItems.add(new ItemStack(Items.field_151137_ax));
        this.minerItems.add(new ItemStack(Items.field_151100_aR, 1, 4));
        this.minerItems.add(new ItemStack(Items.field_151114_aO));
        this.minerItems.add(new ItemStack(Items.field_151166_bC));
        this.minerItems.add(new ItemStack(Blocks.field_150484_ah));
        this.minerItems.add(new ItemStack(Blocks.field_150475_bE));
        this.minerItems.add(new ItemStack(Blocks.field_150340_R));
        this.minerItems.add(new ItemStack(Blocks.field_150339_S));
        this.minerItems.add(new ItemStack(Blocks.field_150368_y));
        this.minerItems.add(ForestryItem.bronzePickaxe.getItemStack());
        this.minerItems.add(ForestryItem.kitPickaxe.getItemStack());
        this.minerItems.add(ForestryItem.brokenBronzePickaxe.getItemStack());
        this.minerItems.add(new ItemStack(Items.field_151128_bU));
        this.minerItems.add(new ItemStack(Blocks.field_150412_bA));
        this.minerItems.add(new ItemStack(Blocks.field_150449_bY));
        this.diggerItems.add(new ItemStack(Blocks.field_150346_d));
        this.diggerItems.add(new ItemStack(Blocks.field_150347_e));
        this.diggerItems.add(new ItemStack((Block)Blocks.field_150354_m));
        this.diggerItems.add(new ItemStack(Blocks.field_150322_A));
        this.diggerItems.add(new ItemStack(Blocks.field_150351_n));
        this.diggerItems.add(new ItemStack(Items.field_151145_ak));
        this.diggerItems.add(new ItemStack(Blocks.field_150424_aL));
        this.diggerItems.add(new ItemStack(Items.field_151119_aD));
        this.diggerItems.add(new ItemStack(Blocks.field_150425_aM));
        this.diggerItems.add(ForestryItem.bronzeShovel.getItemStack());
        this.diggerItems.add(ForestryItem.kitShovel.getItemStack());
        this.diggerItems.add(ForestryItem.brokenBronzeShovel.getItemStack());
        this.foresterItems.add(new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE));
        this.foresterItems.add(new ItemStack((Block)Blocks.field_150337_Q));
        this.foresterItems.add(new ItemStack((Block)Blocks.field_150338_P));
        this.foresterItems.add(new ItemStack(Blocks.field_150364_r, 1, Short.MAX_VALUE));
        this.foresterItems.add(new ItemStack(Items.field_151014_N));
        this.foresterItems.add(new ItemStack((Block)Blocks.field_150328_O));
        this.foresterItems.add(new ItemStack((Block)Blocks.field_150327_N));
        this.foresterItems.add(new ItemStack((Block)Blocks.field_150362_t, 1, Short.MAX_VALUE));
        this.foresterItems.add(new ItemStack(Blocks.field_150434_aF));
        this.foresterItems.add(new ItemStack((Block)Blocks.field_150329_H, 1, Short.MAX_VALUE));
        this.foresterItems.add(new ItemStack(Blocks.field_150395_bd));
        this.foresterItems.add(new ItemStack(Blocks.field_150423_aK));
        this.foresterItems.add(new ItemStack(Blocks.field_150440_ba));
        this.foresterItems.add(new ItemStack(Items.field_151034_e));
        this.foresterItems.add(new ItemStack(Items.field_151153_ao));
        this.foresterItems.add(new ItemStack(Items.field_151075_bm));
        this.foresterItems.add(new ItemStack(Items.field_151080_bb));
        this.foresterItems.add(new ItemStack(Items.field_151081_bc));
        this.foresterItems.add(new ItemStack(Items.field_151015_O));
        if (PluginManager.Module.ARBORICULTURE.isEnabled()) {
            this.foresterItems.add(ForestryBlock.saplingGE.getWildcard());
        }
        this.hunterItems.add(new ItemStack(Items.field_151008_G));
        this.hunterItems.add(new ItemStack(Items.field_151016_H));
        this.hunterItems.add(new ItemStack(Items.field_151065_br));
        this.hunterItems.add(new ItemStack(Items.field_151072_bj));
        this.hunterItems.add(new ItemStack(Items.field_151103_aS));
        this.hunterItems.add(new ItemStack(Items.field_151007_F));
        this.hunterItems.add(new ItemStack(Items.field_151078_bh));
        this.hunterItems.add(new ItemStack(Items.field_151073_bk));
        this.hunterItems.add(new ItemStack(Items.field_151074_bl));
        this.hunterItems.add(new ItemStack(Items.field_151032_g));
        this.hunterItems.add(new ItemStack(Items.field_151147_al));
        this.hunterItems.add(new ItemStack(Items.field_151157_am));
        this.hunterItems.add(new ItemStack(Items.field_151082_bd));
        this.hunterItems.add(new ItemStack(Items.field_151083_be));
        this.hunterItems.add(new ItemStack(Items.field_151076_bf));
        this.hunterItems.add(new ItemStack(Items.field_151077_bg));
        this.hunterItems.add(new ItemStack(Items.field_151116_aA));
        this.hunterItems.add(new ItemStack(Items.field_151110_aK));
        this.hunterItems.add(new ItemStack(Items.field_151079_bi));
        this.hunterItems.add(new ItemStack(Items.field_151070_bp));
        this.hunterItems.add(new ItemStack(Items.field_151071_bq));
        this.hunterItems.add(new ItemStack(Items.field_151123_aH));
        this.hunterItems.add(new ItemStack(Items.field_151100_aR, 1, 0));
        this.hunterItems.add(new ItemStack(Blocks.field_150407_cf));
        this.hunterItems.add(new ItemStack(Blocks.field_150325_L));
        this.hunterItems.add(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        this.hunterItems.add(new ItemStack(Items.field_151061_bv));
        this.hunterItems.add(new ItemStack(Items.field_151064_bs));
        this.hunterItems.add(new ItemStack(Items.field_151060_bw));
        this.hunterItems.add(new ItemStack(Items.field_151115_aP));
        this.hunterItems.add(new ItemStack(Items.field_151101_aQ));
        this.hunterItems.add(new ItemStack(Items.field_151058_ca));
        this.hunterItems.add(new ItemStack((Item)Items.field_151112_aM));
        this.hunterItems.add(new ItemStack(Items.field_151057_cb));
        this.hunterItems.add(new ItemStack(Items.field_151141_av));
        this.hunterItems.add(new ItemStack(Items.field_151125_bZ));
        this.hunterItems.add(new ItemStack(Items.field_151136_bY));
        this.hunterItems.add(new ItemStack(Items.field_151138_bX));
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            this.builderItems.add(ForestryBlock.candle.getWildcard());
            this.builderItems.add(ForestryBlock.stump.getWildcard());
        }
        this.builderItems.add(new ItemStack(Blocks.field_150478_aa));
        this.builderItems.add(new ItemStack(Blocks.field_150429_aA));
        this.builderItems.add(new ItemStack(Blocks.field_150379_bu));
        this.builderItems.add(new ItemStack(Blocks.field_150417_aV, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Blocks.field_150322_A, 1, 1));
        this.builderItems.add(new ItemStack(Blocks.field_150322_A, 1, 2));
        this.builderItems.add(new ItemStack(Blocks.field_150348_b));
        this.builderItems.add(new ItemStack(Blocks.field_150336_V));
        this.builderItems.add(new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Blocks.field_150405_ch, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Blocks.field_150385_bj));
        this.builderItems.add(new ItemStack(Blocks.field_150386_bk));
        this.builderItems.add(new ItemStack(Blocks.field_150446_ar));
        this.builderItems.add(new ItemStack(Blocks.field_150476_ad));
        this.builderItems.add(new ItemStack(Blocks.field_150389_bf));
        this.builderItems.add(new ItemStack(Blocks.field_150387_bl));
        this.builderItems.add(new ItemStack(Blocks.field_150390_bg));
        this.builderItems.add(new ItemStack(Blocks.field_150359_w));
        this.builderItems.add(new ItemStack(Blocks.field_150410_aZ));
        this.builderItems.add(new ItemStack((Block)Blocks.field_150486_ae));
        this.builderItems.add(new ItemStack(Blocks.field_150462_ai));
        this.builderItems.add(new ItemStack(Blocks.field_150460_al));
        this.builderItems.add(new ItemStack(Blocks.field_150442_at));
        this.builderItems.add(new ItemStack(Blocks.field_150471_bO));
        this.builderItems.add(new ItemStack(Blocks.field_150430_aB));
        this.builderItems.add(new ItemStack(Blocks.field_150367_z));
        this.builderItems.add(new ItemStack(Blocks.field_150409_cd));
        this.builderItems.add(new ItemStack(Blocks.field_150468_ap));
        this.builderItems.add(new ItemStack(Blocks.field_150422_aJ));
        this.builderItems.add(new ItemStack(Blocks.field_150396_be));
        this.builderItems.add(new ItemStack(Blocks.field_150411_aY));
        this.builderItems.add(new ItemStack((Block)Blocks.field_150333_U, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Blocks.field_150371_ca, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Blocks.field_150370_cb));
        this.builderItems.add(new ItemStack(Blocks.field_150372_bz));
        this.builderItems.add(new ItemStack(Blocks.field_150487_bG));
        this.builderItems.add(new ItemStack(Blocks.field_150485_bF));
        this.builderItems.add(new ItemStack(Blocks.field_150481_bH));
        this.builderItems.add(new ItemStack(Blocks.field_150463_bK, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Items.field_151139_aw));
        this.builderItems.add(new ItemStack(Items.field_151135_aq));
        this.builderItems.add(new ItemStack(Items.field_151155_ap));
        this.builderItems.add(new ItemStack(Items.field_151107_aW));
        this.builderItems.add(new ItemStack(Items.field_151132_bS));
        this.builderItems.add(new ItemStack(Items.field_151160_bD));
    }

    @Override
    protected void registerRecipes() {
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            Proxies.common.addRecipe(ForestryItem.apiaristBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), "stickWood", Character.valueOf('Y'), ForestryBlock.apiculture.getItemStack(1, 1));
        }
        if (PluginManager.Module.LEPIDOPTEROLOGY.isEnabled()) {
            Proxies.common.addRecipe(ForestryItem.lepidopteristBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), "stickWood", Character.valueOf('Y'), ForestryBlock.lepidopterology.getItemStack(1, 0));
        }
        Proxies.common.addRecipe(ForestryItem.minerBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), Items.field_151042_j, Character.valueOf('Y'), Blocks.field_150486_ae);
        Proxies.common.addRecipe(ForestryItem.diggerBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), Blocks.field_150348_b, Character.valueOf('Y'), Blocks.field_150486_ae);
        Proxies.common.addRecipe(ForestryItem.foresterBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), "logWood", Character.valueOf('Y'), Blocks.field_150486_ae);
        Proxies.common.addRecipe(ForestryItem.hunterBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), Items.field_151008_G, Character.valueOf('Y'), Blocks.field_150486_ae);
        Proxies.common.addRecipe(ForestryItem.adventurerBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), Items.field_151103_aS, Character.valueOf('Y'), Blocks.field_150486_ae);
        Proxies.common.addRecipe(ForestryItem.builderBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), Items.field_151119_aD, Character.valueOf('Y'), Blocks.field_150486_ae);
        if (PluginManager.Module.FACTORY.isEnabled()) {
            RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.getFluid(1000), null, ForestryItem.minerBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.minerBackpack});
            RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.getFluid(1000), null, ForestryItem.diggerBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.diggerBackpack});
            RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.getFluid(1000), null, ForestryItem.foresterBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.foresterBackpack});
            RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.getFluid(1000), null, ForestryItem.hunterBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.hunterBackpack});
            RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.getFluid(1000), null, ForestryItem.adventurerBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.adventurerBackpack});
            RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.getFluid(1000), null, ForestryItem.builderBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.builderBackpack});
        }
    }

    @Override
    protected void registerCrates() {
    }

    private static void parseBackpackItems(String backpackIdent, String list, IBackpackDefinition target) {
        String[] parts;
        for (String part : parts = list.split("[;]+")) {
            int meta;
            if (part.isEmpty()) continue;
            String[] ident = part.split("[:]+");
            if (ident.length != 2 && ident.length != 3) {
                Proxies.log.warning("Failed to add block/item of (" + part + ") to " + backpackIdent + " since it isn't formatted properly. Suitable are <name>, <name>:<meta> or <name>:*, e.g. IC2:blockWall:*.");
                continue;
            }
            String name = ident[0] + ":" + ident[1];
            if (ident.length == 2) {
                meta = 0;
            } else {
                try {
                    meta = ident[2].equals("*") ? Short.MAX_VALUE : NumberFormat.getIntegerInstance().parse(ident[2]).intValue();
                }
                catch (ParseException e) {
                    Proxies.log.warning("Failed to add block/item of (" + part + ") to " + backpackIdent + " since its metadata isn't formatted properly. Suitable are integer values or *.");
                    continue;
                }
            }
            Item item = (Item)GameData.getItemRegistry().getRaw(name);
            if (item == null) {
                Block block = (Block)GameData.getBlockRegistry().getRaw(name);
                if (block == null || Item.func_150898_a((Block)block) == null) {
                    Proxies.log.warning("Failed to add block/item of (" + part + ") to " + backpackIdent + " since it couldn't be found.");
                    continue;
                }
                item = Item.func_150898_a((Block)block);
            }
            Proxies.log.finer("Adding block/item of (" + part + ") to " + backpackIdent + ".");
            target.addValidItem(new ItemStack(item, 1, meta));
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return this;
    }

    @Override
    public void onOreRegistration(String name, ItemStack ore) {
        if (ore == null) {
            Proxies.log.warning("An ore/item of type %s was registered with the Forge ore dictionary, however the passed itemstack is null. Someone broke it. :(", (Object)name);
            return;
        }
        if (name.startsWith("ingot")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("ore")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("gem")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("dust")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("crystal")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("cluster")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("shard")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("clump")) {
            this.minerItems.add(ore);
        } else if (name.matches("dropUranium")) {
            this.minerItems.add(ore);
        } else if (name.equals("treeLeaves") || name.equals("treeSapling") || name.equals("logWood")) {
            this.foresterItems.add(ore);
        } else if (name.equals("stairWood") || name.equals("plankWood") || name.equals("slabWood")) {
            this.builderItems.add(ore);
        } else if (name.startsWith("wood")) {
            this.foresterItems.add(ore);
        }
    }
}

