/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.recipes.RecipeManagers;
import forestry.core.GameMode;
import forestry.core.fluids.Fluids;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RecipeUtil;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="Natura", name="Natura", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.natura.description")
public class PluginNatura
extends ForestryPlugin {
    private static final String NATURA = "Natura";
    public static Block logNatura;
    public static Block logWillow;
    public static Block leavesNatura;
    public static Block saplingNatura;
    public static Block saplingNaturaRare;

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded(NATURA);
    }

    @Override
    public String getFailMessage() {
        return "Natura not found";
    }

    @Override
    public void doInit() {
        super.doInit();
        logNatura = GameRegistry.findBlock((String)NATURA, (String)"tree");
        logWillow = GameRegistry.findBlock((String)NATURA, (String)"willow");
        leavesNatura = GameRegistry.findBlock((String)NATURA, (String)"floraleaves");
        saplingNatura = GameRegistry.findBlock((String)NATURA, (String)"florasapling");
        saplingNaturaRare = GameRegistry.findBlock((String)NATURA, (String)"Rare Sapling");
        ArrayList<String> saplingItemKeys = new ArrayList<String>();
        if (saplingNatura != null) {
            saplingItemKeys.add("florasapling");
        }
        if (saplingNaturaRare != null) {
            saplingItemKeys.add("Rare Sapling");
        }
        for (String key : saplingItemKeys) {
            Item saplingItem = GameRegistry.findItem((String)NATURA, (String)key);
            ItemStack saplingWild = new ItemStack(saplingItem, 1, Short.MAX_VALUE);
            RecipeUtil.injectLeveledRecipe(saplingWild, GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
            String saplingName = GameData.getItemRegistry().func_148750_c((Object)saplingItem);
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.-1", saplingName));
        }
    }

    @Override
    protected void registerRecipes() {
        ItemStack seedBarley = GameRegistry.findItemStack((String)NATURA, (String)"seedBarley", (int)1);
        ItemStack seedCotton = GameRegistry.findItemStack((String)NATURA, (String)"seedCotton", (int)1);
        ArrayList<ItemStack> seedList = new ArrayList<ItemStack>();
        if (seedBarley != null) {
            seedList.add(seedBarley);
        }
        if (seedCotton != null) {
            seedList.add(seedCotton);
        }
        int amount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
        for (ItemStack aSeedList : seedList) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{aSeedList}, Fluids.SEEDOIL.getFluid(amount));
        }
        ItemStack berryBlight = GameRegistry.findItemStack((String)NATURA, (String)"berryBlight", (int)1);
        ItemStack berryDusk = GameRegistry.findItemStack((String)NATURA, (String)"berryDusk", (int)1);
        ItemStack berrySky = GameRegistry.findItemStack((String)NATURA, (String)"berrySting", (int)1);
        ItemStack berrySting = GameRegistry.findItemStack((String)NATURA, (String)"berrySting", (int)1);
        ItemStack berryRasp = GameRegistry.findItemStack((String)NATURA, (String)"berryRasp", (int)1);
        ItemStack berryBlue = GameRegistry.findItemStack((String)NATURA, (String)"berryBlue", (int)1);
        ItemStack berryBlack = GameRegistry.findItemStack((String)NATURA, (String)"berryBlack", (int)1);
        ItemStack berryMalo = GameRegistry.findItemStack((String)NATURA, (String)"berryMalo", (int)1);
        ArrayList<ItemStack> berries = new ArrayList<ItemStack>();
        if (berryBlight != null) {
            berries.add(berryBlight);
        }
        if (berryDusk != null) {
            berries.add(berryDusk);
        }
        if (berrySky != null) {
            berries.add(berrySky);
        }
        if (berrySting != null) {
            berries.add(berrySting);
        }
        if (berryRasp != null) {
            berries.add(berryRasp);
        }
        if (berryBlue != null) {
            berries.add(berryBlue);
        }
        if (berryBlack != null) {
            berries.add(berryBlack);
        }
        if (berryMalo != null) {
            berries.add(berryMalo);
        }
        amount = (amount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") / 25) > 1 ? amount : 1;
        for (ItemStack berry : berries) {
            RecipeManagers.squeezerManager.addRecipe(3, new ItemStack[]{berry}, Fluids.JUICE.getFluid(amount));
        }
        ItemStack itemBarley = GameRegistry.findItemStack((String)NATURA, (String)"barleyFood", (int)1);
        if (itemBarley != null) {
            RecipeUtil.injectLeveledRecipe(itemBarley, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
    }
}

